/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.hbdmlinear.api;

import com.google.common.collect.ImmutableList;
import com.google.common.io.BaseEncoding;
import io.contek.invoker.commons.ApiContext;
import io.contek.invoker.commons.actor.IActor;
import io.contek.invoker.commons.actor.IActorFactory;
import io.contek.invoker.commons.actor.SimpleActorFactory;
import io.contek.invoker.commons.actor.http.IHttpClientFactory;
import io.contek.invoker.commons.actor.http.IHttpContext;
import io.contek.invoker.commons.actor.http.SimpleHttpClientFactory;
import io.contek.invoker.commons.actor.ratelimit.IRateLimitQuotaInterceptor;
import io.contek.invoker.commons.actor.ratelimit.IRateLimitThrottleFactory;
import io.contek.invoker.commons.actor.ratelimit.LimitType;
import io.contek.invoker.commons.actor.ratelimit.LimiterManagers;
import io.contek.invoker.commons.actor.ratelimit.RateLimitRule;
import io.contek.invoker.commons.actor.ratelimit.SimpleRateLimitThrottleFactory;
import io.contek.invoker.commons.actor.ratelimit.TypedPermitRequest;
import io.contek.invoker.commons.rest.RestContext;
import io.contek.invoker.commons.websocket.WebSocketContext;
import io.contek.invoker.hbdmlinear.api.rest.market.MarketRestApi;
import io.contek.invoker.hbdmlinear.api.rest.user.UserRestApi;
import io.contek.invoker.hbdmlinear.api.websocket.market.MarketNotificationWebSocketApi;
import io.contek.invoker.hbdmlinear.api.websocket.market.MarketWebSocketApi;
import io.contek.invoker.hbdmlinear.api.websocket.user.UserWebSocketApi;
import io.contek.invoker.security.ApiKey;
import io.contek.invoker.security.ICredentialFactory;
import io.contek.invoker.security.SecretKeyAlgorithm;
import io.contek.invoker.security.SimpleCredentialFactory;
import io.contek.ursa.cache.LimiterManager;
import java.time.Duration;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ApiFactory {
    public static final ApiContext MAIN_NET_CONTEXT = ApiContext.newBuilder().setRestContext(RestContext.forBaseUrl((String)"https://api.hbdm.com")).setWebSocketContext(WebSocketContext.forBaseUrl((String)"wss://api.hbdm.com")).build();
    public static final ApiContext INSECURE_MAIN_NET_CONTEXT = ApiContext.newBuilder().setRestContext(RestContext.forBaseUrl((String)"http://api.hbdm.com")).setWebSocketContext(WebSocketContext.forBaseUrl((String)"ws://api.hbdm.com")).build();
    public static final ApiContext BTCGATEWAY_CONTEXT = ApiContext.newBuilder().setRestContext(RestContext.forBaseUrl((String)"https://api.btcgateway.pro")).setWebSocketContext(WebSocketContext.forBaseUrl((String)"wss://api.btcgateway.pro")).build();
    public static final ApiContext INSECURE_BTCGATEWAY_CONTEXT = ApiContext.newBuilder().setRestContext(RestContext.forBaseUrl((String)"http://api.btcgateway.pro")).setWebSocketContext(WebSocketContext.forBaseUrl((String)"ws://api.btcgateway.pro")).build();
    private final ApiContext context;
    private final IActorFactory actorFactory;

    private ApiFactory(ApiContext context, IActorFactory actorFactory) {
        this.context = context;
        this.actorFactory = actorFactory;
    }

    public static ApiFactory getMainNet() {
        return ApiFactory.fromContext(MAIN_NET_CONTEXT);
    }

    public static ApiFactory getInsecureMainNet() {
        return ApiFactory.fromContext(INSECURE_MAIN_NET_CONTEXT);
    }

    public static ApiFactory getBtcGateway() {
        return ApiFactory.fromContext(BTCGATEWAY_CONTEXT);
    }

    public static ApiFactory getInsecureBtcGateway() {
        return ApiFactory.fromContext(INSECURE_BTCGATEWAY_CONTEXT);
    }

    public static ApiFactory fromContext(ApiContext context) {
        return new ApiFactory(context, (IActorFactory)ApiFactory.createActorFactory((List<IRateLimitQuotaInterceptor>)context.getInterceptors()));
    }

    public SelectingRestApi rest() {
        return new SelectingRestApi();
    }

    public SelectingWebSocketApi ws() {
        return new SelectingWebSocketApi();
    }

    private static SimpleActorFactory createActorFactory(List<IRateLimitQuotaInterceptor> interceptors) {
        return SimpleActorFactory.newBuilder().setCredentialFactory((ICredentialFactory)ApiFactory.createCredentialFactory()).setHttpClientFactory((IHttpClientFactory)SimpleHttpClientFactory.getInstance()).setRateLimitThrottleFactory((IRateLimitThrottleFactory)SimpleRateLimitThrottleFactory.create((LimiterManager)ApiFactory.createLimiterManager(), interceptors)).build();
    }

    private static SimpleCredentialFactory createCredentialFactory() {
        return SimpleCredentialFactory.newBuilder().setAlgorithm(SecretKeyAlgorithm.HMAC_SHA256).setEncoding(BaseEncoding.base64()).build();
    }

    private static LimiterManager createLimiterManager() {
        return LimiterManagers.forRules((RateLimitRule[])new RateLimitRule[]{RateLimits.IP_REST_PUBLIC_MARKET_DATA_REQUEST_RULE, RateLimits.IP_REST_PUBLIC_NON_MARKET_DATA_REQUEST_RULE, RateLimits.API_KEY_REST_PRIVATE_READ_REQUEST_RULE, RateLimits.API_KEY_REST_PRIVATE_WRITE_REQUEST_RULE, RateLimits.IP_WEB_SOCKET_CONNECTION_RULE});
    }

    @ThreadSafe
    public final class SelectingRestApi {
        private SelectingRestApi() {
        }

        public MarketRestApi market() {
            RestContext restContext = ApiFactory.this.context.getRestContext();
            IActor actor = ApiFactory.this.actorFactory.create(null, (IHttpContext)restContext);
            return new MarketRestApi(actor, restContext);
        }

        public UserRestApi user(ApiKey apiKey) {
            RestContext restContext = ApiFactory.this.context.getRestContext();
            IActor actor = ApiFactory.this.actorFactory.create(apiKey, (IHttpContext)restContext);
            return new UserRestApi(actor, restContext);
        }
    }

    @ThreadSafe
    public final class SelectingWebSocketApi {
        private SelectingWebSocketApi() {
        }

        public MarketWebSocketApi market() {
            WebSocketContext wsContext = ApiFactory.this.context.getWebSocketContext();
            IActor actor = ApiFactory.this.actorFactory.create(null, (IHttpContext)wsContext);
            return new MarketWebSocketApi(actor, wsContext);
        }

        public MarketNotificationWebSocketApi marketNotification() {
            WebSocketContext wsContext = ApiFactory.this.context.getWebSocketContext();
            IActor actor = ApiFactory.this.actorFactory.create(null, (IHttpContext)wsContext);
            return new MarketNotificationWebSocketApi(actor, wsContext);
        }

        public UserWebSocketApi user(ApiKey apiKey) {
            WebSocketContext wsContext = ApiFactory.this.context.getWebSocketContext();
            IActor actor = ApiFactory.this.actorFactory.create(apiKey, (IHttpContext)wsContext);
            return new UserWebSocketApi(actor, ApiFactory.this.context.getWebSocketContext());
        }
    }

    @Immutable
    public static final class RateLimits {
        public static final RateLimitRule IP_REST_PUBLIC_MARKET_DATA_REQUEST_RULE = RateLimitRule.newBuilder().setName("ip_rest_public_market_data_request_rule").setType(LimitType.IP).setMaxPermits(800).setResetPeriod(Duration.ofSeconds(1L)).build();
        public static final RateLimitRule IP_REST_PUBLIC_NON_MARKET_DATA_REQUEST_RULE = RateLimitRule.newBuilder().setName("ip_rest_public_non_market_data_request_rule").setType(LimitType.IP).setMaxPermits(120).setResetPeriod(Duration.ofSeconds(3L)).build();
        public static final RateLimitRule API_KEY_REST_PRIVATE_READ_REQUEST_RULE = RateLimitRule.newBuilder().setName("api_key_rest_private_read_request_rule").setType(LimitType.API_KEY).setMaxPermits(36).setResetPeriod(Duration.ofSeconds(3L)).build();
        public static final RateLimitRule API_KEY_REST_PRIVATE_WRITE_REQUEST_RULE = RateLimitRule.newBuilder().setName("api_key_rest_private_write_request_rule").setType(LimitType.API_KEY).setMaxPermits(36).setResetPeriod(Duration.ofSeconds(3L)).build();
        public static final RateLimitRule IP_WEB_SOCKET_CONNECTION_RULE = RateLimitRule.newBuilder().setName("ip_web_socket_connection_rule").setType(LimitType.IP).setMaxPermits(50).setResetPeriod(Duration.ofSeconds(1L)).build();
        public static final ImmutableList<TypedPermitRequest> ONE_IP_REST_PUBLIC_MARKET_DATA_REQUEST = ImmutableList.of((Object)IP_REST_PUBLIC_MARKET_DATA_REQUEST_RULE.forPermits(1));
        public static final ImmutableList<TypedPermitRequest> ONE_IP_REST_PUBLIC_NON_MARKET_DATA_REQUEST = ImmutableList.of((Object)IP_REST_PUBLIC_NON_MARKET_DATA_REQUEST_RULE.forPermits(1));
        public static final ImmutableList<TypedPermitRequest> ONE_API_KEY_REST_PRIVATE_READ_REQUEST = ImmutableList.of((Object)API_KEY_REST_PRIVATE_READ_REQUEST_RULE.forPermits(1));
        public static final ImmutableList<TypedPermitRequest> ONE_API_KEY_REST_PRIVATE_WRITE_REQUEST = ImmutableList.of((Object)API_KEY_REST_PRIVATE_WRITE_REQUEST_RULE.forPermits(1));
        public static final ImmutableList<TypedPermitRequest> ONE_IP_WEB_SOCKET_CONNECTION_REQUEST = ImmutableList.of((Object)IP_WEB_SOCKET_CONNECTION_RULE.forPermits(1));

        private RateLimits() {
        }
    }
}

