/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.hbdmlinear.api.rest;

import com.google.common.collect.ImmutableList;
import com.google.common.net.UrlEscapers;
import io.contek.invoker.commons.actor.IActor;
import io.contek.invoker.commons.actor.ratelimit.TypedPermitRequest;
import io.contek.invoker.commons.rest.BaseRestRequest;
import io.contek.invoker.commons.rest.RestCall;
import io.contek.invoker.commons.rest.RestContext;
import io.contek.invoker.commons.rest.RestMediaBody;
import io.contek.invoker.commons.rest.RestMediaType;
import io.contek.invoker.commons.rest.RestMethod;
import io.contek.invoker.commons.rest.RestParams;
import io.contek.invoker.security.ICredential;
import java.net.URI;
import java.time.Clock;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class RestRequest<R>
extends BaseRestRequest<R> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneOffset.UTC);
    private final RestContext context;
    private final Clock clock;

    protected RestRequest(IActor actor, RestContext context) {
        super(actor);
        this.context = context;
        this.clock = actor.getClock();
    }

    protected abstract RestMethod getMethod();

    protected abstract String getEndpointPath();

    protected abstract RestParams getParams();

    protected abstract ImmutableList<TypedPermitRequest> getRequiredQuotas();

    protected final RestCall createCall(ICredential credential) {
        RestMethod method = this.getMethod();
        switch (method) {
            case GET: 
            case DELETE: {
                return RestCall.newBuilder().setUrl(this.generateUrl(method, this.getEndpointPath(), this.getParams(), credential)).setMethod(method).build();
            }
            case POST: 
            case PUT: {
                RestMediaBody body = RestMediaType.JSON.createBody(this.getParams());
                return RestCall.newBuilder().setUrl(this.generateUrl(method, this.getEndpointPath(), RestParams.empty(), credential)).setMethod(method).setBody(body).build();
            }
        }
        throw new IllegalStateException(this.getMethod().name());
    }

    private String generateUrl(RestMethod method, String endpointPath, RestParams endpointParams, ICredential credential) {
        String paramString = credential.isAnonymous() ? this.generateParamString(endpointParams) : this.generateSignedParamString(method, endpointPath, endpointParams, credential);
        return this.context.getBaseUrl() + endpointPath + paramString;
    }

    private String generateParamString(RestParams params) {
        if (params.isEmpty()) {
            return "";
        }
        return "?" + params.getQueryString(UrlEscapers.urlFormParameterEscaper());
    }

    private String generateSignedParamString(RestMethod method, String path, RestParams params, ICredential credential) {
        RestParams.Builder builder = params.toBuilder();
        builder.add("AccessKeyId", credential.getApiKeyId());
        builder.add("SignatureMethod", credential.getAlgorithm().getAlgorithmName());
        builder.add("SignatureVersion", 2L);
        builder.add("Timestamp", FORMATTER.format(this.clock.instant().with(ChronoField.MILLI_OF_SECOND, 0L)));
        RestParams withIdentity = builder.build(true);
        String queryString = withIdentity.getQueryString(UrlEscapers.urlFormParameterEscaper());
        String payload = String.join((CharSequence)"\n", method.name(), URI.create(this.context.getBaseUrl()).getHost(), path, queryString);
        String sign = credential.sign(payload);
        return "?" + queryString + "&Signature=" + UrlEscapers.urlFormParameterEscaper().escape(sign);
    }
}

