/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.hbdmlinear.api.websocket.common.marketdata;

import io.contek.invoker.commons.websocket.AnyWebSocketMessage;
import io.contek.invoker.commons.websocket.BaseWebSocketChannel;
import io.contek.invoker.commons.websocket.SubscriptionState;
import io.contek.invoker.commons.websocket.WebSocketSession;
import io.contek.invoker.hbdmlinear.api.websocket.common.marketdata.MarketDataWebSocketChannelId;
import io.contek.invoker.hbdmlinear.api.websocket.common.marketdata.MarketDataWebSocketChannelMessage;
import io.contek.invoker.hbdmlinear.api.websocket.common.marketdata.MarketDataWebSocketConfirmation;
import io.contek.invoker.hbdmlinear.api.websocket.common.marketdata.MarketDataWebSocketRequestIdGenerator;
import io.contek.invoker.hbdmlinear.api.websocket.common.marketdata.MarketDataWebSocketSubscribeConfirmation;
import io.contek.invoker.hbdmlinear.api.websocket.common.marketdata.MarketDataWebSocketUnsubscribeConfirmation;
import io.contek.invoker.hbdmlinear.api.websocket.common.marketdata.MarketDataWebSocketUnsubscribeRequest;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class MarketDataMarketWebSocketChannel<Id extends MarketDataWebSocketChannelId<Message>, Message extends MarketDataWebSocketChannelMessage>
extends BaseWebSocketChannel<Id, Message> {
    private final Class<Message> type;
    private final MarketDataWebSocketRequestIdGenerator requestIdGenerator;

    protected MarketDataMarketWebSocketChannel(Id id, Class<Message> type, MarketDataWebSocketRequestIdGenerator requestIdGenerator) {
        super(id);
        this.type = type;
        this.requestIdGenerator = requestIdGenerator;
    }

    public final Class<Message> getMessageType() {
        return this.type;
    }

    protected final SubscriptionState unsubscribe(WebSocketSession session) {
        MarketDataWebSocketChannelId id = (MarketDataWebSocketChannelId)this.getId();
        MarketDataWebSocketUnsubscribeRequest request = new MarketDataWebSocketUnsubscribeRequest();
        request.unsub = id.getChannel();
        request.id = this.generateNexRequestId();
        session.send((AnyWebSocketMessage)request);
        return SubscriptionState.UNSUBSCRIBING;
    }

    @Nullable
    protected final SubscriptionState getState(AnyWebSocketMessage message) {
        MarketDataWebSocketConfirmation confirmation;
        MarketDataWebSocketChannelId id;
        if (message instanceof MarketDataWebSocketSubscribeConfirmation) {
            id = (MarketDataWebSocketChannelId)this.getId();
            confirmation = (MarketDataWebSocketSubscribeConfirmation)message;
            if (confirmation.subbed.equals(id.getChannel())) {
                if (!"ok".equals(confirmation.status)) {
                    throw new IllegalStateException(confirmation.status);
                }
                return SubscriptionState.SUBSCRIBED;
            }
        }
        if (message instanceof MarketDataWebSocketUnsubscribeConfirmation) {
            id = (MarketDataWebSocketChannelId)this.getId();
            confirmation = (MarketDataWebSocketUnsubscribeConfirmation)message;
            if (((MarketDataWebSocketUnsubscribeConfirmation)confirmation).unsubbed.equals(id.getChannel())) {
                if (!"ok".equals(((MarketDataWebSocketUnsubscribeConfirmation)confirmation).status)) {
                    throw new IllegalStateException(((MarketDataWebSocketUnsubscribeConfirmation)confirmation).status);
                }
                return SubscriptionState.UNSUBSCRIBED;
            }
        }
        return null;
    }

    protected final void reset() {
    }

    protected final String generateNexRequestId() {
        return this.requestIdGenerator.generateNext();
    }
}

