/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.hbdmlinear.api.websocket.common.marketdata;

import com.google.common.io.CharStreams;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.contek.invoker.commons.websocket.AnyWebSocketMessage;
import io.contek.invoker.commons.websocket.IWebSocketComponent;
import io.contek.invoker.commons.websocket.WebSocketBinaryMessageParser;
import io.contek.invoker.hbdmlinear.api.websocket.common.marketdata.MarketDataMarketWebSocketChannel;
import io.contek.invoker.hbdmlinear.api.websocket.common.marketdata.MarketDataWebSocketChannelId;
import io.contek.invoker.hbdmlinear.api.websocket.common.marketdata.MarketDataWebSocketChannelMessage;
import io.contek.invoker.hbdmlinear.api.websocket.common.marketdata.MarketDataWebSocketPing;
import io.contek.invoker.hbdmlinear.api.websocket.common.marketdata.MarketDataWebSocketSubscribeConfirmation;
import io.contek.invoker.hbdmlinear.api.websocket.common.marketdata.MarketDataWebSocketUnsubscribeConfirmation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class MarketDataWebSocketMessageParser
extends WebSocketBinaryMessageParser {
    private final Gson gson = new Gson();
    private final Map<String, Class<? extends MarketDataWebSocketChannelMessage>> channelMessageTypes = new HashMap<String, Class<? extends MarketDataWebSocketChannelMessage>>();

    MarketDataWebSocketMessageParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(IWebSocketComponent component) {
        if (!(component instanceof MarketDataMarketWebSocketChannel)) {
            return;
        }
        Map<String, Class<? extends MarketDataWebSocketChannelMessage>> map = this.channelMessageTypes;
        synchronized (map) {
            MarketDataMarketWebSocketChannel channel = (MarketDataMarketWebSocketChannel)component;
            this.channelMessageTypes.put(((MarketDataWebSocketChannelId)channel.getId()).getChannel(), channel.getMessageType());
        }
    }

    protected String decode(byte[] bytes) {
        String string;
        InputStreamReader reader = new InputStreamReader(new GZIPInputStream(new ByteArrayInputStream(bytes)));
        try {
            string = CharStreams.toString((Readable)reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ((Reader)reader).close();
        return string;
    }

    protected AnyWebSocketMessage fromText(String text) {
        JsonElement json = (JsonElement)this.gson.fromJson(text, JsonElement.class);
        return this.parse(json);
    }

    private AnyWebSocketMessage parse(JsonElement json) {
        if (!json.isJsonObject()) {
            throw new IllegalArgumentException(json.toString());
        }
        JsonObject obj = json.getAsJsonObject();
        if (obj.has("ch")) {
            return this.toMarketDataMessage(obj);
        }
        if (obj.has("ping")) {
            return (AnyWebSocketMessage)this.gson.fromJson((JsonElement)obj, MarketDataWebSocketPing.class);
        }
        if (obj.has("subbed")) {
            return (AnyWebSocketMessage)this.gson.fromJson((JsonElement)obj, MarketDataWebSocketSubscribeConfirmation.class);
        }
        if (obj.has("unsubbed")) {
            return (AnyWebSocketMessage)this.gson.fromJson((JsonElement)obj, MarketDataWebSocketUnsubscribeConfirmation.class);
        }
        throw new UnsupportedOperationException(json.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MarketDataWebSocketChannelMessage toMarketDataMessage(JsonObject obj) {
        String ch = obj.get("ch").getAsString();
        Map<String, Class<? extends MarketDataWebSocketChannelMessage>> map = this.channelMessageTypes;
        synchronized (map) {
            Class<? extends MarketDataWebSocketChannelMessage> type = this.channelMessageTypes.get(ch);
            return (MarketDataWebSocketChannelMessage)((Object)this.gson.fromJson((JsonElement)obj, type));
        }
    }
}

