/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.hbdmlinear.api.websocket.common.notification;

import com.google.common.collect.ImmutableList;
import io.contek.invoker.commons.actor.IActor;
import io.contek.invoker.commons.actor.ratelimit.TypedPermitRequest;
import io.contek.invoker.commons.websocket.AnyWebSocketMessage;
import io.contek.invoker.commons.websocket.BaseWebSocketApi;
import io.contek.invoker.commons.websocket.IWebSocketAuthenticator;
import io.contek.invoker.commons.websocket.IWebSocketLiveKeeper;
import io.contek.invoker.commons.websocket.IWebSocketMessageParser;
import io.contek.invoker.commons.websocket.WebSocketCall;
import io.contek.invoker.commons.websocket.WebSocketContext;
import io.contek.invoker.commons.websocket.WebSocketRuntimeException;
import io.contek.invoker.commons.websocket.WebSocketServerRestartException;
import io.contek.invoker.hbdmlinear.api.ApiFactory;
import io.contek.invoker.hbdmlinear.api.websocket.common.notification.NotificationWebSocketAuthenticator;
import io.contek.invoker.hbdmlinear.api.websocket.common.notification.NotificationWebSocketClose;
import io.contek.invoker.hbdmlinear.api.websocket.common.notification.NotificationWebSocketLiveKeeper;
import io.contek.invoker.hbdmlinear.api.websocket.common.notification.NotificationWebSocketMessageParser;
import io.contek.invoker.hbdmlinear.api.websocket.common.notification.NotificationWebSocketRequestIdGenerator;
import io.contek.invoker.security.ICredential;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class NotificationWebSocketApi
extends BaseWebSocketApi {
    private static final String PATH = "/linear-swap-notification";
    private final WebSocketContext context;
    private final NotificationWebSocketRequestIdGenerator requestIdGenerator;

    protected NotificationWebSocketApi(IActor actor, WebSocketContext context) {
        this(actor, context, new NotificationWebSocketRequestIdGenerator());
    }

    private NotificationWebSocketApi(IActor actor, WebSocketContext context, NotificationWebSocketRequestIdGenerator requestIdGenerator) {
        super(actor, (IWebSocketMessageParser)new NotificationWebSocketMessageParser(), (IWebSocketAuthenticator)new NotificationWebSocketAuthenticator(actor.getCredential(), PATH, requestIdGenerator, context, actor.getClock()), (IWebSocketLiveKeeper)NotificationWebSocketLiveKeeper.getInstance());
        this.context = context;
        this.requestIdGenerator = requestIdGenerator;
    }

    protected final NotificationWebSocketRequestIdGenerator getRequestIdGenerator() {
        return this.requestIdGenerator;
    }

    protected final ImmutableList<TypedPermitRequest> getRequiredQuotas() {
        return ApiFactory.RateLimits.ONE_IP_WEB_SOCKET_CONNECTION_REQUEST;
    }

    protected final WebSocketCall createCall(ICredential credential) {
        return WebSocketCall.fromUrl((String)(this.context.getBaseUrl() + PATH));
    }

    protected final void checkErrorMessage(AnyWebSocketMessage message) throws WebSocketRuntimeException {
        if (message instanceof NotificationWebSocketClose) {
            throw new WebSocketServerRestartException();
        }
    }
}

