/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.hbdmlinear.api.websocket.common.notification;

import com.google.common.net.UrlEscapers;
import io.contek.invoker.commons.rest.RestParams;
import io.contek.invoker.commons.websocket.AnyWebSocketMessage;
import io.contek.invoker.commons.websocket.IWebSocketAuthenticator;
import io.contek.invoker.commons.websocket.WebSocketContext;
import io.contek.invoker.commons.websocket.WebSocketIllegalMessageException;
import io.contek.invoker.commons.websocket.WebSocketSession;
import io.contek.invoker.hbdmlinear.api.websocket.common.notification.NotificationWebSocketAuthRequest;
import io.contek.invoker.hbdmlinear.api.websocket.common.notification.NotificationWebSocketConfirmation;
import io.contek.invoker.hbdmlinear.api.websocket.common.notification.NotificationWebSocketRequestIdGenerator;
import io.contek.invoker.security.ICredential;
import java.net.URI;
import java.time.Clock;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class NotificationWebSocketAuthenticator
implements IWebSocketAuthenticator {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneOffset.UTC);
    private final ICredential credential;
    private final String path;
    private final NotificationWebSocketRequestIdGenerator requestIdGenerator;
    private final WebSocketContext context;
    private final Clock clock;
    private final AtomicBoolean authenticated = new AtomicBoolean();
    private final AtomicReference<NotificationWebSocketAuthRequest> pendingCommandHolder = new AtomicReference<Object>(null);

    NotificationWebSocketAuthenticator(ICredential credential, String path, NotificationWebSocketRequestIdGenerator requestIdGenerator, WebSocketContext context, Clock clock) {
        this.credential = credential;
        this.path = path;
        this.requestIdGenerator = requestIdGenerator;
        this.context = context;
        this.clock = clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handshake(WebSocketSession session) {
        if (this.credential.isAnonymous()) {
            return;
        }
        AtomicReference<NotificationWebSocketAuthRequest> atomicReference = this.pendingCommandHolder;
        synchronized (atomicReference) {
            NotificationWebSocketAuthRequest request = new NotificationWebSocketAuthRequest();
            request.op = "auth";
            request.type = "api";
            request.cid = this.requestIdGenerator.generateNext();
            request.AccessKeyId = this.credential.getApiKeyId();
            request.SignatureMethod = "HmacSHA256";
            request.SignatureVersion = "2";
            request.Timestamp = FORMATTER.format(this.clock.instant().with(ChronoField.MILLI_OF_SECOND, 0L));
            request.Signature = this.generateSignature(request);
            session.send((AnyWebSocketMessage)request);
            this.pendingCommandHolder.set(request);
        }
    }

    public boolean isPending() {
        return this.pendingCommandHolder.get() != null;
    }

    public boolean isCompleted() {
        return this.authenticated.get() || this.credential.isAnonymous();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(AnyWebSocketMessage message, WebSocketSession session) {
        if (this.isCompleted()) {
            return;
        }
        if (!(message instanceof NotificationWebSocketConfirmation)) {
            return;
        }
        NotificationWebSocketConfirmation response = (NotificationWebSocketConfirmation)message;
        AtomicReference<NotificationWebSocketAuthRequest> atomicReference = this.pendingCommandHolder;
        synchronized (atomicReference) {
            NotificationWebSocketAuthRequest request = this.pendingCommandHolder.get();
            if (request == null) {
                return;
            }
            if (!request.cid.equals(response.cid)) {
                return;
            }
            this.pendingCommandHolder.set(null);
            if (response.err_code != 0) {
                throw new WebSocketIllegalMessageException(response.err_code + ": " + response.err_msg);
            }
            this.reset();
            this.authenticated.set(true);
        }
    }

    public void afterDisconnect() {
        this.reset();
    }

    private String generateSignature(NotificationWebSocketAuthRequest request) {
        RestParams.Builder builder = RestParams.newBuilder();
        builder.add("AccessKeyId", request.AccessKeyId);
        builder.add("SignatureMethod", request.SignatureMethod);
        builder.add("SignatureVersion", request.SignatureVersion);
        builder.add("Timestamp", request.Timestamp);
        RestParams withIdentity = builder.build(true);
        String queryString = withIdentity.getQueryString(UrlEscapers.urlFormParameterEscaper());
        String payload = String.join((CharSequence)"\n", "GET", URI.create(this.context.getBaseUrl()).getHost(), this.path, queryString);
        return this.credential.sign(payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        this.authenticated.set(false);
        AtomicReference<NotificationWebSocketAuthRequest> atomicReference = this.pendingCommandHolder;
        synchronized (atomicReference) {
            this.pendingCommandHolder.set(null);
        }
    }
}

