/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.hbdmlinear.api.websocket.common.notification;

import io.contek.invoker.commons.websocket.AnyWebSocketMessage;
import io.contek.invoker.commons.websocket.BaseWebSocketChannel;
import io.contek.invoker.commons.websocket.SubscriptionState;
import io.contek.invoker.commons.websocket.WebSocketIllegalMessageException;
import io.contek.invoker.commons.websocket.WebSocketSession;
import io.contek.invoker.hbdmlinear.api.websocket.common.notification.NotificationWebSocketChannelId;
import io.contek.invoker.hbdmlinear.api.websocket.common.notification.NotificationWebSocketChannelMessage;
import io.contek.invoker.hbdmlinear.api.websocket.common.notification.NotificationWebSocketConfirmation;
import io.contek.invoker.hbdmlinear.api.websocket.common.notification.NotificationWebSocketRequest;
import io.contek.invoker.hbdmlinear.api.websocket.common.notification.NotificationWebSocketRequestIdGenerator;
import io.contek.invoker.hbdmlinear.api.websocket.common.notification.NotificationWebSocketSubscriptionRequest;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class NotificationWebSocketChannel<Id extends NotificationWebSocketChannelId<Message>, Message extends NotificationWebSocketChannelMessage>
extends BaseWebSocketChannel<Id, Message> {
    private final NotificationWebSocketRequestIdGenerator requestIdGenerator;
    private final AtomicReference<NotificationWebSocketRequest> pendingRequestHolder = new AtomicReference<Object>(null);

    protected NotificationWebSocketChannel(Id id, NotificationWebSocketRequestIdGenerator requestIdGenerator) {
        super(id);
        this.requestIdGenerator = requestIdGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final SubscriptionState subscribe(WebSocketSession session) {
        AtomicReference<NotificationWebSocketRequest> atomicReference = this.pendingRequestHolder;
        synchronized (atomicReference) {
            if (this.pendingRequestHolder.get() != null) {
                throw new IllegalStateException();
            }
            NotificationWebSocketChannelId id = (NotificationWebSocketChannelId)this.getId();
            NotificationWebSocketSubscriptionRequest request = new NotificationWebSocketSubscriptionRequest();
            request.op = "sub";
            request.topic = id.getTopic();
            request.cid = this.requestIdGenerator.generateNext();
            session.send((AnyWebSocketMessage)request);
            this.pendingRequestHolder.set(request);
        }
        return SubscriptionState.SUBSCRIBING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final SubscriptionState unsubscribe(WebSocketSession session) {
        AtomicReference<NotificationWebSocketRequest> atomicReference = this.pendingRequestHolder;
        synchronized (atomicReference) {
            if (this.pendingRequestHolder.get() != null) {
                throw new IllegalStateException();
            }
            NotificationWebSocketChannelId id = (NotificationWebSocketChannelId)this.getId();
            NotificationWebSocketSubscriptionRequest request = new NotificationWebSocketSubscriptionRequest();
            request.op = "unsub";
            request.topic = id.getTopic();
            request.cid = this.requestIdGenerator.generateNext();
            session.send((AnyWebSocketMessage)request);
            this.pendingRequestHolder.set(request);
        }
        return SubscriptionState.UNSUBSCRIBING;
    }

    @Nullable
    protected final SubscriptionState getState(AnyWebSocketMessage message) {
        if (!(message instanceof NotificationWebSocketConfirmation)) {
            return null;
        }
        NotificationWebSocketConfirmation confirmation = (NotificationWebSocketConfirmation)message;
        AtomicReference<NotificationWebSocketRequest> atomicReference = this.pendingRequestHolder;
        synchronized (atomicReference) {
            NotificationWebSocketRequest request = this.pendingRequestHolder.get();
            if (request == null) {
                return null;
            }
            if (!request.cid.equals(confirmation.cid)) {
                return null;
            }
            if (confirmation.err_code != 0) {
                throw new WebSocketIllegalMessageException(confirmation.err_code + ": " + confirmation.err_msg);
            }
            this.reset();
            switch (request.op) {
                case "sub": {
                    return SubscriptionState.SUBSCRIBED;
                }
                case "unsub": {
                    return SubscriptionState.UNSUBSCRIBED;
                }
            }
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void reset() {
        AtomicReference<NotificationWebSocketRequest> atomicReference = this.pendingRequestHolder;
        synchronized (atomicReference) {
            this.pendingRequestHolder.set(null);
        }
    }
}

