/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.hbdmlinear.api.websocket.common.notification;

import com.google.common.io.CharStreams;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.contek.invoker.commons.websocket.AnyWebSocketMessage;
import io.contek.invoker.commons.websocket.IWebSocketComponent;
import io.contek.invoker.commons.websocket.WebSocketBinaryMessageParser;
import io.contek.invoker.hbdmlinear.api.websocket.common.notification.NotificationWebSocketChannel;
import io.contek.invoker.hbdmlinear.api.websocket.common.notification.NotificationWebSocketChannelId;
import io.contek.invoker.hbdmlinear.api.websocket.common.notification.NotificationWebSocketChannelMessage;
import io.contek.invoker.hbdmlinear.api.websocket.common.notification.NotificationWebSocketClose;
import io.contek.invoker.hbdmlinear.api.websocket.common.notification.NotificationWebSocketConfirmation;
import io.contek.invoker.hbdmlinear.api.websocket.common.notification.NotificationWebSocketInboundMessage;
import io.contek.invoker.hbdmlinear.api.websocket.common.notification.NotificationWebSocketPing;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.annotation.concurrent.Immutable;

@Immutable
final class NotificationWebSocketMessageParser
extends WebSocketBinaryMessageParser {
    private final Gson gson = new Gson();
    private final Map<String, Class<? extends NotificationWebSocketChannelMessage>> channelMessageTypes = new HashMap<String, Class<? extends NotificationWebSocketChannelMessage>>();

    NotificationWebSocketMessageParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(IWebSocketComponent component) {
        if (!(component instanceof NotificationWebSocketChannel)) {
            return;
        }
        Map<String, Class<? extends NotificationWebSocketChannelMessage>> map = this.channelMessageTypes;
        synchronized (map) {
            NotificationWebSocketChannel channel = (NotificationWebSocketChannel)component;
            this.channelMessageTypes.put(((NotificationWebSocketChannelId)channel.getId()).getTopic(), channel.getMessageType());
        }
    }

    protected String decode(byte[] bytes) {
        String string;
        InputStreamReader reader = new InputStreamReader(new GZIPInputStream(new ByteArrayInputStream(bytes)));
        try {
            string = CharStreams.toString((Readable)reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ((Reader)reader).close();
        return string;
    }

    protected AnyWebSocketMessage fromText(String text) {
        JsonElement json = (JsonElement)this.gson.fromJson(text, JsonElement.class);
        return this.parse(json);
    }

    private NotificationWebSocketInboundMessage parse(JsonElement json) {
        String op;
        if (!json.isJsonObject()) {
            throw new IllegalArgumentException(json.toString());
        }
        JsonObject obj = json.getAsJsonObject();
        switch (op = obj.get("op").getAsString()) {
            case "notify": {
                return this.toMarketDataMessage(obj);
            }
            case "ping": {
                return (NotificationWebSocketInboundMessage)((Object)this.gson.fromJson((JsonElement)obj, NotificationWebSocketPing.class));
            }
            case "sub": 
            case "unsub": {
                return (NotificationWebSocketInboundMessage)((Object)this.gson.fromJson((JsonElement)obj, NotificationWebSocketConfirmation.class));
            }
            case "close": {
                return (NotificationWebSocketInboundMessage)((Object)this.gson.fromJson((JsonElement)obj, NotificationWebSocketClose.class));
            }
        }
        throw new UnsupportedOperationException(json.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NotificationWebSocketChannelMessage toMarketDataMessage(JsonObject obj) {
        String topic = obj.get("topic").getAsString();
        Map<String, Class<? extends NotificationWebSocketChannelMessage>> map = this.channelMessageTypes;
        synchronized (map) {
            Class<? extends NotificationWebSocketChannelMessage> type = this.channelMessageTypes.get(topic);
            return (NotificationWebSocketChannelMessage)((Object)this.gson.fromJson((JsonElement)obj, type));
        }
    }
}

