/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.hbdmlinear.api.websocket.market;

import io.contek.invoker.commons.websocket.AnyWebSocketMessage;
import io.contek.invoker.commons.websocket.SubscriptionState;
import io.contek.invoker.commons.websocket.WebSocketSession;
import io.contek.invoker.hbdmlinear.api.common._Depth;
import io.contek.invoker.hbdmlinear.api.websocket.common.marketdata.MarketDataMarketWebSocketChannel;
import io.contek.invoker.hbdmlinear.api.websocket.common.marketdata.MarketDataWebSocketChannelId;
import io.contek.invoker.hbdmlinear.api.websocket.common.marketdata.MarketDataWebSocketRequestIdGenerator;
import io.contek.invoker.hbdmlinear.api.websocket.common.marketdata.MarketDataWebSocketSubscribeRequest;
import io.contek.invoker.hbdmlinear.api.websocket.common.marketdata.MarketDataWebSocketTickMessage;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class DepthChannel
extends MarketDataMarketWebSocketChannel<Id, Message> {
    DepthChannel(Id id, MarketDataWebSocketRequestIdGenerator requestIdGenerator) {
        super(id, Message.class, requestIdGenerator);
    }

    protected SubscriptionState subscribe(WebSocketSession session) {
        Id id = (Id)this.getId();
        WebSocketSubscribeMarketDepthRequest request = new WebSocketSubscribeMarketDepthRequest();
        request.sub = id.getChannel();
        request.id = this.generateNexRequestId();
        session.send((AnyWebSocketMessage)request);
        return SubscriptionState.SUBSCRIBING;
    }

    @NotThreadSafe
    public static final class Message
    extends MarketDataWebSocketTickMessage<_Depth> {
    }

    @Immutable
    public static final class Id
    extends MarketDataWebSocketChannelId<Message> {
        private Id(String topic) {
            super(topic);
        }

        public static Id of(String contractCode, String type) {
            return new Id(String.format("market.%s.depth.%s", contractCode, type));
        }
    }

    @NotThreadSafe
    public static final class WebSocketSubscribeMarketDepthRequest
    extends MarketDataWebSocketSubscribeRequest {
    }
}

