/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.hbdmlinear.api.websocket.market;

import io.contek.invoker.commons.websocket.AnyWebSocketMessage;
import io.contek.invoker.commons.websocket.SubscriptionState;
import io.contek.invoker.commons.websocket.WebSocketSession;
import io.contek.invoker.hbdmlinear.api.common._Depth;
import io.contek.invoker.hbdmlinear.api.websocket.common.marketdata.MarketDataMarketWebSocketChannel;
import io.contek.invoker.hbdmlinear.api.websocket.common.marketdata.MarketDataWebSocketChannelId;
import io.contek.invoker.hbdmlinear.api.websocket.common.marketdata.MarketDataWebSocketRequestIdGenerator;
import io.contek.invoker.hbdmlinear.api.websocket.common.marketdata.MarketDataWebSocketSubscribeRequest;
import io.contek.invoker.hbdmlinear.api.websocket.common.marketdata.MarketDataWebSocketTickMessage;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class IncrementalDepthChannel
extends MarketDataMarketWebSocketChannel<Id, Message> {
    IncrementalDepthChannel(Id id, MarketDataWebSocketRequestIdGenerator requestIdGenerator) {
        super(id, Message.class, requestIdGenerator);
    }

    protected SubscriptionState subscribe(WebSocketSession session) {
        Id id = (Id)this.getId();
        SubscribeIncrementalMarketDepthRequest request = new SubscribeIncrementalMarketDepthRequest();
        request.sub = id.getChannel();
        request.data_type = "incremental";
        request.id = this.generateNexRequestId();
        session.send((AnyWebSocketMessage)request);
        return SubscriptionState.SUBSCRIBING;
    }

    @NotThreadSafe
    public static final class Message
    extends MarketDataWebSocketTickMessage<Tick> {
    }

    @Immutable
    public static final class Id
    extends MarketDataWebSocketChannelId<Message> {
        private Id(String topic) {
            super(topic);
        }

        public static Id of(String contractCode, int size) {
            return new Id(String.format("market.%s.depth.size_%d.high_freq", contractCode, size));
        }
    }

    @NotThreadSafe
    public static final class SubscribeIncrementalMarketDepthRequest
    extends MarketDataWebSocketSubscribeRequest {
        public String data_type;
    }

    @Immutable
    public static final class SizeKeys {
        public static final int _20_unmerged_data = 20;
        public static final int _150_unmerged_data = 150;

        private SizeKeys() {
        }
    }

    @NotThreadSafe
    public static final class Tick
    extends _Depth {
        public String event;
    }
}

