/*
 * Decompiled with CFR 0.152.
 */
package zhttp.http;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.time.Duration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.Either;
import zhttp.html.Html;
import zhttp.html.Template$;
import zhttp.http.HExit;
import zhttp.http.Headers;
import zhttp.http.Headers$;
import zhttp.http.Http;
import zhttp.http.Http$Empty$;
import zhttp.http.Http$Identity$;
import zhttp.http.Http$PartialFromFunction$;
import zhttp.http.Http$PartialFromFunctionZIO$;
import zhttp.http.HttpData;
import zhttp.http.HttpData$;
import zhttp.http.HttpError;
import zhttp.http.HttpError$InternalServerError$;
import zhttp.http.MediaType;
import zhttp.http.MediaType$;
import zhttp.http.Request;
import zhttp.http.Response;
import zhttp.http.Response$;
import zhttp.http.Status;
import zhttp.http.Status$Ok$;
import zhttp.http.Status$RequestEntityTooLarge$;
import zhttp.http.Status$RequestTimeout$;
import zhttp.http.package$;
import zio.Has;
import zio.NeedsEnv$;
import zio.Task$;
import zio.UIO$;
import zio.ZIO;
import zio.ZIO$;
import zio.blocking.package;
import zio.clock.package;
import zio.stream.ZStream;

public final class Http$ {
    public static Http$ MODULE$;

    static {
        new Http$();
    }

    public <R, E> Http.HttpAppSyntax<R, E> HttpAppSyntax(Http<R, E, Request, Response> http) {
        return new Http.HttpAppSyntax<R, E>(http);
    }

    public <B> Http<Object, Nothing$, Object, B> apply(B b) {
        return this.succeed(b);
    }

    public <A> Http<Object, Throwable, Object, A> attempt(Function0<A> a) {
        return new Http.Attempt<A>(a);
    }

    public Http<Object, Nothing$, Request, Response> badRequest(String msg) {
        return this.error(new HttpError.BadRequest(msg));
    }

    public <A> BoxedUnit collect() {
        return BoxedUnit.UNIT;
    }

    public <A> BoxedUnit collectHExit() {
        return BoxedUnit.UNIT;
    }

    public <A> BoxedUnit collectHttp() {
        return BoxedUnit.UNIT;
    }

    public <A> BoxedUnit collectManaged() {
        return BoxedUnit.UNIT;
    }

    public <A> BoxedUnit collectZIO() {
        return BoxedUnit.UNIT;
    }

    public <R, E, A, B> Http<R, E, A, B> combine(Iterable<Http<R, E, A, B>> i) {
        return (Http)i.reduce((Function2 & Serializable & scala.Serializable)(x$25, x$26) -> x$25.defaultWith(x$26));
    }

    public Http<Object, Nothing$, Object, Nothing$> die(Throwable t) {
        return new Http.Die(t);
    }

    public Http<Object, Nothing$, Object, Nothing$> dieMessage(Function0<String> message) {
        return this.die(new RuntimeException((String)message.apply()));
    }

    public Http<Object, Nothing$, Object, Nothing$> empty() {
        return Http$Empty$.MODULE$;
    }

    public Http<Object, Nothing$, Request, Response> error(HttpError cause) {
        return this.response(Response$.MODULE$.fromHttpError(cause));
    }

    public Http<Object, Nothing$, Request, Response> error(String msg) {
        return this.error(new HttpError.InternalServerError(msg, HttpError$InternalServerError$.MODULE$.apply$default$2()));
    }

    public <E> Http<Object, E, Object, Nothing$> fail(E e) {
        return new Http.Fail<E>(e);
    }

    public <R, E, A, B> Http<R, E, A, B> flatten(Http<R, E, A, Http<R, E, A, B>> http) {
        return http.flatten(Predef$.MODULE$.$conforms());
    }

    public <R, E, A, B> Http<R, E, A, B> flattenZIO(Http<R, E, A, ZIO<R, E, B>> http) {
        return http.flatMap((Function1 & Serializable & scala.Serializable)effect -> MODULE$.fromZIO((ZIO)effect));
    }

    public Http<Object, Nothing$, Request, Response> forbidden(String msg) {
        return this.error(new HttpError.Forbidden(msg));
    }

    public Http<Object, Nothing$, Request, Response> fromData(HttpData data) {
        HttpData x$1 = data;
        Status x$2 = Response$.MODULE$.apply$default$1();
        Headers x$3 = Response$.MODULE$.apply$default$2();
        return this.response(Response$.MODULE$.apply(x$2, x$3, x$1));
    }

    public <E, A> Http<Object, E, Object, A> fromEither(Either<E, A> v) {
        return (Http)v.fold((Function1 & Serializable & scala.Serializable)e -> MODULE$.fail(e), (Function1 & Serializable & scala.Serializable)b -> MODULE$.succeed(b));
    }

    public Http<Object, Throwable, Request, Response> fromFile(Function0<File> file) {
        return this.fromFileZIO(UIO$.MODULE$.apply(file));
    }

    public <R> Http<R, Throwable, Request, Response> fromFileZIO(ZIO<R, Throwable, File> fileZIO) {
        ZIO response = fileZIO.flatMap((Function1 & Serializable & scala.Serializable)file -> Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Http<Object, Nothing$, Object, Object> http;
            if (file.isFile()) {
                None$ none$;
                Headers length;
                Headers x$1 = length = Headers$.MODULE$.contentLength(file.length());
                HttpData x$2 = HttpData$.MODULE$.fromFile((Function0<File>)(Function0 & Serializable & scala.Serializable)() -> file);
                Status x$3 = Response$.MODULE$.apply$default$1();
                Response response = Response$.MODULE$.apply(x$3, x$1, x$2);
                String pathName = ((Object)file.toPath()).toString();
                int n = pathName.lastIndexOf(".");
                switch (n) {
                    case -1: {
                        none$ = None$.MODULE$;
                        break;
                    }
                    default: {
                        none$ = new Some((Object)pathName.substring(n + 1));
                        break;
                    }
                }
                None$ ext2 = none$;
                http = MODULE$.succeed(ext2.flatMap((Function1 & Serializable & scala.Serializable)ext -> MediaType$.MODULE$.forFileExtension((String)ext)).fold((Function0 & Serializable & scala.Serializable)() -> response, (Function1 & Serializable & scala.Serializable)mediaType -> (Response)response.withMediaType((MediaType)mediaType)));
            } else {
                http = MODULE$.empty();
            }
            return http;
        }));
        return this.fromZIO(response).flatten(Predef$.MODULE$.$conforms());
    }

    public <A> BoxedUnit fromFunction() {
        return BoxedUnit.UNIT;
    }

    public <A> BoxedUnit fromFunctionHExit() {
        return BoxedUnit.UNIT;
    }

    public <A> BoxedUnit fromFunctionZIO() {
        return BoxedUnit.UNIT;
    }

    public <R, E, B> Http<R, E, Object, B> fromHExit(HExit<R, E, B> h) {
        return new Http.FromHExit<R, E, B>(h);
    }

    public <A> Http<Object, Option<Nothing$>, Object, A> fromOption(Option<A> v) {
        return (Http)v.fold((Function0 & Serializable & scala.Serializable)() -> MODULE$.fail(None$.MODULE$), (Function1 & Serializable & scala.Serializable)b -> MODULE$.succeed(b));
    }

    public <A> BoxedUnit fromOptionFunction() {
        return BoxedUnit.UNIT;
    }

    public Http<Object, Throwable, Request, Response> fromPath(String head, Seq<String> tail) {
        return this.fromFile((Function0<File>)(Function0 & Serializable & scala.Serializable)() -> Paths.get(head, (String[])tail.toArray(ClassTag$.MODULE$.apply(String.class))).toFile());
    }

    public Http<Has<package.Blocking.Service>, Throwable, Request, Response> fromResource(String path) {
        return this.getResource(path).flatMap((Function1 & Serializable & scala.Serializable)url -> MODULE$.fromFile((Function0<File>)(Function0 & Serializable & scala.Serializable)() -> new File(url.getPath())));
    }

    public <R> Http<R, Nothing$, Request, Response> fromStream(ZStream<R, Throwable, String> stream, Charset charset) {
        return this.fromZIO(ZIO$.MODULE$.environment().map((Function1 & Serializable & scala.Serializable)r -> MODULE$.fromData(HttpData$.MODULE$.fromStream((ZStream<Object, Throwable, CharSequence>)stream.provide(r, NeedsEnv$.MODULE$.needsEnv()), charset)))).flatten(Predef$.MODULE$.$conforms());
    }

    public <R> Http<R, Nothing$, Request, Response> fromStream(ZStream<R, Throwable, Object> stream) {
        return this.fromZIO(ZIO$.MODULE$.environment().map((Function1 & Serializable & scala.Serializable)r -> MODULE$.fromData(HttpData$.MODULE$.fromStream((ZStream<Object, Throwable, Object>)stream.provide(r, NeedsEnv$.MODULE$.needsEnv()))))).flatten(Predef$.MODULE$.$conforms());
    }

    public <R> Charset fromStream$default$2() {
        return package$.MODULE$.HTTP_CHARSET();
    }

    public <R, E, B> Http<R, E, Object, B> fromZIO(ZIO<R, E, B> effect) {
        return Http$PartialFromFunctionZIO$.MODULE$.apply$extension(this.fromFunctionZIO(), (Function1 & Serializable & scala.Serializable)x$27 -> effect);
    }

    public Http<Has<package.Blocking.Service>, Throwable, Object, URL> getResource(String path) {
        return this.fromZIO(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> MODULE$.getClass().getClassLoader().getResource(path))).flatMap((Function1 & Serializable & scala.Serializable)resource -> resource == null ? MODULE$.empty() : MODULE$.succeed(resource));
    }

    public Http<Has<package.Blocking.Service>, Throwable, Object, File> getResourceAsFile(String path) {
        return this.getResource(path).map((Function1 & Serializable & scala.Serializable)url -> new File(url.getPath()));
    }

    public Http<Object, Nothing$, Request, Response> html(Html view) {
        return this.response(Response$.MODULE$.html(view, Response$.MODULE$.html$default$2()));
    }

    public <A> Http<Object, Nothing$, A, A> identity() {
        return Http$Identity$.MODULE$;
    }

    public Http<Object, Nothing$, Request, Response> methodNotAllowed(String msg) {
        return this.error(new HttpError.MethodNotAllowed(msg));
    }

    public Http<Object, Nothing$, Request, Response> notFound() {
        return Http$PartialFromFunction$.MODULE$.apply$extension(this.fromFunction(), (Function1 & Serializable & scala.Serializable)req -> MODULE$.error(new HttpError.NotFound(req.url().path()))).flatten(Predef$.MODULE$.$conforms());
    }

    public Http<Object, Nothing$, Request, Response> ok() {
        return this.status(Status$Ok$.MODULE$);
    }

    public Http<Object, Nothing$, Object, Response> response(Response response) {
        return this.succeed(response);
    }

    public <R, E> Http<R, E, Request, Response> responseZIO(ZIO<R, E, Response> res) {
        return this.fromZIO(res);
    }

    public <A> BoxedUnit route() {
        return BoxedUnit.UNIT;
    }

    public Http<Object, Nothing$, Request, Response> status(Status code) {
        return this.succeed(Response$.MODULE$.apply(code, Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3()));
    }

    public <B> Http<Object, Nothing$, Object, B> succeed(B b) {
        return new Http.Succeed<B>(b);
    }

    public Http<Object, Nothing$, Request, Response> template(CharSequence heading, Html view) {
        return this.response(Response$.MODULE$.html(Template$.MODULE$.container(heading, view), Response$.MODULE$.html$default$2()));
    }

    public Http<Object, Nothing$, Request, Response> text(CharSequence charSeq) {
        return this.succeed(Response$.MODULE$.text(charSeq));
    }

    public Http<Has<package.Clock.Service>, Nothing$, Request, Response> timeout(Duration duration) {
        return this.status(Status$RequestTimeout$.MODULE$).delay(duration);
    }

    public Http<Object, Nothing$, Request, Response> tooLarge() {
        return this.status(Status$RequestEntityTooLarge$.MODULE$);
    }

    private Http$() {
        MODULE$ = this;
    }
}

