(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'd2v-random-js'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'd2v-random-js'.");
    }
    root['d2v-random-js'] = factory(typeof this['d2v-random-js'] === 'undefined' ? {} : this['d2v-random-js'], kotlin);
  }
}(this, function (_, Kotlin) {
  'use strict';
  var numberToDouble = Kotlin.numberToDouble;
  var numberToInt = Kotlin.numberToInt;
  var until = Kotlin.kotlin.ranges.until_dqglrj$;
  function randomBates$lambda(closure$n) {
    return function () {
      return randomIrwinHall(closure$n)() / numberToDouble(closure$n);
    };
  }
  function randomBates(n) {
    if (n === void 0)
      n = 1;
    return randomBates$lambda(n);
  }
  var Math_0 = Math;
  function randomExponential$lambda(closure$lambda) {
    return function () {
      var x = 1 - random();
      return -Math_0.log(x) / numberToDouble(closure$lambda);
    };
  }
  function randomExponential(lambda) {
    if (lambda === void 0)
      lambda = 1;
    return randomExponential$lambda(lambda);
  }
  function randomIrwinHall$lambda(closure$n) {
    return function () {
      var sum = {v: 0.0};
      var tmp$;
      tmp$ = until(0, numberToInt(closure$n)).iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        sum.v += random();
      }
      return sum.v;
    };
  }
  function randomIrwinHall(n) {
    if (n === void 0)
      n = 1;
    return randomIrwinHall$lambda(n);
  }
  function randomLogNormal$lambda(closure$mu, closure$sigma) {
    return function () {
      var x = randomNormal(closure$mu, closure$sigma)();
      return Math_0.exp(x);
    };
  }
  function randomLogNormal(mu, sigma) {
    if (mu === void 0)
      mu = 0;
    if (sigma === void 0)
      sigma = 1;
    return randomLogNormal$lambda(mu, sigma);
  }
  function randomNormal$lambda(closure$mu, closure$sigma) {
    return function () {
      var x = null;
      var r = 0.0;
      var y = 0.0;
      if (x != null) {
        y = x;
      }
       else {
        while (r === 0.0 || r > 1) {
          x = random() * 2 - 1;
          y = random() * 2 - 1;
          r = x * x + y * y;
        }
      }
      var tmp$ = numberToDouble(closure$mu);
      var tmp$_0 = numberToDouble(closure$sigma) * y;
      var x_0 = r;
      var x_1 = -2 * Math_0.log(x_0) / r;
      return tmp$ + tmp$_0 * Math_0.sqrt(x_1);
    };
  }
  function randomNormal(mu, sigma) {
    if (mu === void 0)
      mu = 0;
    if (sigma === void 0)
      sigma = 1;
    return randomNormal$lambda(mu, sigma);
  }
  function randomUniform$lambda(closure$max, closure$min) {
    return function () {
      return random() * (numberToDouble(closure$max) - numberToDouble(closure$min)) + numberToDouble(closure$min);
    };
  }
  function randomUniform(min, max) {
    if (min === void 0)
      min = 0;
    if (max === void 0)
      max = 1;
    return randomUniform$lambda(max, min);
  }
  function random() {
    return Math.random();
  }
  var package$io = _.io || (_.io = {});
  var package$data2viz = package$io.data2viz || (package$io.data2viz = {});
  var package$random = package$data2viz.random || (package$data2viz.random = {});
  package$random.randomBates_3p81yu$ = randomBates;
  package$random.randomExponential_3p81yu$ = randomExponential;
  package$random.randomIrwinHall_3p81yu$ = randomIrwinHall;
  package$random.randomLogNormal_z8e4lc$ = randomLogNormal;
  package$random.randomNormal_z8e4lc$ = randomNormal;
  package$random.randomUniform_z8e4lc$ = randomUniform;
  package$random.random = random;
  Kotlin.defineModule('d2v-random-js', _);
  return _;
}));

//# sourceMappingURL=d2v-random-js.js.map
