/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.time;

import io.data2viz.time.DateKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.threeten.bp.DayOfWeek;
import org.threeten.bp.Duration;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.chrono.ChronoLocalDateTime;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalUnit;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0012\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B?\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000eB\u000f\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u0007J\u0006\u0010\u0012\u001a\u00020\u0007J\u0006\u0010\u0013\u001a\u00020\u0007J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0000J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0000H\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0007J\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0000J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u0000J\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0000J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0007J\u0006\u0010\u000b\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0015J\u000e\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0015J\u000e\u0010'\u001a\u00020#2\u0006\u0010!\u001a\u00020\u0015J\u000e\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020\u0015J\u000e\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020\u0015J\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010,\u001a\u00020#2\u0006\u0010\t\u001a\u00020\u0007J\u000e\u0010-\u001a\u00020#2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010.\u001a\u00020#2\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010/\u001a\u00020#2\u0006\u0010\r\u001a\u00020\u0007J\u000e\u00100\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\u0007J\u000e\u00101\u001a\u00020#2\u0006\u0010\b\u001a\u00020\u0007J\u000e\u00102\u001a\u00020#2\u0006\u0010\f\u001a\u00020\u0007J\b\u00103\u001a\u000204H\u0016J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lio/data2viz/time/Date;", "", "()V", "localDate", "Lorg/threeten/bp/LocalDateTime;", "(Lorg/threeten/bp/LocalDateTime;)V", "year", "", "month", "day", "hour", "minute", "second", "millisecond", "(IIIIIII)V", "date", "(Lio/data2viz/time/Date;)V", "dayOfMonth", "dayOfWeek", "dayOfYear", "daysBetween", "", "otherDate", "durationBetween", "Lorg/threeten/bp/Duration;", "getTime", "", "getTimezoneOffset", "hoursBetween", "isBefore", "", "millisecondsBetween", "minusMilliseconds", "milliseconds", "plusDays", "", "days", "plusHours", "hours", "plusMilliseconds", "plusMonths", "months", "plusYears", "years", "setDayOfMonth", "setFullYear", "setHour", "setMillisecond", "setMinute", "setMonth", "setSecond", "toString", "", "d2v-time-android_release"})
public final class Date {
    private LocalDateTime date;

    @NotNull
    public String toString() {
        String string = this.date.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"date.toString()");
        return string;
    }

    @NotNull
    public final Date minusMilliseconds(int milliseconds) {
        LocalDateTime localDateTime = this.date.minus((long)milliseconds, (TemporalUnit)ChronoUnit.MILLIS);
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"date.minus(milliseconds.\u2026ong(), ChronoUnit.MILLIS)");
        return new Date(localDateTime);
    }

    public final boolean isBefore(@NotNull Date otherDate) {
        Intrinsics.checkParameterIsNotNull((Object)otherDate, (String)"otherDate");
        return this.date.isBefore((ChronoLocalDateTime)otherDate.date);
    }

    public final long millisecondsBetween(@NotNull Date otherDate) {
        Intrinsics.checkParameterIsNotNull((Object)otherDate, (String)"otherDate");
        return this.durationBetween(otherDate).toMillis();
    }

    public final long daysBetween(@NotNull Date otherDate) {
        Intrinsics.checkParameterIsNotNull((Object)otherDate, (String)"otherDate");
        return this.durationBetween(otherDate).toDays();
    }

    public final long hoursBetween(@NotNull Date otherDate) {
        Intrinsics.checkParameterIsNotNull((Object)otherDate, (String)"otherDate");
        return this.durationBetween(otherDate).toHours();
    }

    private final Duration durationBetween(Date otherDate) {
        Duration duration = Duration.between((Temporal)((Temporal)this.date), (Temporal)((Temporal)otherDate.date));
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.between(date, otherDate.date)");
        return duration;
    }

    public final int getTimezoneOffset() {
        return 0;
    }

    public final void plusMilliseconds(long milliseconds) {
        LocalDateTime localDateTime = this.date.plus(milliseconds, (TemporalUnit)ChronoUnit.MILLIS);
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"date.plus(milliseconds, ChronoUnit.MILLIS)");
        this.date = localDateTime;
    }

    public final void plusHours(long hours) {
        LocalDateTime localDateTime = this.date.plusHours(hours);
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"date.plusHours(hours)");
        this.date = localDateTime;
    }

    public final void plusDays(long days) {
        LocalDateTime localDateTime = this.date.plusDays(days);
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"date.plusDays(days)");
        this.date = localDateTime;
    }

    public final void plusMonths(long months) {
        LocalDateTime localDateTime = this.date.plusMonths(months);
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"date.plusMonths(months)");
        this.date = localDateTime;
    }

    public final void plusYears(long years) {
        LocalDateTime localDateTime = this.date.plusYears(years);
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"date.plusYears(years)");
        this.date = localDateTime;
    }

    public final void setMillisecond(int millisecond) {
        LocalDateTime localDateTime = this.date.withNano(millisecond * DateKt.getMilliToNano());
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"date.withNano(millisecond * milliToNano)");
        this.date = localDateTime;
    }

    public final void setSecond(int second) {
        LocalDateTime localDateTime = this.date.withSecond(second);
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"date.withSecond(second)");
        this.date = localDateTime;
    }

    public final void setMinute(int minute) {
        LocalDateTime localDateTime = this.date.withMinute(minute);
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"date.withMinute(minute)");
        this.date = localDateTime;
    }

    public final void setHour(int hour) {
        LocalDateTime localDateTime = this.date.withHour(hour);
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"date.withHour(hour)");
        this.date = localDateTime;
    }

    public final void setDayOfMonth(int day) {
        LocalDateTime localDateTime = this.date.withDayOfMonth(day);
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"date.withDayOfMonth(day)");
        this.date = localDateTime;
    }

    public final void setMonth(int month) {
        LocalDateTime localDateTime = this.date.withMonth(month);
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"date.withMonth(month)");
        this.date = localDateTime;
    }

    public final void setFullYear(int year) {
        LocalDateTime localDateTime = this.date.withYear(year);
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"date.withYear(year)");
        this.date = localDateTime;
    }

    public final int millisecond() {
        return this.date.getNano() / DateKt.getMilliToNano();
    }

    public final int second() {
        return this.date.getSecond();
    }

    public final int minute() {
        return this.date.getMinute();
    }

    public final int hour() {
        return this.date.getHour();
    }

    public final int dayOfWeek() {
        DayOfWeek dayOfWeek = this.date.getDayOfWeek();
        Intrinsics.checkExpressionValueIsNotNull((Object)dayOfWeek, (String)"date.dayOfWeek");
        return dayOfWeek.getValue();
    }

    public final int dayOfMonth() {
        return this.date.getDayOfMonth();
    }

    public final int dayOfYear() {
        return this.date.getDayOfYear();
    }

    public final int month() {
        return this.date.getMonthValue();
    }

    public final int year() {
        return this.date.getYear();
    }

    public final double getTime() {
        return DateKt.getUNIX_TIME().millisecondsBetween(this);
    }

    public Date() {
        LocalDateTime localDateTime = LocalDateTime.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"LocalDateTime.now()");
        this.date = localDateTime;
    }

    private Date(LocalDateTime localDate) {
        this.date = localDate;
    }

    public Date(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        LocalDateTime localDateTime = LocalDateTime.of((int)year, (int)month, (int)day, (int)hour, (int)minute, (int)second, (int)(millisecond * DateKt.getMilliToNano()));
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"LocalDateTime.of(year, m\u2026illisecond * milliToNano)");
        this.date = localDateTime;
    }

    public Date(@NotNull Date date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        this.date = date.date;
    }
}

