/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.timer;

import io.data2viz.timer.Timer;
import io.data2viz.timer.TimerJVMKt;
import io.data2viz.timer.TimerKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\u001a\b\u0010\u001d\u001a\u00020\u001eH\u0002\u001a9\u0010\u001f\u001a\u00020\u00182\b\b\u0002\u0010 \u001a\u00020\u00012\b\b\u0002\u0010!\u001a\u00020\u00012\u001d\u0010\"\u001a\u0019\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001e0#\u00a2\u0006\u0002\b$\u001a\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'H\u0002\u001a\b\u0010(\u001a\u00020'H\u0002\u001a\u0006\u0010)\u001a\u00020\u0001\u001a\u0019\u0010*\u001a\u00020\u001e2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010,\u001a9\u0010-\u001a\u00020\u00182\b\b\u0002\u0010 \u001a\u00020\u00012\b\b\u0002\u0010!\u001a\u00020\u00012\u001d\u0010\"\u001a\u0019\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001e0#\u00a2\u0006\u0002\b$\u001a9\u0010.\u001a\u00020\u00182\b\b\u0002\u0010 \u001a\u00020\u00012\b\b\u0002\u0010!\u001a\u00020\u00012\u001d\u0010\"\u001a\u0019\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001e0#\u00a2\u0006\u0002\b$\u001a\u0006\u0010/\u001a\u00020\u001e\u001a\b\u00100\u001a\u00020\u001eH\u0002\u001a\b\u00101\u001a\u00020\u0001H\u0002\u001a\b\u00102\u001a\u00020\u001eH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0002\u001a\u00020\u0001X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0004\b\u0005\u0010\u0006\"\u001a\u0010\u0007\u001a\u00020\u0001X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0004\"\u0004\b\t\u0010\u0006\"\u001a\u0010\n\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\"\u000e\u0010\u0010\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\"\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016\u00a8\u00063"}, d2={"clockLast", "", "clockNow", "getClockNow", "()D", "setClockNow", "(D)V", "clockSkew", "getClockSkew", "setClockSkew", "frame", "", "getFrame", "()I", "setFrame", "(I)V", "pokeDelay", "pokeHandle", "", "getPokeHandle", "()Ljava/lang/Object;", "setPokeHandle", "(Ljava/lang/Object;)V", "taskHead", "Lio/data2viz/timer/Timer;", "taskTail", "timeoutHandle", "getTimeoutHandle", "setTimeoutHandle", "clearNow", "", "interval", "delay", "startTime", "callback", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "log", "msg", "", "logTimers", "now", "sleep", "time", "(Ljava/lang/Double;)V", "timeout", "timer", "timerFlush", "updateSkew", "updateTimers", "wake", "d2v-timer-jfx"})
public final class TimerKt {
    @Nullable
    private static Object timeoutHandle;
    @Nullable
    private static Object pokeHandle;
    private static int frame;
    private static final int pokeDelay = 1000;
    private static Timer taskHead;
    private static Timer taskTail;
    private static double clockLast;
    private static double clockNow;
    private static double clockSkew;

    @Nullable
    public static final Object getTimeoutHandle() {
        return timeoutHandle;
    }

    public static final void setTimeoutHandle(@Nullable Object object) {
        timeoutHandle = object;
    }

    @Nullable
    public static final Object getPokeHandle() {
        return pokeHandle;
    }

    public static final void setPokeHandle(@Nullable Object object) {
        pokeHandle = object;
    }

    public static final int getFrame() {
        return frame;
    }

    public static final void setFrame(int n) {
        frame = n;
    }

    public static final double getClockNow() {
        return clockNow;
    }

    public static final void setClockNow(double d) {
        clockNow = d;
    }

    public static final double getClockSkew() {
        return clockSkew;
    }

    public static final void setClockSkew(double d) {
        clockSkew = d;
    }

    @NotNull
    public static final Timer timer(double delay, double startTime, @NotNull Function2<? super Timer, ? super Double, Unit> callback) {
        Timer timer;
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        Timer $receiver = timer = new Timer();
        $receiver.restart(delay, startTime, callback);
        return timer;
    }

    @NotNull
    public static /* synthetic */ Timer timer$default(double d, double d2, Function2 function2, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            d2 = TimerKt.now();
        }
        return TimerKt.timer(d, d2, (Function2<? super Timer, ? super Double, Unit>)function2);
    }

    @NotNull
    public static final Timer timeout(double delay, double startTime, @NotNull Function2<? super Timer, ? super Double, Unit> callback) {
        Timer timer;
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        Timer $receiver = timer = new Timer();
        $receiver.restart(delay, startTime, (Function2<? super Timer, ? super Double, Unit>)((Function2)new Function2<Timer, Double, Unit>(delay, startTime, callback){
            final /* synthetic */ double $delay$inlined;
            final /* synthetic */ double $startTime$inlined;
            final /* synthetic */ Function2 $callback$inlined;
            {
                this.$delay$inlined = d;
                this.$startTime$inlined = d2;
                this.$callback$inlined = function2;
                super(2);
            }

            public final void invoke(@NotNull Timer $receiver, double time) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                $receiver.stop();
                this.$callback$inlined.invoke((Object)$receiver, (Object)time);
            }
        }));
        return timer;
    }

    @NotNull
    public static /* synthetic */ Timer timeout$default(double d, double d2, Function2 function2, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            d2 = TimerKt.now();
        }
        return TimerKt.timeout(d, d2, (Function2<? super Timer, ? super Double, Unit>)function2);
    }

    @NotNull
    public static final Timer interval(double delay, double startTime, @NotNull Function2<? super Timer, ? super Double, Unit> callback) {
        Timer timer;
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        interval.1 tick$ = interval.1.INSTANCE;
        double total = delay;
        Timer timer2 = new Timer();
        if (delay == 0.0) {
            // empty if block
        }
        Timer $receiver = timer = new Timer();
        $receiver.restart(delay, startTime, (Function2<? super Timer, ? super Double, Unit>)((Function2)new Function2<Timer, Double, Unit>(delay, startTime, callback){
            final /* synthetic */ double $delay$inlined;
            final /* synthetic */ double $startTime$inlined;
            final /* synthetic */ Function2 $callback$inlined;
            {
                this.$delay$inlined = d;
                this.$startTime$inlined = d2;
                this.$callback$inlined = function2;
                super(2);
            }

            public final void invoke(@NotNull Timer $receiver, double time) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                $receiver.stop();
                this.$callback$inlined.invoke((Object)$receiver, (Object)time);
            }
        }));
        return timer;
    }

    @NotNull
    public static /* synthetic */ Timer interval$default(double d, double d2, Function2 function2, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            d2 = TimerKt.now();
        }
        return TimerKt.interval(d, d2, (Function2<? super Timer, ? super Double, Unit>)function2);
    }

    public static final double now() {
        if (clockNow == 0.0) {
            TimerJVMKt.callInNextFrame((Function0<Unit>)((Function0)now.1.INSTANCE));
            clockNow = TimerJVMKt.delegateNow() + clockSkew;
        }
        return clockNow;
    }

    private static final void clearNow() {
        clockNow = 0.0;
    }

    public static final void timerFlush() {
        TimerKt.log("timerFlush");
        TimerKt.now();
        ++frame;
        for (Timer t = taskHead; t != null; t = t.get_next$d2v_timer_jfx()) {
            double elapsed = clockNow - t.get_time$d2v_timer_jfx();
            if (!(elapsed >= 0.0)) continue;
            Function2<Timer, Double, Unit> function2 = t.get_call$d2v_timer_jfx();
            if (function2 == null) continue;
            Unit cfr_ignored_0 = (Unit)function2.invoke((Object)t, (Object)elapsed);
        }
        frame += -1;
    }

    private static final double updateTimers() {
        Timer t0 = null;
        Timer t1 = taskHead;
        double time = DoubleCompanionObject.INSTANCE.getPOSITIVE_INFINITY();
        int timerCount = 0;
        while (t1 != null) {
            Timer timer;
            ++timerCount;
            if (t1.get_call$d2v_timer_jfx() != null) {
                if (time > t1.get_time$d2v_timer_jfx()) {
                    time = t1.get_time$d2v_timer_jfx();
                }
                t0 = t1;
                t1 = t1.get_next$d2v_timer_jfx();
                continue;
            }
            Timer t2 = t1.get_next$d2v_timer_jfx();
            t1.set_next$d2v_timer_jfx(null);
            if (t0 != null) {
                t0.set_next$d2v_timer_jfx(t2);
                timer = t2;
            } else {
                timer = taskHead = t2;
            }
            t1 = timer;
        }
        taskTail = t0;
        TimerKt.log("after updateTimers, timerCount " + timerCount);
        return time;
    }

    private static final void sleep(Double time) {
        double delay;
        if (frame > 0) {
            return;
        }
        Object object = timeoutHandle;
        if (object != null) {
            Object object2;
            Object it = object2 = object;
            TimerJVMKt.clearTimeout(it);
            timeoutHandle = null;
        }
        if (time != null && (delay = time - clockNow) > (double)24) {
            if (time < DoubleCompanionObject.INSTANCE.getPOSITIVE_INFINITY()) {
                timeoutHandle = TimerJVMKt.setTimeout((Function0<Unit>)((Function0)sleep.2.INSTANCE), (int)delay);
            }
            Object object3 = pokeHandle;
            if (object3 != null) {
                Object object4;
                Object it = object4 = object3;
                TimerJVMKt.clearInterval(it);
                pokeHandle = null;
            }
            return;
        }
        if (pokeHandle == null) {
            clockLast = clockNow;
            pokeHandle = TimerJVMKt.setInterval((Function0<Unit>)((Function0)sleep.4.INSTANCE), 1000);
        }
        frame = 1;
        TimerJVMKt.callInNextFrame((Function0<Unit>)((Function0)sleep.5.INSTANCE));
    }

    static /* synthetic */ void sleep$default(Double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = null;
        }
        TimerKt.sleep(d);
    }

    private static final void updateSkew() {
        TimerKt.log("updateSkew");
        double now2 = TimerKt.now();
        double delay = now2 - clockLast;
        if (delay > (double)1000) {
            clockSkew -= delay;
            clockLast = now2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void wake() {
        TimerKt.log("wake");
        clockLast = TimerKt.now();
        clockNow = clockLast + clockSkew;
        frame = 0;
        timeoutHandle = null;
        try {
            TimerKt.timerFlush();
        }
        finally {
            frame = 0;
            double time = TimerKt.updateTimers();
            TimerKt.sleep(time);
            clockNow = 0.0;
        }
    }

    private static final void log(String msg) {
    }

    private static final String logTimers() {
        StringBuilder sb = new StringBuilder("");
        Timer t = taskHead;
        int i = 0;
        while (t != null) {
            sb.append(" t" + i + '[' + (int)t.get_time$d2v_timer_jfx() + ']');
            t = t.get_next$d2v_timer_jfx();
            ++i;
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @Nullable
    public static final /* synthetic */ Timer access$getTaskTail$p() {
        return taskTail;
    }

    public static final /* synthetic */ void access$setTaskTail$p(@Nullable Timer timer) {
        taskTail = timer;
    }

    @Nullable
    public static final /* synthetic */ Timer access$getTaskHead$p() {
        return taskHead;
    }

    public static final /* synthetic */ void access$setTaskHead$p(@Nullable Timer timer) {
        taskHead = timer;
    }

    public static final /* synthetic */ void access$clearNow() {
        TimerKt.clearNow();
    }

    public static final /* synthetic */ void access$wake() {
        TimerKt.wake();
    }

    public static final /* synthetic */ void access$updateSkew() {
        TimerKt.updateSkew();
    }
}

