/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.viz;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import io.data2viz.color.Color;
import io.data2viz.color.ColorOrGradient;
import io.data2viz.color.ColorStop;
import io.data2viz.color.LinearGradient;
import io.data2viz.viz.AndroidCanvasRenderer;
import io.data2viz.viz.AndroidCanvasRendererKt$WhenMappings;
import io.data2viz.viz.AndroidPathRendererKt;
import io.data2viz.viz.Circle;
import io.data2viz.viz.Group;
import io.data2viz.viz.HasStroke;
import io.data2viz.viz.HasTransform;
import io.data2viz.viz.Line;
import io.data2viz.viz.Node;
import io.data2viz.viz.PathNode;
import io.data2viz.viz.Rect;
import io.data2viz.viz.Rotation;
import io.data2viz.viz.Text;
import io.data2viz.viz.TextAlignmentBaseline;
import io.data2viz.viz.TextAnchor;
import io.data2viz.viz.Transform;
import io.data2viz.viz.Translation;
import io.data2viz.viz.Viz;
import io.data2viz.viz.VizView;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000\u009a\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\u0010\u0004\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n\u001a\u001a\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a\n\u0010\u0017\u001a\u00020\u0018*\u00020\u0001\u001a\n\u0010\u0019\u001a\u00020\u0011*\u00020\n\u001a\u0012\u0010\u001a\u001a\u00020\u001b*\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0012\u0010\u001a\u001a\u00020\u001b*\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0012\u0010\u001a\u001a\u00020\u001b*\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0012\u0010\u001a\u001a\u00020\u001b*\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0012\u0010\u001a\u001a\u00020\u001b*\u00020 2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\n\u0010!\u001a\u00020\u0018*\u00020\"\u001a\u0018\u0010#\u001a\u00060$j\u0002`%*\u00020&2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0018\u0010'\u001a\u00060(j\u0002`)*\u00020*2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\n\u0010+\u001a\u00020\u0018*\u00020,\u001a\u0012\u0010-\u001a\u00020.*\u00020/2\u0006\u00100\u001a\u000201\u001a\u001a\u00102\u001a\u00020\u001b*\u0002032\u0006\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\n*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r*\n\u00104\"\u00020$2\u00020$*\n\u00105\"\u00020(2\u00020(\u00a8\u00066"}, d2={"paint", "Landroid/graphics/Paint;", "getPaint", "()Landroid/graphics/Paint;", "android", "Landroid/graphics/Paint$Align;", "Lio/data2viz/viz/TextAnchor;", "getAndroid", "(Lio/data2viz/viz/TextAnchor;)Landroid/graphics/Paint$Align;", "radToDeg", "", "", "getRadToDeg", "(Ljava/lang/Number;)D", "angle", "alpha", "dy", "", "Lio/data2viz/viz/TextAlignmentBaseline;", "renderer", "Lio/data2viz/viz/AndroidCanvasRenderer;", "fontMetrics", "Landroid/graphics/Paint$FontMetrics;", "getNumberHeight", "", "radToDegrees", "render", "", "Lio/data2viz/viz/Circle;", "Lio/data2viz/viz/Group;", "Lio/data2viz/viz/Line;", "Lio/data2viz/viz/Rect;", "Lio/data2viz/viz/Text;", "toColor", "Lio/data2viz/color/Color;", "toLinearGradient", "Landroid/graphics/LinearGradient;", "Lio/data2viz/viz/ALinearGradient;", "Lio/data2viz/color/LinearGradient;", "toRadialGradient", "Landroid/graphics/RadialGradient;", "Lio/data2viz/viz/ARadialGradient;", "Lio/data2viz/color/RadialGradient;", "toSign", "", "toView", "Lio/data2viz/viz/VizView;", "Lio/data2viz/viz/Viz;", "context", "Landroid/content/Context;", "updatePaint", "Lio/data2viz/color/ColorOrGradient;", "ALinearGradient", "ARadialGradient", "d2v-viz-android_release"})
public final class AndroidCanvasRendererKt {
    @NotNull
    private static final Paint paint;

    @NotNull
    public static final Paint getPaint() {
        return paint;
    }

    @NotNull
    public static final VizView toView(@NotNull Viz $receiver, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new VizView($receiver, context);
    }

    public static final int getNumberHeight(@NotNull Paint $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        android.graphics.Rect rect = new android.graphics.Rect();
        $receiver.getTextBounds("a", 0, 1, rect);
        return rect.height();
    }

    public static final void render(@NotNull Group $receiver, @NotNull AndroidCanvasRenderer renderer) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)renderer, (String)"renderer");
        Canvas canvas = renderer.getCanvas();
        AndroidCanvasRenderer $receiver2 = renderer;
        Iterable $receiver$iv = $receiver.getChildren();
        for (Object element$iv : $receiver$iv) {
            Object it;
            Node node;
            Node node2 = (Node)element$iv;
            if (node2 instanceof HasTransform && ((HasTransform)((Object)node2)).getTransform() != null) {
                it = node;
                Translation translation = ((Transform)it).getTranslate();
                Translation translation2 = ((Transform)it).getTranslate();
                canvas.translate(translation != null ? $receiver2.getDp(translation.getX()) : 0.0f, translation2 != null ? $receiver2.getDp(translation2.getY()) : 0.0f);
                Rotation rotation = ((Transform)it).getRotate();
                canvas.rotate((float)((rotation != null ? rotation.getDelta() : 0.0) * (double)180 / Math.PI));
            }
            if (node2 instanceof HasStroke) {
                Double d = node2.getStyle().getStrokeWidth();
                paint.setStrokeWidth((float)(d != null ? d : 1.0));
            }
            if (node2.getVisible()) {
                node = node2;
                if (node instanceof Circle) {
                    AndroidCanvasRendererKt.render((Circle)node2, renderer);
                } else if (node instanceof Rect) {
                    AndroidCanvasRendererKt.render((Rect)node2, renderer);
                } else if (node instanceof Group) {
                    AndroidCanvasRendererKt.render((Group)node2, renderer);
                } else if (node instanceof PathNode) {
                    AndroidPathRendererKt.render((PathNode)node2, renderer);
                } else if (node instanceof Text) {
                    AndroidCanvasRendererKt.render((Text)node2, renderer);
                } else if (node instanceof Line) {
                    AndroidCanvasRendererKt.render((Line)node2, renderer);
                } else {
                    it = "Unknow type " + Reflection.getOrCreateKotlinClass(node2.getClass());
                    throw (Throwable)new IllegalStateException(it.toString());
                }
            }
            if (!(node2 instanceof HasTransform)) continue;
            if (((HasTransform)((Object)node2)).getTransform() == null) continue;
            it = node;
            Translation translation = ((Transform)it).getTranslate();
            Translation translation3 = ((Transform)it).getTranslate();
            canvas.translate(-(translation != null ? $receiver2.getDp(translation.getX()) : 0.0f), -(translation3 != null ? $receiver2.getDp(translation3.getY()) : 0.0f));
            Rotation rotation = ((Transform)it).getRotate();
            canvas.rotate((float)(-(rotation != null ? rotation.getDelta() : 0.0) * (double)180 / Math.PI));
        }
    }

    public static final void render(@NotNull Circle $receiver, @NotNull AndroidCanvasRenderer renderer) {
        block1: {
            ColorOrGradient it;
            ColorOrGradient colorOrGradient;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)renderer, (String)"renderer");
            Canvas canvas = renderer.getCanvas();
            AndroidCanvasRenderer $receiver2 = renderer;
            ColorOrGradient colorOrGradient2 = $receiver.getStyle().getFill();
            if (colorOrGradient2 != null) {
                it = colorOrGradient = colorOrGradient2;
                paint.setStyle(Paint.Style.FILL);
                AndroidCanvasRendererKt.updatePaint(it, paint, renderer);
                canvas.drawCircle($receiver2.getDp($receiver.getX()), $receiver2.getDp($receiver.getY()), $receiver2.getDp($receiver.getRadius()), paint);
            }
            ColorOrGradient colorOrGradient3 = $receiver.getStyle().getStroke();
            if (colorOrGradient3 == null) break block1;
            it = colorOrGradient = colorOrGradient3;
            paint.setStyle(Paint.Style.STROKE);
            AndroidCanvasRendererKt.updatePaint(it, paint, renderer);
            canvas.drawCircle($receiver2.getDp($receiver.getX()), $receiver2.getDp($receiver.getY()), $receiver2.getDp($receiver.getRadius()), paint);
        }
    }

    public static final void render(@NotNull Text $receiver, @NotNull AndroidCanvasRenderer renderer) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)renderer, (String)"renderer");
        AndroidCanvasRenderer $receiver2 = renderer;
        paint.setStyle(Paint.Style.FILL);
        paint.setTextAlign(AndroidCanvasRendererKt.getAndroid($receiver.getStyle().getAnchor()));
        paint.setColor(-16777216);
        paint.setTextSize($receiver2.getDp(12.0));
        TextAlignmentBaseline textAlignmentBaseline = $receiver.getStyle().getBaseline();
        Paint.FontMetrics fontMetrics = paint.getFontMetrics();
        Intrinsics.checkExpressionValueIsNotNull((Object)fontMetrics, (String)"paint.fontMetrics");
        float dy = AndroidCanvasRendererKt.dy(textAlignmentBaseline, renderer, fontMetrics);
        renderer.getCanvas().drawText($receiver.getTextContent(), $receiver2.getDp($receiver.getX()), $receiver2.getDp($receiver.getY()) - dy, paint);
    }

    public static final float dy(@NotNull TextAlignmentBaseline $receiver, @NotNull AndroidCanvasRenderer renderer, @NotNull Paint.FontMetrics fontMetrics) {
        float f;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)renderer, (String)"renderer");
        Intrinsics.checkParameterIsNotNull((Object)fontMetrics, (String)"fontMetrics");
        AndroidCanvasRenderer $receiver2 = renderer;
        switch (AndroidCanvasRendererKt$WhenMappings.$EnumSwitchMapping$0[$receiver.ordinal()]) {
            case 1: {
                f = 0.0f;
                break;
            }
            case 2: {
                f = fontMetrics.top;
                break;
            }
            case 3: {
                f = fontMetrics.ascent * 0.4f;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return f;
    }

    @NotNull
    public static final Paint.Align getAndroid(@NotNull TextAnchor $receiver) {
        Paint.Align align;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        switch (AndroidCanvasRendererKt$WhenMappings.$EnumSwitchMapping$1[$receiver.ordinal()]) {
            case 1: {
                align = Paint.Align.LEFT;
                break;
            }
            case 2: {
                align = Paint.Align.RIGHT;
                break;
            }
            case 3: {
                align = Paint.Align.CENTER;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return align;
    }

    public static final void render(@NotNull Rect $receiver, @NotNull AndroidCanvasRenderer renderer) {
        block1: {
            ColorOrGradient it;
            ColorOrGradient colorOrGradient;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)renderer, (String)"renderer");
            Canvas canvas = renderer.getCanvas();
            AndroidCanvasRenderer $receiver2 = renderer;
            ColorOrGradient colorOrGradient2 = $receiver.getStyle().getFill();
            if (colorOrGradient2 != null) {
                it = colorOrGradient = colorOrGradient2;
                paint.setStyle(Paint.Style.FILL);
                AndroidCanvasRendererKt.updatePaint(it, paint, renderer);
                canvas.drawRect($receiver2.getDp($receiver.getX()), $receiver2.getDp($receiver.getY()), $receiver2.getDp($receiver.getX() + $receiver.getWidth()), $receiver2.getDp($receiver.getY() + $receiver.getHeight()), paint);
            }
            ColorOrGradient colorOrGradient3 = $receiver.getStyle().getStroke();
            if (colorOrGradient3 == null) break block1;
            it = colorOrGradient = colorOrGradient3;
            paint.setStyle(Paint.Style.STROKE);
            AndroidCanvasRendererKt.updatePaint(it, paint, renderer);
            canvas.drawRect($receiver2.getDp($receiver.getX()), $receiver2.getDp($receiver.getY()), $receiver2.getDp($receiver.getX() + $receiver.getWidth()), $receiver2.getDp($receiver.getY() + $receiver.getHeight()), paint);
        }
    }

    public static final float radToDegrees(double $receiver) {
        return (float)Math.toDegrees($receiver);
    }

    public static final void updatePaint(@NotNull ColorOrGradient $receiver, @NotNull Paint paint, @NotNull AndroidCanvasRenderer renderer) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        Intrinsics.checkParameterIsNotNull((Object)renderer, (String)"renderer");
        ColorOrGradient colorOrGradient = $receiver;
        if (colorOrGradient instanceof Color) {
            paint.setColor(AndroidCanvasRendererKt.toColor((Color)$receiver));
            paint.setShader((Shader)null);
        } else if (colorOrGradient instanceof LinearGradient) {
            paint.setShader((Shader)AndroidCanvasRendererKt.toLinearGradient((LinearGradient)$receiver, renderer));
        } else if (colorOrGradient instanceof io.data2viz.color.RadialGradient) {
            paint.setShader((Shader)AndroidCanvasRendererKt.toRadialGradient((io.data2viz.color.RadialGradient)$receiver, renderer));
        } else {
            String string = "Unknown type :: " + Reflection.getOrCreateKotlinClass($receiver.getClass());
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    private static final RadialGradient toRadialGradient(@NotNull io.data2viz.color.RadialGradient $receiver, AndroidCanvasRenderer renderer) {
        int it;
        int n;
        int[] nArray;
        int i$iv;
        int size$iv;
        RadialGradient radialGradient;
        AndroidCanvasRenderer $receiver2 = renderer;
        int n2 = $receiver.getColorStops().size();
        float f = $receiver2.getDp($receiver.getR());
        float f2 = $receiver2.getDp($receiver.getCy());
        float f3 = $receiver2.getDp($receiver.getCx());
        RadialGradient radialGradient2 = radialGradient;
        RadialGradient radialGradient3 = radialGradient;
        Object[] result$iv = new int[size$iv];
        int n3 = 0;
        int n4 = result$iv.length;
        while (n3 < n4) {
            void var12_12 = i$iv;
            int n5 = i$iv++;
            nArray = result$iv;
            nArray[n5] = n = AndroidCanvasRendererKt.toColor(((ColorStop)$receiver.getColorStops().get(it)).getColor());
        }
        nArray = result$iv;
        size$iv = $receiver.getColorStops().size();
        result$iv = new float[size$iv];
        i$iv = 0;
        n4 = result$iv.length;
        while (i$iv < n4) {
            it = i$iv;
            n = i$iv++;
            Object[] objectArray = result$iv;
            float f4 = (float)((ColorStop)$receiver.getColorStops().get(it)).getPercent();
            objectArray[n] = (int)f4;
        }
        Object[] objectArray = result$iv;
        radialGradient2(f3, f2, f, nArray, (float[])objectArray, Shader.TileMode.CLAMP);
        return radialGradient3;
    }

    private static final android.graphics.LinearGradient toLinearGradient(@NotNull LinearGradient $receiver, AndroidCanvasRenderer renderer) {
        int it;
        int n;
        int[] nArray;
        int i$iv;
        int size$iv;
        android.graphics.LinearGradient linearGradient;
        AndroidCanvasRenderer $receiver2 = renderer;
        int n2 = $receiver.getColorStops().size();
        float f = $receiver2.getDp($receiver.getY2());
        float f2 = $receiver2.getDp($receiver.getX2());
        float f3 = $receiver2.getDp($receiver.getY1());
        float f4 = $receiver2.getDp($receiver.getX1());
        android.graphics.LinearGradient linearGradient2 = linearGradient;
        android.graphics.LinearGradient linearGradient3 = linearGradient;
        Object[] result$iv = new int[size$iv];
        int n3 = 0;
        int n4 = result$iv.length;
        while (n3 < n4) {
            void var13_13 = i$iv;
            int n5 = i$iv++;
            nArray = result$iv;
            nArray[n5] = n = AndroidCanvasRendererKt.toColor(((ColorStop)$receiver.getColorStops().get(it)).getColor());
        }
        nArray = result$iv;
        size$iv = $receiver.getColorStops().size();
        result$iv = new float[size$iv];
        i$iv = 0;
        n4 = result$iv.length;
        while (i$iv < n4) {
            it = i$iv;
            n = i$iv++;
            Object[] objectArray = result$iv;
            float f5 = (float)((ColorStop)$receiver.getColorStops().get(it)).getPercent();
            objectArray[n] = (int)f5;
        }
        Object[] objectArray = result$iv;
        linearGradient2(f4, f3, f2, f, nArray, (float[])objectArray, Shader.TileMode.CLAMP);
        return linearGradient3;
    }

    public static final int toColor(@NotNull Color $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return ((int)((float)255 * $receiver.getAlpha()) & 0xFF) << 24 | ($receiver.getR() & 0xFF) << 16 | ($receiver.getG() & 0xFF) << 8 | $receiver.getB() & 0xFF;
    }

    public static final double angle(double alpha) {
        return alpha > Math.PI ? alpha - Math.PI * 2 : (alpha < -Math.PI ? Math.PI * 2 + alpha : alpha);
    }

    public static final int toSign(boolean $receiver) {
        return $receiver ? 1 : -1;
    }

    public static final double getRadToDeg(@NotNull Number $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.doubleValue() * (double)180 / Math.PI;
    }

    public static final void render(@NotNull Line $receiver, @NotNull AndroidCanvasRenderer renderer) {
        block0: {
            AndroidCanvasRenderer androidCanvasRenderer;
            ColorOrGradient colorOrGradient;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)renderer, (String)"renderer");
            AndroidCanvasRenderer $receiver2 = renderer;
            ColorOrGradient colorOrGradient2 = $receiver.getStyle().getStroke();
            if (colorOrGradient2 == null) break block0;
            ColorOrGradient it = colorOrGradient = colorOrGradient2;
            paint.setStyle(Paint.Style.STROKE);
            Double d = $receiver.getStyle().getStrokeWidth();
            paint.setStrokeWidth(d != null ? $receiver2.getDp(d) : 1.0f);
            AndroidCanvasRendererKt.updatePaint(it, paint, renderer);
            AndroidCanvasRenderer $receiver3 = androidCanvasRenderer = renderer;
            $receiver3.getCanvas().drawLine($receiver3.getDp($receiver.getX1()), $receiver3.getDp($receiver.getY1()), $receiver3.getDp($receiver.getX2()), $receiver3.getDp($receiver.getY2()), paint);
        }
    }

    static {
        Paint paint;
        Paint $receiver = paint = new Paint();
        $receiver.setAntiAlias(true);
        AndroidCanvasRendererKt.paint = paint;
    }
}

