/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.viz;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import io.data2viz.color.ColorOrGradient;
import io.data2viz.path.Arc;
import io.data2viz.path.ArcTo;
import io.data2viz.path.BezierCurveTo;
import io.data2viz.path.ClosePath;
import io.data2viz.path.LineTo;
import io.data2viz.path.MoveTo;
import io.data2viz.path.PathCommand;
import io.data2viz.path.QuadraticCurveTo;
import io.data2viz.path.Rect;
import io.data2viz.viz.AndroidCanvasRenderer;
import io.data2viz.viz.AndroidCanvasRendererKt;
import io.data2viz.viz.AndroidPathRendererKt;
import io.data2viz.viz.PathNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function7;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"render", "", "Lio/data2viz/viz/PathNode;", "renderer", "Lio/data2viz/viz/AndroidCanvasRenderer;", "d2v-viz-android_release"})
public final class AndroidPathRendererKt {
    /*
     * WARNING - void declaration
     */
    public static final void render(@NotNull PathNode $receiver, @NotNull AndroidCanvasRenderer renderer) {
        block11: {
            ColorOrGradient colorOrGradient;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)renderer, (String)"renderer");
            Canvas canvas = renderer.getCanvas();
            render.1 last$ = render.1.INSTANCE;
            Path path = new Path();
            Function7<Double, Double, Double, Double, Double, Double, Double, Unit> arcTo$ = new Function7<Double, Double, Double, Double, Double, Double, Double, Unit>(renderer, path){
                final /* synthetic */ AndroidCanvasRenderer $renderer;
                final /* synthetic */ Path $path;

                public final void invoke(double lastX, double lastY, double cpX, double cpY, double x, double y, double r) {
                    double d;
                    AndroidCanvasRenderer androidCanvasRenderer;
                    AndroidCanvasRenderer $receiver = androidCanvasRenderer = this.$renderer;
                    double d2 = lastY - cpY;
                    double d3 = lastX - cpX;
                    double alpha1 = Math.atan2(d2, d3);
                    d3 = y - cpY;
                    double d4 = x - cpX;
                    double alpha2 = Math.atan2(d3, d4);
                    double alpha = AndroidCanvasRendererKt.angle(alpha1 - alpha2);
                    double d5 = alpha / (double)2;
                    double d6 = r;
                    d5 = d = Math.sin(d5);
                    d = Math.abs(d5);
                    double d7 = d6 / d;
                    double d8 = alpha1 - alpha / (double)2;
                    d = d7;
                    d6 = cpX;
                    double d9 = Math.cos(d8);
                    double cx = d6 + d * d9;
                    double d10 = alpha1 - alpha / (double)2;
                    d = d7;
                    d6 = cpY;
                    d9 = Math.sin(d10);
                    double cy = d6 + d * d9;
                    boolean clockwise = alpha > 0.0;
                    float startAngle = (float)AndroidCanvasRendererKt.getRadToDeg(alpha1) + (float)AndroidCanvasRendererKt.toSign(clockwise) * 90.0f;
                    float sweepAngle = clockwise ? (float)360 - (180.0f + (float)AndroidCanvasRendererKt.getRadToDeg(alpha)) % 360.0f : (-180.0f - (float)AndroidCanvasRendererKt.getRadToDeg(alpha)) % 360.0f;
                    this.$path.moveTo($receiver.getDp(lastX), $receiver.getDp(lastY));
                    this.$path.arcTo(new RectF($receiver.getDp(cx - r), $receiver.getDp(cy - r), $receiver.getDp(cx + r), $receiver.getDp(cy + r)), startAngle, sweepAngle, false);
                    this.$path.lineTo($receiver.getDp(x), $receiver.getDp(y));
                }
                {
                    this.$renderer = androidCanvasRenderer;
                    this.$path = path;
                    super(7);
                }
            };
            Iterable $receiver$iv = $receiver.getPath().getCommands();
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                void cmd;
                AndroidCanvasRenderer androidCanvasRenderer;
                int n = index$iv++;
                PathCommand pathCommand = (PathCommand)item$iv;
                int index = n;
                AndroidCanvasRenderer $receiver2 = androidCanvasRenderer = renderer;
                void var14_16 = cmd;
                if (var14_16 instanceof MoveTo) {
                    path.moveTo($receiver2.getDp(cmd.getX()), $receiver2.getDp(cmd.getY()));
                    continue;
                }
                if (var14_16 instanceof LineTo) {
                    path.lineTo($receiver2.getDp(cmd.getX()), $receiver2.getDp(cmd.getY()));
                    continue;
                }
                if (var14_16 instanceof QuadraticCurveTo) {
                    path.quadTo($receiver2.getDp(((QuadraticCurveTo)cmd).getCpx()), $receiver2.getDp(((QuadraticCurveTo)cmd).getCpy()), $receiver2.getDp(cmd.getX()), $receiver2.getDp(cmd.getY()));
                    continue;
                }
                if (var14_16 instanceof BezierCurveTo) {
                    path.cubicTo($receiver2.getDp(((BezierCurveTo)cmd).getCpx1()), $receiver2.getDp(((BezierCurveTo)cmd).getCpy1()), $receiver2.getDp(((BezierCurveTo)cmd).getCpx2()), $receiver2.getDp(((BezierCurveTo)cmd).getCpy2()), $receiver2.getDp(cmd.getX()), $receiver2.getDp(cmd.getY()));
                    continue;
                }
                if (var14_16 instanceof Arc) {
                    float left = $receiver2.getDp(((Arc)cmd).getCenterX() - ((Arc)cmd).getRadius());
                    float right = $receiver2.getDp(((Arc)cmd).getCenterX() + ((Arc)cmd).getRadius());
                    float top = $receiver2.getDp(((Arc)cmd).getCenterY() - ((Arc)cmd).getRadius());
                    float bottom = $receiver2.getDp(((Arc)cmd).getCenterY() + ((Arc)cmd).getRadius());
                    float startAngle = AndroidCanvasRendererKt.radToDegrees(((Arc)cmd).getStartAngle());
                    float sweepAngle = (AndroidCanvasRendererKt.radToDegrees(((Arc)cmd).getEndAngle()) + (float)360 - AndroidCanvasRendererKt.radToDegrees(((Arc)cmd).getStartAngle())) % (float)360;
                    if (((Arc)cmd).getCounterClockWise()) {
                        sweepAngle -= (float)360;
                    }
                    path.arcTo(new RectF(left, top, right, bottom), startAngle, sweepAngle);
                    continue;
                }
                if (var14_16 instanceof ArcTo) {
                    arcTo$.invoke(render.1.INSTANCE.invoke($receiver, index).getX(), render.1.INSTANCE.invoke($receiver, index).getY(), ((ArcTo)cmd).getFromX(), ((ArcTo)cmd).getFromY(), cmd.getX(), cmd.getY(), ((ArcTo)cmd).getRadius());
                    continue;
                }
                if (var14_16 instanceof Rect) {
                    path.addRect($receiver2.getDp(cmd.getX()), $receiver2.getDp(cmd.getY()), $receiver2.getDp(cmd.getX() + ((Rect)cmd).getW()), $receiver2.getDp(cmd.getY() + ((Rect)cmd).getH()), Path.Direction.CW);
                    continue;
                }
                if (var14_16 instanceof ClosePath) {
                    path.close();
                    continue;
                }
                String string = "Unknown path command:: " + Reflection.getOrCreateKotlinClass(cmd.getClass());
                throw (Throwable)new IllegalStateException(string.toString());
            }
            ColorOrGradient colorOrGradient2 = $receiver.getStyle().getFill();
            if (colorOrGradient2 != null) {
                ColorOrGradient it = colorOrGradient = colorOrGradient2;
                AndroidCanvasRendererKt.getPaint().setStyle(Paint.Style.FILL);
                AndroidCanvasRendererKt.updatePaint(it, AndroidCanvasRendererKt.getPaint(), renderer);
                canvas.drawPath(path, AndroidCanvasRendererKt.getPaint());
            }
            ColorOrGradient colorOrGradient3 = $receiver.getStyle().getStroke();
            if (colorOrGradient3 == null) break block11;
            ColorOrGradient it = colorOrGradient = colorOrGradient3;
            AndroidCanvasRendererKt.getPaint().setStyle(Paint.Style.STROKE);
            AndroidCanvasRendererKt.updatePaint(it, AndroidCanvasRendererKt.getPaint(), renderer);
            canvas.drawPath(path, AndroidCanvasRendererKt.getPaint());
        }
    }
}

