/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.viz;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import io.data2viz.color.ColorOrGradient;
import io.data2viz.geom.Arc;
import io.data2viz.geom.ArcTo;
import io.data2viz.geom.BezierCurveTo;
import io.data2viz.geom.ClosePath;
import io.data2viz.geom.LineTo;
import io.data2viz.geom.MoveTo;
import io.data2viz.geom.PathCommand;
import io.data2viz.geom.QuadraticCurveTo;
import io.data2viz.geom.RectCmd;
import io.data2viz.viz.AndroidCanvasRenderer;
import io.data2viz.viz.AndroidCanvasRendererKt;
import io.data2viz.viz.AndroidPathRendererKt;
import io.data2viz.viz.PathNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function7;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"EPSILON_CIRCLE", "", "EPSILON_FLOAT", "render", "", "Lio/data2viz/viz/PathNode;", "renderer", "Lio/data2viz/viz/AndroidCanvasRenderer;", "d2v-viz-android_release"})
public final class AndroidPathRendererKt {
    private static final float EPSILON_FLOAT = 1.0E-4f;
    private static final float EPSILON_CIRCLE = 359.9999f;

    /*
     * WARNING - void declaration
     */
    public static final void render(@NotNull PathNode $receiver, @NotNull AndroidCanvasRenderer renderer) {
        block16: {
            ColorOrGradient colorOrGradient;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
            Intrinsics.checkParameterIsNotNull((Object)renderer, (String)"renderer");
            Canvas canvas = renderer.getCanvas();
            render.1 last$ = render.1.INSTANCE;
            Path path = new Path();
            Function7<Double, Double, Double, Double, Double, Double, Double, Unit> arcTo$ = new Function7<Double, Double, Double, Double, Double, Double, Double, Unit>(renderer, path){
                final /* synthetic */ AndroidCanvasRenderer $renderer;
                final /* synthetic */ Path $path;

                public final void invoke(double lastX, double lastY, double cpX, double cpY, double x, double y, double r) {
                    double d;
                    AndroidCanvasRenderer androidCanvasRenderer;
                    AndroidCanvasRenderer $receiver = androidCanvasRenderer = this.$renderer;
                    double d2 = lastY - cpY;
                    double d3 = lastX - cpX;
                    double alpha1 = Math.atan2(d2, d3);
                    d3 = y - cpY;
                    double d4 = x - cpX;
                    double alpha2 = Math.atan2(d3, d4);
                    double alpha = AndroidCanvasRendererKt.angle(alpha1 - alpha2);
                    double d5 = alpha / (double)2;
                    double d6 = r;
                    d5 = d = Math.sin(d5);
                    d = Math.abs(d5);
                    double d7 = d6 / d;
                    double d8 = alpha1 - alpha / (double)2;
                    d = d7;
                    d6 = cpX;
                    double d9 = Math.cos(d8);
                    double cx = d6 + d * d9;
                    double d10 = alpha1 - alpha / (double)2;
                    d = d7;
                    d6 = cpY;
                    d9 = Math.sin(d10);
                    double cy = d6 + d * d9;
                    boolean clockwise = alpha > 0.0;
                    float startAngle = (float)AndroidCanvasRendererKt.getRadToDeg(alpha1) + (float)AndroidCanvasRendererKt.toSign(clockwise) * 90.0f;
                    float sweepAngle = clockwise ? (float)360 - (180.0f + (float)AndroidCanvasRendererKt.getRadToDeg(alpha)) % 360.0f : (-180.0f - (float)AndroidCanvasRendererKt.getRadToDeg(alpha)) % 360.0f;
                    this.$path.moveTo($receiver.getDp(lastX), $receiver.getDp(lastY));
                    this.$path.arcTo(new RectF($receiver.getDp(cx - r), $receiver.getDp(cy - r), $receiver.getDp(cx + r), $receiver.getDp(cy + r)), startAngle, sweepAngle, false);
                    this.$path.lineTo($receiver.getDp(x), $receiver.getDp(y));
                }
                {
                    this.$renderer = androidCanvasRenderer;
                    this.$path = path;
                    super(7);
                }
            };
            Iterable $receiver$iv = $receiver.getPath().getCommands();
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                void cmd;
                AndroidCanvasRenderer androidCanvasRenderer;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                PathCommand pathCommand = (PathCommand)item$iv;
                int index = n2;
                AndroidCanvasRenderer $receiver2 = androidCanvasRenderer = renderer;
                void var16_18 = cmd;
                if (var16_18 instanceof MoveTo) {
                    path.moveTo($receiver2.getDp(cmd.getX()), $receiver2.getDp(cmd.getY()));
                    continue;
                }
                if (var16_18 instanceof LineTo) {
                    path.lineTo($receiver2.getDp(cmd.getX()), $receiver2.getDp(cmd.getY()));
                    continue;
                }
                if (var16_18 instanceof QuadraticCurveTo) {
                    path.quadTo($receiver2.getDp(((QuadraticCurveTo)cmd).getCpx()), $receiver2.getDp(((QuadraticCurveTo)cmd).getCpy()), $receiver2.getDp(cmd.getX()), $receiver2.getDp(cmd.getY()));
                    continue;
                }
                if (var16_18 instanceof BezierCurveTo) {
                    path.cubicTo($receiver2.getDp(((BezierCurveTo)cmd).getCpx1()), $receiver2.getDp(((BezierCurveTo)cmd).getCpy1()), $receiver2.getDp(((BezierCurveTo)cmd).getCpx2()), $receiver2.getDp(((BezierCurveTo)cmd).getCpy2()), $receiver2.getDp(cmd.getX()), $receiver2.getDp(cmd.getY()));
                    continue;
                }
                if (var16_18 instanceof ArcTo) {
                    arcTo$.invoke(render.1.INSTANCE.invoke($receiver, index).getX(), render.1.INSTANCE.invoke($receiver, index).getY(), ((ArcTo)cmd).getFromX(), ((ArcTo)cmd).getFromY(), cmd.getX(), cmd.getY(), ((ArcTo)cmd).getRadius());
                    continue;
                }
                if (var16_18 instanceof RectCmd) {
                    path.addRect($receiver2.getDp(cmd.getX()), $receiver2.getDp(cmd.getY()), $receiver2.getDp(cmd.getX() + ((RectCmd)cmd).getW()), $receiver2.getDp(cmd.getY() + ((RectCmd)cmd).getH()), Path.Direction.CW);
                    continue;
                }
                if (var16_18 instanceof ClosePath) {
                    path.close();
                    continue;
                }
                if (var16_18 instanceof Arc) {
                    float f;
                    double r = ((Arc)cmd).getRadius();
                    RectF rect = new RectF($receiver2.getDp(((Arc)cmd).getCenterX() - r), $receiver2.getDp(((Arc)cmd).getCenterY() - r), $receiver2.getDp(((Arc)cmd).getCenterX() + r), $receiver2.getDp(((Arc)cmd).getCenterY() + r));
                    float startAngle = AndroidCanvasRendererKt.radToDegrees(((Arc)cmd).getStartAngle());
                    float sweepAngle = AndroidCanvasRendererKt.radToDegrees(((Arc)cmd).getEndAngle()) - startAngle;
                    if (!((Arc)cmd).getCounterClockWise() && sweepAngle < -1.0E-4f) {
                        sweepAngle = sweepAngle % (float)360 + (float)360;
                    }
                    if (((Arc)cmd).getCounterClockWise() && sweepAngle > 1.0E-4f) {
                        sweepAngle = sweepAngle % (float)360 - (float)360;
                    }
                    if (Math.abs(f = sweepAngle) > (float)360) {
                        sweepAngle = 359.9999f;
                    } else {
                        f = sweepAngle;
                        if (Math.abs(f) < (float)-360) {
                            sweepAngle = -359.9999f;
                        }
                    }
                    path.arcTo(rect, startAngle, sweepAngle);
                    continue;
                }
                String string = "Unknown path command:: " + Reflection.getOrCreateKotlinClass(cmd.getClass());
                throw (Throwable)new IllegalStateException(string.toString());
            }
            ColorOrGradient colorOrGradient2 = $receiver.getStyle().getFill();
            if (colorOrGradient2 != null) {
                ColorOrGradient it = colorOrGradient = colorOrGradient2;
                AndroidCanvasRendererKt.getPaint().setStyle(Paint.Style.FILL);
                AndroidCanvasRendererKt.updatePaint(it, AndroidCanvasRendererKt.getPaint(), renderer);
                canvas.drawPath(path, AndroidCanvasRendererKt.getPaint());
            }
            ColorOrGradient colorOrGradient3 = $receiver.getStyle().getStroke();
            if (colorOrGradient3 == null) break block16;
            ColorOrGradient it = colorOrGradient = colorOrGradient3;
            AndroidCanvasRendererKt.getPaint().setStyle(Paint.Style.STROKE);
            AndroidCanvasRendererKt.updatePaint(it, AndroidCanvasRendererKt.getPaint(), renderer);
            canvas.drawPath(path, AndroidCanvasRendererKt.getPaint());
        }
    }
}

