/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.viz;

import android.content.Context;
import android.graphics.Canvas;
import android.view.View;
import io.data2viz.timer.Timer;
import io.data2viz.timer.TimerKt;
import io.data2viz.viz.AndroidCanvasRenderer;
import io.data2viz.viz.Viz;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J(\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0014J\u0006\u0010\u001f\u001a\u00020\u0017J\u0006\u0010 \u001a\u00020\u0017J\u0006\u0010!\u001a\u00020\u0017R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lio/data2viz/viz/VizView;", "Landroid/view/View;", "viz", "Lio/data2viz/viz/Viz;", "context", "Landroid/content/Context;", "(Lio/data2viz/viz/Viz;Landroid/content/Context;)V", "drawCount", "", "getDrawCount", "()I", "setDrawCount", "(I)V", "renderer", "Lio/data2viz/viz/AndroidCanvasRenderer;", "startTime", "", "timers", "", "Lio/data2viz/timer/Timer;", "getViz", "()Lio/data2viz/viz/Viz;", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "h", "oldw", "oldh", "startAnimations", "stopAnimations", "updateScale", "d2v-viz-android_release"})
public final class VizView
extends View {
    private final AndroidCanvasRenderer renderer;
    private final List<Timer> timers;
    private int drawCount;
    private long startTime;
    @NotNull
    private final Viz viz;

    public final void startAnimations() {
        Collection collection = this.viz.getAnimations$d2v_viz_android_release();
        if (!collection.isEmpty()) {
            Iterable $receiver$iv = this.viz.getAnimations$d2v_viz_android_release();
            for (Object element$iv : $receiver$iv) {
                Function1 anim = (Function1)element$iv;
                Collection collection2 = this.timers;
                Timer timer = TimerKt.timer$default((double)0.0, (double)0.0, (Function2)((Function2)new Function2<Timer, Double, Unit>(anim){
                    final /* synthetic */ Function1 $anim;

                    public final void invoke(@NotNull Timer $receiver, double time) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                        this.$anim.invoke((Object)time);
                    }
                    {
                        this.$anim = function1;
                        super(2);
                    }
                }), (int)3, null);
                collection2.add(timer);
            }
            collection = this.timers;
            Timer timer = TimerKt.timer$default((double)0.0, (double)0.0, (Function2)((Function2)new Function2<Timer, Double, Unit>(this){
                final /* synthetic */ VizView this$0;

                public final void invoke(@NotNull Timer $receiver, double it) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                    this.this$0.invalidate();
                }
                {
                    this.this$0 = vizView;
                    super(2);
                }
            }), (int)3, null);
            collection.add(timer);
        }
    }

    public final void stopAnimations() {
        for (Timer timer : this.timers) {
            timer.stop();
        }
        this.timers.clear();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.viz.resize(w, h);
        this.updateScale();
    }

    public final void updateScale() {
        this.renderer.setScale((float)((double)this.getWidth() / this.viz.getWidth()));
    }

    public final int getDrawCount() {
        return this.drawCount;
    }

    public final void setDrawCount(int n) {
        this.drawCount = n;
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        int n = this.drawCount;
        this.drawCount = n + 1;
        if (this.drawCount == 100) {
            long delta = System.currentTimeMillis() - this.startTime;
            long fps = (long)100000 / delta;
            this.startTime = System.currentTimeMillis();
            this.drawCount = -1;
        }
        this.renderer.setCanvas(canvas);
        this.renderer.render(this.viz);
    }

    @NotNull
    public final Viz getViz() {
        return this.viz;
    }

    public VizView(@NotNull Viz viz2, @NotNull Context context) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)viz2, (String)"viz");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.viz = viz2;
        this.renderer = new AndroidCanvasRenderer(context, this.viz, null, 4, null);
        VizView vizView = this;
        vizView.timers = list = (List)new ArrayList();
        this.drawCount = -1;
        this.startTime = System.currentTimeMillis();
    }
}

