/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.viz;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import io.data2viz.color.ColorOrGradient;
import io.data2viz.geom.Arc;
import io.data2viz.geom.ArcTo;
import io.data2viz.geom.BezierCurveTo;
import io.data2viz.geom.ClosePath;
import io.data2viz.geom.LineTo;
import io.data2viz.geom.MoveTo;
import io.data2viz.geom.PathCommand;
import io.data2viz.geom.QuadraticCurveTo;
import io.data2viz.geom.RectCmd;
import io.data2viz.viz.AndroidCanvasRenderer;
import io.data2viz.viz.AndroidCanvasRendererKt;
import io.data2viz.viz.AndroidColorOrGradientRendererKt;
import io.data2viz.viz.AndroidPathRendererKt;
import io.data2viz.viz.PathNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function7;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\u0010\u0004\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0000\u001a\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0004\u001a\u0012\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0012\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"EPSILON_CIRCLE", "", "EPSILON_FLOAT", "radToDeg", "", "", "getRadToDeg", "(Ljava/lang/Number;)D", "angle", "alpha", "radToDegrees", "render", "", "Lio/data2viz/viz/PathNode;", "renderer", "Lio/data2viz/viz/AndroidCanvasRenderer;", "toSign", "", "", "d2v-viz-android_release"})
public final class AndroidPathRendererKt {
    private static final float EPSILON_FLOAT = 1.0E-4f;
    private static final float EPSILON_CIRCLE = 359.9999f;

    /*
     * WARNING - void declaration
     */
    public static final void render(@NotNull PathNode $this$render, @NotNull AndroidCanvasRenderer renderer2) {
        block16: {
            ColorOrGradient it;
            boolean bl;
            boolean bl2;
            ColorOrGradient colorOrGradient;
            Intrinsics.checkParameterIsNotNull((Object)$this$render, (String)"$this$render");
            Intrinsics.checkParameterIsNotNull((Object)renderer2, (String)"renderer");
            Canvas canvas = renderer2.getCanvas();
            render.1 $fun$last$1 = render.1.INSTANCE;
            Path path = new Path();
            RectF rect = new RectF();
            Function7<Double, Double, Double, Double, Double, Double, Double, Unit> $fun$arcTo$2 = new Function7<Double, Double, Double, Double, Double, Double, Double, Unit>(renderer2, path, rect){
                final /* synthetic */ AndroidCanvasRenderer $renderer;
                final /* synthetic */ Path $path;
                final /* synthetic */ RectF $rect;

                public final void invoke(double lastX, double lastY, double cpX, double cpY, double x, double y, double r) {
                    double d;
                    AndroidCanvasRenderer androidCanvasRenderer = this.$renderer;
                    boolean bl = false;
                    boolean bl2 = false;
                    AndroidCanvasRenderer $this$with = androidCanvasRenderer;
                    boolean bl3 = false;
                    double d2 = lastY - cpY;
                    double d3 = lastX - cpX;
                    boolean bl4 = false;
                    double alpha1 = Math.atan2(d2, d3);
                    d3 = y - cpY;
                    double d4 = x - cpX;
                    boolean bl5 = false;
                    double alpha2 = Math.atan2(d3, d4);
                    double alpha = AndroidPathRendererKt.angle(alpha1 - alpha2);
                    double d5 = alpha / (double)2;
                    double d6 = r;
                    boolean bl6 = false;
                    d5 = d = Math.sin(d5);
                    bl6 = false;
                    d = Math.abs(d5);
                    double d7 = d6 / d;
                    double d8 = alpha1 - alpha / (double)2;
                    d = d7;
                    d6 = cpX;
                    boolean bl7 = false;
                    double d9 = Math.cos(d8);
                    double cx = d6 + d * d9;
                    double d10 = alpha1 - alpha / (double)2;
                    d = d7;
                    d6 = cpY;
                    boolean bl8 = false;
                    d9 = Math.sin(d10);
                    double cy = d6 + d * d9;
                    boolean clockwise = alpha > 0.0;
                    float startAngle = (float)AndroidPathRendererKt.getRadToDeg(alpha1) + (float)AndroidPathRendererKt.toSign(clockwise) * 90.0f;
                    float sweepAngle = clockwise ? (float)360 - (180.0f + (float)AndroidPathRendererKt.getRadToDeg(alpha)) % 360.0f : (-180.0f - (float)AndroidPathRendererKt.getRadToDeg(alpha)) % 360.0f;
                    this.$path.moveTo($this$with.getDp(lastX), $this$with.getDp(lastY));
                    this.$rect.left = $this$with.getDp(cx - r);
                    this.$rect.top = $this$with.getDp(cy - r);
                    this.$rect.right = $this$with.getDp(cx + r);
                    this.$rect.bottom = $this$with.getDp(cy + r);
                    this.$path.arcTo(this.$rect, startAngle, sweepAngle, false);
                    this.$path.lineTo($this$with.getDp(x), $this$with.getDp(y));
                }
                {
                    this.$renderer = androidCanvasRenderer;
                    this.$path = path;
                    this.$rect = rectF;
                    super(7);
                }
            };
            Iterable $this$forEachIndexed$iv = $this$render.getPath().getCommands();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void cmd;
                int n = index$iv++;
                boolean bl3 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                PathCommand pathCommand = (PathCommand)item$iv;
                int index = n2;
                boolean bl4 = false;
                AndroidCanvasRenderer androidCanvasRenderer = renderer2;
                boolean bl5 = false;
                boolean bl6 = false;
                AndroidCanvasRenderer $this$with = androidCanvasRenderer;
                boolean bl7 = false;
                void var23_25 = cmd;
                if (var23_25 instanceof MoveTo) {
                    path.moveTo($this$with.getDp(cmd.getX()), $this$with.getDp(cmd.getY()));
                    continue;
                }
                if (var23_25 instanceof LineTo) {
                    path.lineTo($this$with.getDp(cmd.getX()), $this$with.getDp(cmd.getY()));
                    continue;
                }
                if (var23_25 instanceof QuadraticCurveTo) {
                    path.quadTo($this$with.getDp(((QuadraticCurveTo)cmd).getCpx()), $this$with.getDp(((QuadraticCurveTo)cmd).getCpy()), $this$with.getDp(cmd.getX()), $this$with.getDp(cmd.getY()));
                    continue;
                }
                if (var23_25 instanceof BezierCurveTo) {
                    path.cubicTo($this$with.getDp(((BezierCurveTo)cmd).getCpx1()), $this$with.getDp(((BezierCurveTo)cmd).getCpy1()), $this$with.getDp(((BezierCurveTo)cmd).getCpx2()), $this$with.getDp(((BezierCurveTo)cmd).getCpy2()), $this$with.getDp(cmd.getX()), $this$with.getDp(cmd.getY()));
                    continue;
                }
                if (var23_25 instanceof ArcTo) {
                    PathCommand last = render.1.INSTANCE.invoke($this$render, index);
                    $fun$arcTo$2.invoke(last.getX(), last.getY(), ((ArcTo)cmd).getFromX(), ((ArcTo)cmd).getFromY(), cmd.getX(), cmd.getY(), ((ArcTo)cmd).getRadius());
                    continue;
                }
                if (var23_25 instanceof RectCmd) {
                    path.addRect($this$with.getDp(cmd.getX()), $this$with.getDp(cmd.getY()), $this$with.getDp(cmd.getX() + ((RectCmd)cmd).getW()), $this$with.getDp(cmd.getY() + ((RectCmd)cmd).getH()), Path.Direction.CW);
                    continue;
                }
                if (var23_25 instanceof ClosePath) {
                    path.close();
                    continue;
                }
                if (var23_25 instanceof Arc) {
                    double r = ((Arc)cmd).getRadius();
                    rect.left = $this$with.getDp(((Arc)cmd).getCenterX() - r);
                    rect.top = $this$with.getDp(((Arc)cmd).getCenterY() - r);
                    rect.right = $this$with.getDp(((Arc)cmd).getCenterX() + r);
                    rect.bottom = $this$with.getDp(((Arc)cmd).getCenterY() + r);
                    float startAngle = AndroidPathRendererKt.radToDegrees(((Arc)cmd).getStartAngle());
                    float sweepAngle = AndroidPathRendererKt.radToDegrees(((Arc)cmd).getEndAngle()) - startAngle;
                    if (!((Arc)cmd).getCounterClockWise() && sweepAngle < -1.0E-4f) {
                        sweepAngle = sweepAngle % (float)360 + (float)360;
                    }
                    if (((Arc)cmd).getCounterClockWise() && sweepAngle > 1.0E-4f) {
                        sweepAngle = sweepAngle % (float)360 - (float)360;
                    }
                    float f = sweepAngle;
                    boolean bl8 = false;
                    if (Math.abs(f) > (float)360) {
                        sweepAngle = 359.9999f;
                    } else {
                        f = sweepAngle;
                        bl8 = false;
                        if (Math.abs(f) < (float)-360) {
                            sweepAngle = -359.9999f;
                        }
                    }
                    path.arcTo(rect, startAngle, sweepAngle);
                    continue;
                }
                String string = "Unknown path command:: " + Reflection.getOrCreateKotlinClass(cmd.getClass());
                boolean bl9 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            ColorOrGradient colorOrGradient2 = $this$render.getFill();
            if (colorOrGradient2 != null) {
                colorOrGradient = colorOrGradient2;
                bl2 = false;
                bl = false;
                it = colorOrGradient;
                boolean bl10 = false;
                AndroidCanvasRendererKt.getPaint().setStyle(Paint.Style.FILL);
                AndroidColorOrGradientRendererKt.updatePaint(it, AndroidCanvasRendererKt.getPaint(), renderer2);
                canvas.drawPath(path, AndroidCanvasRendererKt.getPaint());
            }
            ColorOrGradient colorOrGradient3 = $this$render.getStroke();
            if (colorOrGradient3 == null) break block16;
            colorOrGradient = colorOrGradient3;
            bl2 = false;
            bl = false;
            it = colorOrGradient;
            boolean bl11 = false;
            AndroidCanvasRendererKt.getPaint().setStyle(Paint.Style.STROKE);
            AndroidColorOrGradientRendererKt.updatePaint(it, AndroidCanvasRendererKt.getPaint(), renderer2);
            canvas.drawPath(path, AndroidCanvasRendererKt.getPaint());
        }
    }

    public static final double getRadToDeg(@NotNull Number $this$radToDeg) {
        Intrinsics.checkParameterIsNotNull((Object)$this$radToDeg, (String)"$this$radToDeg");
        return $this$radToDeg.doubleValue() * (double)180 / Math.PI;
    }

    public static final double angle(double alpha) {
        return alpha > Math.PI ? alpha - Math.PI * 2 : (alpha < -Math.PI ? Math.PI * 2 + alpha : alpha);
    }

    public static final int toSign(boolean $this$toSign) {
        return $this$toSign ? 1 : -1;
    }

    public static final float radToDegrees(double $this$radToDegrees) {
        return (float)Math.toDegrees($this$radToDegrees);
    }
}

