/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.viz;

import io.data2viz.geom.Point;
import io.data2viz.viz.ExperimentalKEvent;
import io.data2viz.viz.KEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lio/data2viz/viz/KZoomEvent;", "Lio/data2viz/viz/KEvent;", "startZoomPos", "Lio/data2viz/geom/Point;", "delta", "", "(Lio/data2viz/geom/Point;D)V", "getDelta", "()D", "getStartZoomPos", "()Lio/data2viz/geom/Point;", "toString", "", "Companion", "d2v-viz-android_release"})
@ExperimentalKEvent
public final class KZoomEvent
implements KEvent {
    @NotNull
    private final Point startZoomPos;
    private final double delta;
    public static final int diffTimeBetweenZoomEventsToDetectRestart = 500;
    public static final double minDelta = -100.0;
    public static final double maxDelta = 100.0;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String toString() {
        return "KZoomEvent(startZoomPos=" + this.startZoomPos + ", delta=" + this.delta + ')';
    }

    @NotNull
    public final Point getStartZoomPos() {
        return this.startZoomPos;
    }

    public final double getDelta() {
        return this.delta;
    }

    public KZoomEvent(@NotNull Point startZoomPos, double delta) {
        Intrinsics.checkParameterIsNotNull((Object)startZoomPos, (String)"startZoomPos");
        this.startZoomPos = startZoomPos;
        this.delta = delta;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\fJ\u001d\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\r2\b\u0010\u000b\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ2\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\b\b\u0002\u0010\u0013\u001a\u00020\u00062\b\b\u0002\u0010\u0014\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/data2viz/viz/KZoomEvent$Companion;", "", "()V", "diffTimeBetweenZoomEventsToDetectRestart", "", "maxDelta", "", "minDelta", "isNewZoom", "", "currentTime", "lastTime", "(DLjava/lang/Double;)Z", "", "(JLjava/lang/Long;)Z", "scaleDelta", "currentDelta", "originMinDelta", "originMaxDelta", "newMinDelta", "newMaxDelta", "d2v-viz-android_release"})
    public static final class Companion {
        public final boolean isNewZoom(double currentTime, @Nullable Double lastTime) {
            return lastTime == null ? true : currentTime - lastTime > (double)500;
        }

        public final boolean isNewZoom(long currentTime, @Nullable Long lastTime) {
            return lastTime == null ? true : currentTime - lastTime > (long)500;
        }

        public final double scaleDelta(double currentDelta, double originMinDelta, double originMaxDelta, double newMinDelta, double newMaxDelta) {
            double newBoundsSize = newMaxDelta - newMinDelta;
            double originBoundsSize = originMaxDelta - originMinDelta;
            double currentDeltaPercentInBounds = (currentDelta - originMinDelta) / originBoundsSize;
            double newDeltaValue = newMinDelta + newBoundsSize * currentDeltaPercentInBounds;
            if (newDeltaValue > 100.0) {
                newDeltaValue = 100.0;
            }
            if (newDeltaValue < -100.0) {
                newDeltaValue = -100.0;
            }
            return newDeltaValue;
        }

        public static /* synthetic */ double scaleDelta$default(Companion companion, double d, double d2, double d3, double d4, double d5, int n, Object object) {
            if ((n & 8) != 0) {
                d4 = -100.0;
            }
            if ((n & 0x10) != 0) {
                d5 = 100.0;
            }
            return companion.scaleDelta(d, d2, d3, d4, d5);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

