package io.datalbry.config.processor.kotlin.extension

import com.fasterxml.jackson.databind.ObjectMapper
import com.fasterxml.jackson.databind.SerializationFeature
import com.fasterxml.jackson.module.kotlin.jacksonObjectMapper

/**
 * Simple preconfigured jackson
 *
 * The schema is very likely to be read by humans, we indent the output per default
 *
 * @return preconfigured [ObjectMapper]
 *
 * @author timo gruen - 2021-04-07
 */
fun preconfiguredJackson(): ObjectMapper {
    val jackson = jacksonObjectMapper()
    jackson.enable(SerializationFeature.INDENT_OUTPUT);
    return jackson
}
