package io.datalbry.config.processor.kotlin.mapper

import com.google.devtools.ksp.symbol.KSAnnotated
import com.google.devtools.ksp.symbol.KSAnnotation
import com.google.devtools.ksp.symbol.KSValueArgument
import io.datalbry.config.api.annotation.PropertyDescription as PropertyAnnotation
import io.datalbry.config.api.PropertyDescription
import io.datalbry.config.api.annotation.PropertyDescription.Companion.EXAMPLE_DEFAULT
import io.datalbry.config.api.annotation.PropertyDescription.Companion.MULTI_DEFAULT
import io.datalbry.config.api.annotation.PropertyDescription.Companion.REQUIRED_DEFAULT
import io.datalbry.config.processor.kotlin.extension.get

/**
 * Simple [KSAnnotated] to [Set] of [PropertyDescription] mapper implementation
 *
 * @see KSAnnotated for details
 * @see PropertyDescription for details about properties
 *
 * @author timo gruen - 2021-04-7
 */
@Suppress("UNCHECKED_CAST")
class KSAnnotationToPropertyDescriptorMapper: Mapper<KSAnnotated, Set<PropertyDescription>> {

    override fun map(model: KSAnnotated): Set<PropertyDescription> {
        val arguments = model.annotations.filter { isPropertyDescription(it) }.map { it.arguments }
        return arguments.map {
            PropertyDescription(
                it["key"].value as String,
                it["group"].value as String,
                it["type"].value as String,
                it["required"].value as Boolean? ?: REQUIRED_DEFAULT,
                it["multi"].value as Boolean? ?: MULTI_DEFAULT,
                it["description"].value as String,
                it["label"].value as String,
                ((it["example"].value as Collection<String>?) ?: EXAMPLE_DEFAULT).toSet()
            )
        }.toSet()
    }

    private fun isPropertyDescription(it: KSAnnotation) =
        it.annotationType.resolve().declaration.qualifiedName?.asString() ==
                PropertyAnnotation::class.java.canonicalName

}
