package io.datalbry.config.processor.kotlin

import com.google.devtools.ksp.processing.SymbolProcessor
import com.google.devtools.ksp.processing.SymbolProcessorEnvironment
import com.google.devtools.ksp.processing.SymbolProcessorProvider

/**
 * [ConfigSchemaProcessorProvider] is a concrete [SymbolProcessorProvider] providing access to
 * the [ConfigSchemaProcessor]
 *
 * @author timo gruen - 2021-10-03
 */
class ConfigSchemaProcessorProvider: SymbolProcessorProvider {

    override fun create(environment: SymbolProcessorEnvironment): SymbolProcessor {
        return ConfigSchemaProcessor(
            logger = environment.logger,
            codeGenerator = environment.codeGenerator,
            options = environment.options
        )
    }
}
