package io.datalbry.config.processor.kotlin.extension

import com.google.devtools.ksp.symbol.KSValueArgument

/**
 * Short circuit to access a specific Argument in a [KSValueArgument] [Collection]
 *
 * @return the [KSValueArgument] matching the key
 *
 * @author timo gruen - 2021-04-07
 */
operator fun Collection<KSValueArgument>.get(key: String): KSValueArgument {
    return this.first { it.name?.asString() == key }
}

