/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.stats;

import io.deephaven.base.Function;
import io.deephaven.base.stats.Counter;
import io.deephaven.base.stats.State;
import io.deephaven.base.stats.Stats;
import io.deephaven.configuration.Configuration;
import io.deephaven.hash.KeyedLongObjectHash;
import io.deephaven.hash.KeyedLongObjectHashMap;
import io.deephaven.hash.KeyedLongObjectKey;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.util.OSUtil;
import java.io.File;
import java.io.FileInputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;

public class StatsCPUCollector {
    private static final Logger log = LoggerFactory.getLogger(StatsCPUCollector.class);
    public static final boolean MEASURE_PER_THREAD_CPU = Configuration.getInstance().getBoolean("measurement.per_thread_cpu");
    private static final long NANOS = 1000000000L;
    private static final long MILLIS = 1000L;
    private final long divisor;
    boolean hasProcStat = true;
    boolean hasProcPidStat = true;
    boolean hasProcFd = true;
    private Counter statSysUserJiffies = null;
    private Counter statSysSystemJiffies = null;
    private Counter statSysIOWait = null;
    private Counter statSysPageIn = null;
    private Counter statSysPageOut = null;
    private Counter statSysSwapIn = null;
    private Counter statSysSwapOut = null;
    private Counter statSysInterrupts = null;
    private Counter statSysCtxt = null;
    private Counter statProcMinorFaults = null;
    private Counter statProcMajorFaults = null;
    private Counter statProcUserJiffies = null;
    private Counter statProcSystemJiffies = null;
    private State statProcVSZ = null;
    private State statProcRSS = null;
    private State statProcNumFDs = null;
    private State statProcMaxFD = null;
    private byte[] statBuffer = null;
    private final long interval;
    private final boolean getFdStats;
    private static KeyedLongObjectHashMap<ThreadState> threadStates = new KeyedLongObjectHashMap(100, ThreadState.keyDef);
    private State processUserTime;
    private State processSystemTime;
    int statBufferIndex;
    FileInputStream statFile;
    FileInputStream procFile;

    StatsCPUCollector(long interval, boolean getFdStats) {
        this.interval = interval;
        this.getFdStats = getFdStats;
        long seconds = interval / 1000L;
        this.divisor = 1000000000L / (seconds * 10L);
        Stats.makeGroup((String)"Kernel", (String)"Unix kernel statistics, as read from /proc/stat");
        Stats.makeGroup((String)"Proc", (String)"Unix process statistics, as read from /proc/self/stat and /proc/self/fd");
        Stats.makeGroup((String)"CPU", (String)"JMX CPU usage data, per-thread and for the entire process");
        if (OSUtil.runningMacOS() || OSUtil.runningWindows()) {
            this.hasProcStat = false;
            this.hasProcPidStat = false;
            this.hasProcFd = false;
        }
    }

    private boolean startsWith(String match, int nb) {
        for (int i = 0; i < match.length(); ++i) {
            if (i + this.statBufferIndex >= nb || this.statBuffer[i + this.statBufferIndex] == match.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private boolean skipWhiteSpace(int nb) {
        while (this.statBuffer[this.statBufferIndex] == 32) {
            if (this.statBufferIndex >= nb || this.statBuffer[this.statBufferIndex] == 10) {
                return false;
            }
            ++this.statBufferIndex;
        }
        return this.statBufferIndex < nb;
    }

    private boolean skipNextField(int nb) {
        while (this.statBuffer[this.statBufferIndex] != 32) {
            if (this.statBufferIndex >= nb || this.statBuffer[this.statBufferIndex] == 10) {
                return false;
            }
            ++this.statBufferIndex;
        }
        return this.skipWhiteSpace(nb);
    }

    private boolean getNextFieldSampleKilobytes(State v, int nb) {
        v.sample(this.getNextFieldLong(nb) / 1024L);
        return this.skipWhiteSpace(nb);
    }

    private boolean getNextFieldDeltaJiffies(Counter v, int nb) {
        v.incrementFromSample(this.getNextFieldLong(nb) * 10000L / this.interval);
        return this.skipWhiteSpace(nb);
    }

    private boolean getNextFieldDelta(Counter v, int nb) {
        v.incrementFromSample(this.getNextFieldLong(nb));
        return this.skipWhiteSpace(nb);
    }

    private boolean getNextFieldSample(State v, int nb) {
        v.sample(this.getNextFieldLong(nb));
        return this.skipWhiteSpace(nb);
    }

    private long getNextFieldLong(int nb) {
        long result = 0L;
        while (this.statBufferIndex < nb && this.statBuffer[this.statBufferIndex] >= 48 && this.statBuffer[this.statBufferIndex] <= 57) {
            result *= 10L;
            result += (long)(this.statBuffer[this.statBufferIndex] - 48);
            ++this.statBufferIndex;
        }
        return result;
    }

    private boolean peekNextLong(int nb) {
        return this.statBufferIndex < nb && this.statBuffer[this.statBufferIndex] >= 48 && this.statBuffer[this.statBufferIndex] <= 57;
    }

    private void updateSys() {
        if (this.hasProcStat) {
            try {
                if (this.statFile == null) {
                    this.statFile = new FileInputStream("/proc/stat");
                }
                int nb = this.statFile.read(this.statBuffer, 0, this.statBuffer.length);
                this.statFile.getChannel().position(0L);
                this.statBufferIndex = 0;
                while (this.statBufferIndex < nb) {
                    while (this.statBufferIndex < nb && this.statBuffer[this.statBufferIndex] < 33) {
                        ++this.statBufferIndex;
                    }
                    if (this.startsWith("cpu ", nb)) {
                        if (this.skipNextField(nb) && this.peekNextLong(nb)) {
                            if (this.statSysUserJiffies == null) {
                                this.statSysUserJiffies = (Counter)Stats.makeItem((String)"Kernel", (String)"UserJiffies", (Function.Unary)Counter.FACTORY, (String)"User jiffies per 10 second interval (1000 equals 1 full CPU)").getValue();
                                this.statSysSystemJiffies = (Counter)Stats.makeItem((String)"Kernel", (String)"SystemJiffies", (Function.Unary)Counter.FACTORY, (String)"System jiffies per 10 second interval (1000 equals 1 full CPU)").getValue();
                            }
                            if (this.getNextFieldDeltaJiffies(this.statSysUserJiffies, nb) && this.skipNextField(nb) && this.peekNextLong(nb) && this.getNextFieldDeltaJiffies(this.statSysSystemJiffies, nb) && this.skipNextField(nb) && this.skipNextField(nb) && this.peekNextLong(nb)) {
                                if (this.statSysIOWait == null) {
                                    this.statSysIOWait = (Counter)Stats.makeItem((String)"Kernel", (String)"IOWait", (Function.Unary)Counter.FACTORY, (String)"IOWait jiffies per 10 second interval (1000 equals 1 full CPU)").getValue();
                                }
                                this.getNextFieldDeltaJiffies(this.statSysIOWait, nb);
                            }
                        }
                    } else if (this.startsWith("page", nb)) {
                        if (this.skipNextField(nb) && this.peekNextLong(nb)) {
                            if (this.statSysPageIn == null) {
                                this.statSysPageIn = (Counter)Stats.makeItem((String)"Kernel", (String)"PageIn", (Function.Unary)Counter.FACTORY, (String)"Number of pages read in from disk").getValue();
                                this.statSysPageOut = (Counter)Stats.makeItem((String)"Kernel", (String)"PageOut", (Function.Unary)Counter.FACTORY, (String)"Number of pages written to disk").getValue();
                            }
                            if (this.getNextFieldDelta(this.statSysPageIn, nb) && this.peekNextLong(nb)) {
                                this.getNextFieldDelta(this.statSysPageOut, nb);
                            }
                        }
                    } else if (this.startsWith("swap", nb)) {
                        if (this.statSysSwapIn == null) {
                            this.statSysSwapIn = (Counter)Stats.makeItem((String)"Kernel", (String)"SwapIn", (Function.Unary)Counter.FACTORY, (String)"Number of pages read from swap space").getValue();
                            this.statSysSwapOut = (Counter)Stats.makeItem((String)"Kernel", (String)"SwapOut", (Function.Unary)Counter.FACTORY, (String)"Number of pages written to swap space").getValue();
                        }
                        if (this.skipNextField(nb) && this.getNextFieldDelta(this.statSysSwapIn, nb) && this.peekNextLong(nb)) {
                            this.getNextFieldDelta(this.statSysSwapOut, nb);
                        }
                    } else if (this.startsWith("intr", nb)) {
                        if (this.statSysInterrupts == null) {
                            this.statSysInterrupts = (Counter)Stats.makeItem((String)"Kernel", (String)"Interrupts", (Function.Unary)Counter.FACTORY, (String)"Number of interrupts").getValue();
                        }
                        if (this.skipNextField(nb)) {
                            this.getNextFieldDelta(this.statSysInterrupts, nb);
                        }
                    } else if (this.startsWith("ctxt", nb)) {
                        if (this.statSysCtxt == null) {
                            this.statSysCtxt = (Counter)Stats.makeItem((String)"Kernel", (String)"Ctxt", (Function.Unary)Counter.FACTORY, (String)"Number of context switches").getValue();
                        }
                        if (this.skipNextField(nb)) {
                            this.getNextFieldDelta(this.statSysCtxt, nb);
                        }
                    }
                    while (this.statBufferIndex < nb && this.statBuffer[this.statBufferIndex++] != 10) {
                    }
                }
            }
            catch (Exception x) {
                if (this.hasProcStat) {
                    log.error().append((CharSequence)"got an exception reading /proc/stat: ").append((Throwable)x).endl();
                }
                this.hasProcStat = false;
            }
        }
    }

    private void updateProc() {
        if (this.hasProcPidStat) {
            try {
                int i;
                if (this.procFile == null) {
                    this.procFile = new FileInputStream("/proc/self/stat");
                }
                this.procFile.getChannel().position(0L);
                if (this.statProcMinorFaults == null) {
                    this.statProcMinorFaults = (Counter)Stats.makeItem((String)"Proc", (String)"MinorFaults", (Function.Unary)Counter.FACTORY, (String)"Minor faults the process has incurred").getValue();
                    this.statProcMajorFaults = (Counter)Stats.makeItem((String)"Proc", (String)"MajorFaults", (Function.Unary)Counter.FACTORY, (String)"Major faults the process has incurred").getValue();
                    this.statProcUserJiffies = (Counter)Stats.makeItem((String)"Proc", (String)"UserJiffies", (Function.Unary)Counter.FACTORY, (String)"User jiffies per 10 second interval (1000 equals 1 full CPU)").getValue();
                    this.statProcSystemJiffies = (Counter)Stats.makeItem((String)"Proc", (String)"SystemJiffies", (Function.Unary)Counter.FACTORY, (String)"System jiffies per 10 second interval (1000 equals 1 full CPU)").getValue();
                    this.statProcVSZ = (State)Stats.makeItem((String)"Proc", (String)"VSZ", (Function.Unary)State.FACTORY, (String)"Virtual size of the process in kilobytes").getValue();
                    this.statProcRSS = (State)Stats.makeItem((String)"Proc", (String)"RSS", (Function.Unary)State.FACTORY, (String)"Resident set size of the process in pages").getValue();
                }
                this.statBufferIndex = 0;
                int nb = this.procFile.read(this.statBuffer, 0, this.statBuffer.length);
                for (i = 0; i < 9; ++i) {
                    this.skipNextField(nb);
                }
                this.getNextFieldDelta(this.statProcMinorFaults, nb);
                this.skipNextField(nb);
                this.getNextFieldDelta(this.statProcMajorFaults, nb);
                this.skipNextField(nb);
                this.getNextFieldDeltaJiffies(this.statProcUserJiffies, nb);
                this.getNextFieldDeltaJiffies(this.statProcSystemJiffies, nb);
                for (i = 15; i < 22; ++i) {
                    this.skipNextField(nb);
                }
                this.getNextFieldSampleKilobytes(this.statProcVSZ, nb);
                this.getNextFieldSample(this.statProcRSS, nb);
            }
            catch (Exception x) {
                this.hasProcPidStat = false;
            }
        }
    }

    private void updateProcFD() {
        if (this.hasProcFd) {
            try {
                File procFd = new File("/proc/self/fd");
                String[] entries = procFd.list();
                if (entries == null) {
                    this.hasProcFd = false;
                    return;
                }
                if (this.statProcNumFDs == null) {
                    this.statProcNumFDs = (State)Stats.makeItem((String)"Proc", (String)"NumFDs", (Function.Unary)State.FACTORY, (String)"Number of open file descriptors in the process").getValue();
                    this.statProcMaxFD = (State)Stats.makeItem((String)"Proc", (String)"MaxFD", (Function.Unary)State.FACTORY, (String)"Highest-numbered file descriptors in the process").getValue();
                }
                int maxFd = -1;
                for (String s : entries) {
                    try {
                        int fd = Integer.parseInt(s);
                        maxFd = Math.max(fd, maxFd);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.statProcNumFDs.sample((long)entries.length);
                this.statProcMaxFD.sample((long)maxFd);
            }
            catch (Exception x) {
                this.hasProcFd = false;
            }
        }
    }

    private void updatePerThreadCPU() {
        if (MEASURE_PER_THREAD_CPU) {
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            long[] threadIds = threadMXBean.getAllThreadIds();
            ThreadInfo[] threadInfos = threadMXBean.getThreadInfo(threadIds);
            long deltaProcessCpuTime = 0L;
            long deltaProcessUserTime = 0L;
            for (ThreadInfo tinfo : threadInfos) {
                if (tinfo == null) continue;
                ThreadState state = (ThreadState)threadStates.putIfAbsent(tinfo.getThreadId(), ThreadState.factory);
                long cpuTime = threadMXBean.getThreadCpuTime(state.id);
                long userTime = threadMXBean.getThreadUserTime(state.id);
                if (state.name == null) {
                    state.name = tinfo.getThreadName();
                    state.userTime = (State)Stats.makeItem((String)"CPU", (String)(state.name + "-userTime"), (Function.Unary)State.FACTORY, (String)"Per-thread CPU usage in user mode, 1000 equals 1 full CPU, as reported by Java").getValue();
                    state.systemTime = (State)Stats.makeItem((String)"CPU", (String)(state.name + "-systemTime"), (Function.Unary)State.FACTORY, (String)"Per-thread CPU usage in system mode, 1000 equals 1 full CPU, as reported by Java").getValue();
                } else {
                    long deltaCpuTime = cpuTime - state.lastCpuTime;
                    long deltaUserTime = userTime - state.lastUserTime;
                    deltaProcessCpuTime += deltaCpuTime;
                    deltaProcessUserTime += deltaUserTime;
                    if (deltaUserTime / this.divisor != 0L) {
                        state.userTime.sample(deltaUserTime / this.divisor);
                    }
                    if ((deltaCpuTime - deltaUserTime) / this.divisor != 0L) {
                        state.systemTime.sample((deltaCpuTime - deltaUserTime) / this.divisor);
                    }
                }
                state.lastCpuTime = cpuTime;
                state.lastUserTime = userTime;
            }
            if (this.processUserTime == null) {
                this.processUserTime = (State)Stats.makeItem((String)"CPU", (String)"process-userTime", (Function.Unary)State.FACTORY, (String)"Process CPU usage in user mode, 1000 equals 1 full CPU, as reported by JMX").getValue();
                this.processSystemTime = (State)Stats.makeItem((String)"CPU", (String)"process-systemTime", (Function.Unary)State.FACTORY, (String)"Process CPU usage in system mode, 1000 equals 1 full CPU, as reported by JMX").getValue();
            }
            this.processUserTime.sample(deltaProcessUserTime / this.divisor);
            this.processSystemTime.sample((deltaProcessCpuTime - deltaProcessUserTime) / this.divisor);
        }
    }

    public void update() {
        if (this.statBuffer == null) {
            this.statBuffer = new byte[4096];
        }
        this.updateSys();
        this.updateProc();
        if (this.getFdStats) {
            this.updateProcFD();
        }
        this.updatePerThreadCPU();
    }

    private static class ThreadState {
        private final long id;
        private String name;
        private long lastCpuTime;
        private long lastUserTime;
        private State userTime;
        private State systemTime;
        public static KeyedLongObjectKey<ThreadState> keyDef = new KeyedLongObjectKey<ThreadState>(){

            public Long getKey(ThreadState v) {
                return v.id;
            }

            public long getLongKey(ThreadState v) {
                return v.id;
            }

            public int hashKey(Long k) {
                return (int)k.longValue();
            }

            public int hashLongKey(long k) {
                return (int)k;
            }

            public boolean equalKey(Long k, ThreadState v) {
                return k == v.id;
            }

            public boolean equalLongKey(long k, ThreadState v) {
                return k == v.id;
            }
        };
        public static KeyedLongObjectHash.ValueFactory<ThreadState> factory = new KeyedLongObjectHash.ValueFactory<ThreadState>(){

            public ThreadState newValue(long key) {
                return new ThreadState(key);
            }

            public ThreadState newValue(Long key) {
                return new ThreadState(key);
            }
        };

        public ThreadState(long id) {
            this.id = id;
        }
    }
}

