/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.stats;

import io.deephaven.base.Function;
import io.deephaven.base.clock.Clock;
import io.deephaven.base.pool.Pool;
import io.deephaven.base.stats.HistogramPower2;
import io.deephaven.base.stats.History;
import io.deephaven.base.stats.Item;
import io.deephaven.base.stats.ItemUpdateListener;
import io.deephaven.base.stats.State;
import io.deephaven.base.stats.Stats;
import io.deephaven.base.stats.Value;
import io.deephaven.base.text.TimestampBuffer;
import io.deephaven.configuration.Configuration;
import io.deephaven.io.log.LogBufferPool;
import io.deephaven.io.log.LogEntry;
import io.deephaven.io.log.LogEntryPool;
import io.deephaven.io.log.LogLevel;
import io.deephaven.io.log.LogSink;
import io.deephaven.io.log.impl.LogBufferPoolImpl;
import io.deephaven.io.log.impl.LogEntryPoolImpl;
import io.deephaven.io.log.impl.LogSinkImpl;
import io.deephaven.io.sched.Job;
import io.deephaven.io.sched.TimedJob;
import io.deephaven.net.CommBase;
import io.deephaven.stats.ObjectAllocationCollector;
import io.deephaven.stats.StatsCPUCollector;
import io.deephaven.stats.StatsIntradayLogger;
import io.deephaven.stats.StatsMemoryCollector;
import io.deephaven.util.formatters.ISO8601;
import java.util.Properties;

public class StatsDriver
extends TimedJob {
    private final LogEntryPool entryPool;
    private final LogSink sink;
    private final LogEntry[] entries;
    private final LogEntryPool entryPoolHisto;
    private final LogSink sinkHisto;
    private final LogEntry[] entriesHisto;
    private final TimestampBuffer systemTimestamp;
    private final TimestampBuffer appTimestamp;
    public static final String header = "Stat,IntervalName,NowSec,NowString,AppNowSec,AppNowString,TypeTag,Name,N,Sum,Last,Min,Max,Avg,Sum2,Stdev";
    private long nextInvocation = System.currentTimeMillis();
    private long nextCpuUpdate = this.nextInvocation + 1000L;
    private long nextMemUpdate = this.nextInvocation + 1000L;
    private static final long STEP = 1000L;
    private static final long MEM_INTERVAL = 1000L;
    private static final long CPU_INTERVAL = 1000L;
    private static final long REPORT_INTERVAL = 10000L;
    private static final int BUFFER_SIZE = 8192;
    private static final int GUESS_ENTRY_SIZE = 256;
    private final Value statsTiming = Stats.makeItem((String)"Stats", (String)"updateDuration", (Function.Unary)State.FACTORY, (String)"Microseconds required to update the statistics histories each second").getValue();
    private final Clock clock;
    private final StatsIntradayLogger intraday;
    private final Value clockValue;
    private final StatsMemoryCollector memStats;
    private final StatsCPUCollector cpuStats;
    private ObjectAllocationCollector objectAllocation;
    private final ItemUpdateListener LISTENER = new ItemUpdateListener(){

        public void handleItemUpdated(Item item, long now, long appNow, int intervalIndex, long intervalMillis, String intervalName) {
            Value v = item.getValue();
            History history = v.getHistory();
            char typeTag = v.getTypeTag();
            switch (typeTag) {
                case 'N': {
                    if (StatsDriver.this.entriesHisto == null && StatsDriver.this.intraday == StatsIntradayLogger.NULL) {
                        return;
                    }
                    long n = history.getN(intervalIndex, 1);
                    long sum = history.getSum(intervalIndex, 1);
                    long last = history.getLast(intervalIndex, 1);
                    long min = history.getMin(intervalIndex, 1);
                    long max = history.getMax(intervalIndex, 1);
                    long avg = history.getAvg(intervalIndex, 1);
                    long sum2 = history.getSum2(intervalIndex, 1);
                    long stdev = history.getStdev(intervalIndex, 1);
                    HistogramPower2 nh = (HistogramPower2)v;
                    if (StatsDriver.this.entriesHisto != null) {
                        LogEntry e = StatsDriver.this.entriesHisto[intervalIndex];
                        if (e.size() > 7936) {
                            e.end();
                            e = StatsDriver.this.entriesHisto[intervalIndex] = ((LogEntry)StatsDriver.this.entryPoolHisto.take()).start(StatsDriver.this.sinkHisto, LogLevel.INFO, now * 1000L);
                        }
                        e.append((CharSequence)"HISTOGRAM").append(',').append((CharSequence)intervalName).append(',').append(now / 1000L).append(',').appendTimestamp(now, StatsDriver.this.systemTimestamp).append(',').append(appNow / 1000L).append(',').appendTimestamp(appNow, StatsDriver.this.appTimestamp).append(',').append(v.getTypeTag()).append(',').append((CharSequence)item.getGroupName()).append('.').append((CharSequence)item.getName()).append(',').append(n).append(',').append(sum).append(',').append(last).append(',').append(min).append(',').append(max).append(',').append(avg).append(',').append(sum2).append(',').append(stdev).append(',').append((CharSequence)nh.getHistogramString()).nl();
                    }
                    StatsDriver.this.intraday.log(intervalName, now, appNow, v.getTypeTag(), item.getCompactName(), n, sum, last, min, max, avg, sum2, stdev, nh.getHistogram());
                    break;
                }
                default: {
                    if (StatsDriver.this.entries == null && StatsDriver.this.intraday == StatsIntradayLogger.NULL) {
                        return;
                    }
                    long n = history.getN(intervalIndex, 1);
                    long sum = history.getSum(intervalIndex, 1);
                    long last = history.getLast(intervalIndex, 1);
                    long min = history.getMin(intervalIndex, 1);
                    long max = history.getMax(intervalIndex, 1);
                    long avg = history.getAvg(intervalIndex, 1);
                    long sum2 = history.getSum2(intervalIndex, 1);
                    long stdev = history.getStdev(intervalIndex, 1);
                    if (StatsDriver.this.entries != null) {
                        LogEntry e = StatsDriver.this.entries[intervalIndex];
                        if (e.size() > 7936) {
                            e.end();
                            e = StatsDriver.this.entries[intervalIndex] = ((LogEntry)StatsDriver.this.entryPool.take()).start(StatsDriver.this.sink, LogLevel.INFO, now * 1000L);
                        }
                        e.append((CharSequence)"STAT").append(',').append((CharSequence)intervalName).append(',').append(now / 1000L).append(',').appendTimestamp(now, StatsDriver.this.systemTimestamp).append(',').append(appNow / 1000L).append(',').appendTimestamp(appNow, StatsDriver.this.appTimestamp).append(',').append(v.getTypeTag()).append(',').append((CharSequence)item.getGroupName()).append('.').append((CharSequence)item.getName()).append(',').append(n).append(',').append(sum).append(',').append(last).append(',').append(min).append(',').append(max).append(',').append(avg).append(',').append(sum2).append(',').append(stdev).nl();
                    }
                    StatsDriver.this.intraday.log(intervalName, now, appNow, v.getTypeTag(), item.getCompactName(), n, sum, last, min, max, avg, sum2, stdev);
                    break;
                }
            }
        }
    };

    public StatsDriver(Clock clock) {
        this(clock, true, StatusAdapter.NULL);
    }

    public StatsDriver(Clock clock, StatusAdapter statusAdapter) {
        this(clock, true, statusAdapter);
    }

    public StatsDriver(Clock clock, boolean getFdStats, StatusAdapter statusAdapter) {
        this(clock, StatsIntradayLogger.NULL, getFdStats, statusAdapter);
    }

    public StatsDriver(Clock clock, boolean getFdStats) {
        this(clock, StatsIntradayLogger.NULL, getFdStats, StatusAdapter.NULL);
    }

    public StatsDriver(Clock clock, StatsIntradayLogger intraday, boolean getFdStats) {
        this(clock, intraday, getFdStats, StatusAdapter.NULL);
    }

    public StatsDriver(Clock clock, StatsIntradayLogger intraday, boolean getFdStats, StatusAdapter statusAdapter) {
        LogBufferPoolImpl bufferPool;
        Object histoPath;
        Properties props = Configuration.getInstance().getProperties();
        Object path = props.getProperty("stats.log.prefix");
        if (path != null) {
            path = ((String)path).isEmpty() ? null : (String)path + ".stats";
        }
        if ((histoPath = props.getProperty("histo.log.prefix")) != null) {
            histoPath = ((String)histoPath).isEmpty() ? null : (String)histoPath + ".histo";
        }
        this.systemTimestamp = new TimestampBuffer(ISO8601.serverTimeZone());
        this.appTimestamp = new TimestampBuffer(ISO8601.serverTimeZone());
        if (path == null) {
            this.entryPool = null;
            this.sink = null;
            this.entries = null;
        } else {
            bufferPool = new LogBufferPoolImpl(History.INTERVALS.length * 20, 8192);
            this.entryPool = new LogEntryPoolImpl(History.INTERVALS.length * 20, (LogBufferPool)bufferPool);
            this.sink = new LogSinkImpl((String)path, 3600000L, (Pool)this.entryPool, true);
            this.entries = new LogEntry[History.INTERVALS.length];
        }
        if (histoPath == null) {
            this.entryPoolHisto = null;
            this.sinkHisto = null;
            this.entriesHisto = null;
        } else {
            bufferPool = new LogBufferPoolImpl(History.INTERVALS.length * 20, 8192);
            this.entryPoolHisto = new LogEntryPoolImpl(History.INTERVALS.length * 20, (LogBufferPool)bufferPool);
            this.sinkHisto = new LogSinkImpl((String)histoPath, 3600000L, (Pool)this.entryPoolHisto, true);
            this.entriesHisto = new LogEntry[History.INTERVALS.length];
        }
        this.clock = clock;
        this.intraday = intraday;
        this.clockValue = this.clock != null ? Stats.makeItem((String)"Clock", (String)"value", (Function.Unary)State.FACTORY, (String)"The value of the Clock, useful for mapping data from simulation runs").getValue() : null;
        long now = System.currentTimeMillis();
        long delay = 1000L - now % 1000L;
        this.nextInvocation = now + delay;
        this.cpuStats = new StatsCPUCollector(1000L, getFdStats);
        this.memStats = new StatsMemoryCollector(1000L, statusAdapter::sendAlert, statusAdapter::cmsAlertEnabled);
        if (Configuration.getInstance().getBoolean("allocation.stats.enabled")) {
            this.objectAllocation = new ObjectAllocationCollector();
        }
        if (Configuration.getInstance().getBoolean("statsdriver.enabled")) {
            this.schedule();
        }
    }

    public void timedOut() {
        long appNow;
        long t0 = System.nanoTime();
        long now = System.currentTimeMillis();
        long l = appNow = this.clock == null ? now : this.clock.currentTimeMillis();
        if (now >= this.nextCpuUpdate) {
            this.nextCpuUpdate += 1000L;
            this.cpuStats.update();
        }
        if (now >= this.nextMemUpdate) {
            this.nextMemUpdate += 1000L;
            this.memStats.update();
        }
        if (this.clock != null) {
            this.clockValue.sample(this.clock.currentTimeMillis());
        }
        if (this.entries == null) {
            Stats.update((ItemUpdateListener)this.LISTENER, (long)now, (long)appNow, (long)10000L);
        } else {
            int i;
            for (i = 0; i < History.INTERVALS.length; ++i) {
                this.entries[i] = ((LogEntry)this.entryPool.take()).start(this.sink, LogLevel.INFO, now * 1000L);
                if (this.entriesHisto == null) continue;
                this.entriesHisto[i] = ((LogEntry)this.entryPoolHisto.take()).start(this.sinkHisto, LogLevel.INFO, now * 1000L);
            }
            Stats.update((ItemUpdateListener)this.LISTENER, (long)now, (long)appNow, (long)10000L);
            for (i = 0; i < History.INTERVALS.length; ++i) {
                this.entries[i].end();
                if (this.entriesHisto == null) continue;
                this.entriesHisto[i].end();
            }
        }
        this.schedule();
        this.statsTiming.sample((System.nanoTime() - t0 + 500L) / 1000L);
    }

    private void schedule() {
        CommBase.getScheduler().installJob((Job)this, this.nextInvocation);
        long steps = Math.max(1L, (System.currentTimeMillis() - this.nextInvocation) / 1000L + 1L);
        this.nextInvocation += steps * 1000L;
    }

    public static interface StatusAdapter {
        public static final StatusAdapter NULL = new Null();

        public void sendAlert(String var1);

        public boolean cmsAlertEnabled();

        public static class Null
        implements StatusAdapter {
            @Override
            public void sendAlert(String unused) {
            }

            @Override
            public boolean cmsAlertEnabled() {
                return true;
            }
        }
    }
}

