/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.stats;

import io.deephaven.base.Function;
import io.deephaven.base.stats.Counter;
import io.deephaven.base.stats.State;
import io.deephaven.base.stats.Stats;
import io.deephaven.base.stats.Value;
import io.deephaven.hash.KeyedObjectHash;
import io.deephaven.hash.KeyedObjectKey;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;

public class StatsMemoryCollector {
    private static final long NANOS = 1000000000L;
    private static final long MICROS = 1000000L;
    private static final long MILLIS = 1000L;
    private final MemoryMXBean memoryBean;
    private final Consumer<String> alertFunction;
    private final BooleanSupplier cmsAlertEnabled;
    private static final long statsStartupTime = System.currentTimeMillis();
    private final KeyedObjectHash<String, PoolState> pools = new KeyedObjectHash(PoolState.keyDef);
    private final KeyedObjectHash<String, CollectorState> collectors = new KeyedObjectHash(CollectorState.keyDef);
    private final long seconds;
    private final Value heapUsed;
    private final Value heapCommitted;
    private final Value heapMax;
    private final Value nonHeapUsed;
    private final Value nonHeapCommitted;
    private final Value nonHeapMax;

    private static long getStatsUptime() {
        return System.currentTimeMillis() - statsStartupTime;
    }

    StatsMemoryCollector(long interval, Consumer<String> alertFunction, BooleanSupplier cmsAlertEnabled) {
        this.alertFunction = alertFunction;
        this.cmsAlertEnabled = cmsAlertEnabled;
        this.seconds = interval / 1000L;
        this.memoryBean = ManagementFactory.getMemoryMXBean();
        this.heapUsed = Stats.makeItem((String)"Memory-Heap", (String)"Used", (Function.Unary)State.FACTORY).getValue();
        this.heapCommitted = Stats.makeItem((String)"Memory-Heap", (String)"Committed", (Function.Unary)State.FACTORY).getValue();
        this.heapMax = Stats.makeItem((String)"Memory-Heap", (String)"Max", (Function.Unary)State.FACTORY).getValue();
        this.nonHeapUsed = Stats.makeItem((String)"Memory-NonHeap", (String)"Used", (Function.Unary)State.FACTORY).getValue();
        this.nonHeapCommitted = Stats.makeItem((String)"Memory-NonHeap", (String)"Committed", (Function.Unary)State.FACTORY).getValue();
        this.nonHeapMax = Stats.makeItem((String)"Memory-NonHeap", (String)"Max", (Function.Unary)State.FACTORY).getValue();
    }

    public void update() {
        MemoryUsage heap = this.memoryBean.getHeapMemoryUsage();
        MemoryUsage nonHeap = this.memoryBean.getNonHeapMemoryUsage();
        this.heapUsed.sample(heap.getUsed());
        this.heapCommitted.sample(heap.getCommitted());
        this.heapMax.sample(heap.getMax());
        this.nonHeapUsed.sample(nonHeap.getUsed());
        this.nonHeapCommitted.sample(nonHeap.getCommitted());
        this.nonHeapMax.sample(nonHeap.getMax());
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            PoolState pool = (PoolState)this.pools.get((Object)memoryPoolMXBean.getName());
            if (pool == null) {
                pool = new PoolState(this.seconds, memoryPoolMXBean);
                this.pools.add((Object)pool);
            }
            pool.update();
        }
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            CollectorState collector = (CollectorState)this.collectors.get((Object)garbageCollectorMXBean.getName());
            if (collector == null) {
                collector = new CollectorState(this.seconds, garbageCollectorMXBean, this.alertFunction, this.cmsAlertEnabled);
                this.collectors.add((Object)collector);
            }
            collector.update();
        }
    }

    private static class CollectorState {
        private final long seconds;
        private final GarbageCollectorMXBean bean;
        private final Consumer<String> alertFunction;
        private BooleanSupplier enableCmsAlerts;
        private final Value count;
        private final Value time;
        private long lastCount = -1L;
        private long lastTime = -1L;
        private long lastCMSOccurrence = 0L;
        private long lastCMSOccurrenceMailSent = 0L;
        public static KeyedObjectKey<String, CollectorState> keyDef = new KeyedObjectKey<String, CollectorState>(){

            public String getKey(CollectorState v) {
                return v.bean.getName();
            }

            public int hashKey(String k) {
                return k.hashCode();
            }

            public boolean equalKey(String k, CollectorState v) {
                return k.equals(v.bean.getName());
            }
        };

        public CollectorState(long seconds, GarbageCollectorMXBean bean, Consumer<String> alertFunction, BooleanSupplier enableCmsAlerts) {
            this.seconds = seconds;
            this.bean = bean;
            this.alertFunction = alertFunction;
            this.enableCmsAlerts = enableCmsAlerts;
            this.count = Stats.makeItem((String)"Memory-GC", (String)(bean.getName() + "-Count"), (Function.Unary)Counter.FACTORY).getValue();
            this.time = Stats.makeItem((String)"Memory-GC", (String)(bean.getName() + "-Time"), (Function.Unary)Counter.FACTORY).getValue();
        }

        public void update() {
            long c = this.bean.getCollectionCount();
            long t = this.bean.getCollectionTime();
            if (this.lastCount != -1L) {
                this.count.sample(c - this.lastCount);
                long timeSample = (t - this.lastTime) / this.seconds;
                this.time.sample(timeSample);
                if ("ConcurrentMarkSweep".equals(this.bean.getName()) && c - this.lastCount > 0L && StatsMemoryCollector.getStatsUptime() > 600000L) {
                    long now = System.currentTimeMillis();
                    if (now - this.lastCMSOccurrence < 30000L && now - this.lastCMSOccurrenceMailSent > 3600000L) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
                        String message = "Last CMS collection at " + dateFormat.format(new Date(this.lastCMSOccurrence));
                        if (this.alertFunction != null) {
                            this.alertFunction.accept("Rapid CMS detected, " + message);
                        }
                        this.lastCMSOccurrenceMailSent = now;
                    }
                    this.lastCMSOccurrence = now;
                }
            }
            this.lastCount = c;
            this.lastTime = t;
        }
    }

    private static class PoolState {
        private final long seconds;
        private final MemoryPoolMXBean bean;
        private final Value used;
        private final Value committed;
        private final Value max;
        public static KeyedObjectKey<String, PoolState> keyDef = new KeyedObjectKey<String, PoolState>(){

            public String getKey(PoolState v) {
                return v.bean.getName();
            }

            public int hashKey(String k) {
                return k.hashCode();
            }

            public boolean equalKey(String k, PoolState v) {
                return k.equals(v.bean.getName());
            }
        };

        public PoolState(long seconds, MemoryPoolMXBean bean) {
            this.seconds = seconds;
            this.bean = bean;
            this.used = Stats.makeItem((String)"Memory-Pool", (String)(bean.getName() + "-Used"), (Function.Unary)State.FACTORY).getValue();
            this.committed = Stats.makeItem((String)"Memory-Pool", (String)(bean.getName() + "-Committed"), (Function.Unary)State.FACTORY).getValue();
            this.max = Stats.makeItem((String)"Memory-Pool", (String)(bean.getName() + "-Max"), (Function.Unary)State.FACTORY).getValue();
        }

        public void update() {
            MemoryUsage u = this.bean.getUsage();
            this.used.sample(u.getUsed());
            this.max.sample(u.getMax());
            this.committed.sample(u.getCommitted());
        }
    }
}

