/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.setup;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.JvmAttributeGaugeSet;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.dropwizard.Application;
import io.dropwizard.Bundle;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.cli.Command;
import io.dropwizard.cli.ConfiguredCommand;
import io.dropwizard.configuration.ConfigurationFactoryFactory;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.configuration.DefaultConfigurationFactoryFactory;
import io.dropwizard.configuration.FileConfigurationSourceProvider;
import io.dropwizard.jackson.Jackson;
import io.dropwizard.setup.Environment;
import io.dropwizard.validation.valuehandling.OptionalValidatedValueUnwrapper;
import java.lang.management.ManagementFactory;
import java.util.List;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.spi.valuehandling.ValidatedValueUnwrapper;

public class Bootstrap<T extends Configuration> {
    private final Application<T> application;
    private final ObjectMapper objectMapper;
    private final List<Bundle> bundles;
    private final List<ConfiguredBundle<? super T>> configuredBundles;
    private final List<Command> commands;
    private final MetricRegistry metricRegistry;
    private final ValidatorFactory validatorFactory;
    private ConfigurationSourceProvider configurationSourceProvider;
    private ClassLoader classLoader;
    private ConfigurationFactoryFactory<T> configurationFactoryFactory;

    public Bootstrap(Application<T> application) {
        this.application = application;
        this.objectMapper = Jackson.newObjectMapper();
        this.bundles = Lists.newArrayList();
        this.configuredBundles = Lists.newArrayList();
        this.commands = Lists.newArrayList();
        this.metricRegistry = new MetricRegistry();
        this.validatorFactory = ((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).addValidatedValueHandler((ValidatedValueUnwrapper)new OptionalValidatedValueUnwrapper()).buildValidatorFactory();
        this.getMetricRegistry().register("jvm.attribute", (Metric)new JvmAttributeGaugeSet());
        this.getMetricRegistry().register("jvm.buffers", (Metric)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
        this.getMetricRegistry().register("jvm.classloader", (Metric)new ClassLoadingGaugeSet());
        this.getMetricRegistry().register("jvm.filedescriptor", (Metric)new FileDescriptorRatioGauge());
        this.getMetricRegistry().register("jvm.gc", (Metric)new GarbageCollectorMetricSet());
        this.getMetricRegistry().register("jvm.memory", (Metric)new MemoryUsageGaugeSet());
        this.getMetricRegistry().register("jvm.threads", (Metric)new ThreadStatesGaugeSet());
        JmxReporter.forRegistry((MetricRegistry)this.metricRegistry).build().start();
        this.configurationSourceProvider = new FileConfigurationSourceProvider();
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.configurationFactoryFactory = new DefaultConfigurationFactoryFactory();
    }

    public Application<T> getApplication() {
        return this.application;
    }

    public ConfigurationSourceProvider getConfigurationSourceProvider() {
        return this.configurationSourceProvider;
    }

    public void setConfigurationSourceProvider(ConfigurationSourceProvider provider) {
        this.configurationSourceProvider = (ConfigurationSourceProvider)Preconditions.checkNotNull((Object)provider);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void addBundle(Bundle bundle) {
        bundle.initialize(this);
        this.bundles.add(bundle);
    }

    public void addBundle(ConfiguredBundle<? super T> bundle) {
        bundle.initialize(this);
        this.configuredBundles.add(bundle);
    }

    public void addCommand(Command command) {
        this.commands.add(command);
    }

    public void addCommand(ConfiguredCommand<T> command) {
        this.commands.add(command);
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void run(T configuration, Environment environment) throws Exception {
        for (Bundle bundle : this.bundles) {
            bundle.run(environment);
        }
        for (ConfiguredBundle configuredBundle : this.configuredBundles) {
            configuredBundle.run(configuration, environment);
        }
    }

    public ImmutableList<Command> getCommands() {
        return ImmutableList.copyOf(this.commands);
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public ValidatorFactory getValidatorFactory() {
        return this.validatorFactory;
    }

    public ConfigurationFactoryFactory<T> getConfigurationFactoryFactory() {
        return this.configurationFactoryFactory;
    }

    public void setConfigurationFactoryFactory(ConfigurationFactoryFactory<T> configurationFactoryFactory) {
        this.configurationFactoryFactory = configurationFactoryFactory;
    }
}

