/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.server;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.MoreObjects;
import io.dropwizard.jetty.ConnectorFactory;
import io.dropwizard.jetty.HttpConnectorFactory;
import io.dropwizard.jetty.RoutingHandler;
import io.dropwizard.server.AbstractServerFactory;
import io.dropwizard.setup.Environment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="default")
public class DefaultServerFactory
extends AbstractServerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultServerFactory.class);
    @Valid
    @NotNull
    private List<ConnectorFactory> applicationConnectors = Collections.singletonList(HttpConnectorFactory.application());
    @Valid
    @NotNull
    private List<ConnectorFactory> adminConnectors = Collections.singletonList(HttpConnectorFactory.admin());
    @Min(value=2L)
    private int adminMaxThreads = 64;
    @Min(value=1L)
    private int adminMinThreads = 1;
    @NotEmpty
    private String applicationContextPath = "/";
    @NotEmpty
    private String adminContextPath = "/";

    @JsonProperty
    public List<ConnectorFactory> getApplicationConnectors() {
        return this.applicationConnectors;
    }

    @JsonProperty
    public void setApplicationConnectors(List<ConnectorFactory> connectors) {
        this.applicationConnectors = connectors;
    }

    @JsonProperty
    public List<ConnectorFactory> getAdminConnectors() {
        return this.adminConnectors;
    }

    @JsonProperty
    public void setAdminConnectors(List<ConnectorFactory> connectors) {
        this.adminConnectors = connectors;
    }

    @JsonProperty
    public int getAdminMaxThreads() {
        return this.adminMaxThreads;
    }

    @JsonProperty
    public void setAdminMaxThreads(int adminMaxThreads) {
        this.adminMaxThreads = adminMaxThreads;
    }

    @JsonProperty
    public int getAdminMinThreads() {
        return this.adminMinThreads;
    }

    @JsonProperty
    public void setAdminMinThreads(int adminMinThreads) {
        this.adminMinThreads = adminMinThreads;
    }

    @JsonProperty
    public String getApplicationContextPath() {
        return this.applicationContextPath;
    }

    @JsonProperty
    public void setApplicationContextPath(String applicationContextPath) {
        this.applicationContextPath = applicationContextPath;
    }

    @JsonProperty
    public String getAdminContextPath() {
        return this.adminContextPath;
    }

    @JsonProperty
    public void setAdminContextPath(String adminContextPath) {
        this.adminContextPath = adminContextPath;
    }

    @Override
    public Server build(Environment environment) {
        this.printBanner(environment.getName());
        ThreadPool threadPool = this.createThreadPool(environment.metrics());
        Server server = this.buildServer(environment.lifecycle(), threadPool);
        LOGGER.info("Registering jersey handler with root path prefix: {}", (Object)this.applicationContextPath);
        environment.getApplicationContext().setContextPath(this.applicationContextPath);
        Handler applicationHandler = this.createAppServlet(server, environment.jersey(), environment.getObjectMapper(), environment.getValidator(), environment.getApplicationContext(), environment.getJerseyServletContainer(), environment.metrics());
        LOGGER.info("Registering admin handler with root path prefix: {}", (Object)this.adminContextPath);
        environment.getAdminContext().setContextPath(this.adminContextPath);
        Handler adminHandler = this.createAdminServlet(server, environment.getAdminContext(), environment.metrics(), environment.healthChecks());
        RoutingHandler routingHandler = this.buildRoutingHandler(environment.metrics(), server, applicationHandler, adminHandler);
        Handler gzipHandler = this.buildGzipHandler((Handler)routingHandler);
        server.setHandler(this.addStatsHandler(this.addRequestLog(server, gzipHandler, environment.getName())));
        return server;
    }

    private RoutingHandler buildRoutingHandler(MetricRegistry metricRegistry, Server server, Handler applicationHandler, Handler adminHandler) {
        List<Connector> appConnectors = this.buildAppConnectors(metricRegistry, server);
        List<Connector> adConnectors = this.buildAdminConnectors(metricRegistry, server);
        LinkedHashMap<Connector, Handler> handlers = new LinkedHashMap<Connector, Handler>();
        for (Connector connector : appConnectors) {
            server.addConnector(connector);
            handlers.put(connector, applicationHandler);
        }
        for (Connector connector : adConnectors) {
            server.addConnector(connector);
            handlers.put(connector, adminHandler);
        }
        return new RoutingHandler(handlers);
    }

    private List<Connector> buildAdminConnectors(MetricRegistry metricRegistry, Server server) {
        QueuedThreadPool threadPool = new QueuedThreadPool(this.adminMaxThreads, this.adminMinThreads);
        threadPool.setName("dw-admin");
        server.addBean((Object)threadPool);
        ArrayList<Connector> connectors = new ArrayList<Connector>();
        for (ConnectorFactory factory : this.adminConnectors) {
            Connector connector = factory.build(server, metricRegistry, "admin", (ThreadPool)threadPool);
            if (connector instanceof ContainerLifeCycle) {
                ((ContainerLifeCycle)connector).unmanage((Object)threadPool);
            }
            connectors.add(connector);
        }
        return connectors;
    }

    private List<Connector> buildAppConnectors(MetricRegistry metricRegistry, Server server) {
        ArrayList<Connector> connectors = new ArrayList<Connector>();
        for (ConnectorFactory factory : this.applicationConnectors) {
            connectors.add(factory.build(server, metricRegistry, "application", null));
        }
        return connectors;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("applicationConnectors", this.applicationConnectors).add("adminConnectors", this.adminConnectors).add("adminMaxThreads", this.adminMaxThreads).add("adminMinThreads", this.adminMinThreads).add("applicationContextPath", (Object)this.applicationContextPath).add("adminContextPath", (Object)this.adminContextPath).toString();
    }
}

