/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.setup;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.health.SharedHealthCheckRegistries;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.dropwizard.jersey.DropwizardResourceConfig;
import io.dropwizard.jersey.setup.JerseyContainerHolder;
import io.dropwizard.jersey.setup.JerseyEnvironment;
import io.dropwizard.jersey.setup.JerseyServletContainer;
import io.dropwizard.jetty.MutableServletContextHandler;
import io.dropwizard.jetty.setup.ServletEnvironment;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.setup.AdminEnvironment;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import javax.servlet.Servlet;
import javax.validation.Validator;

public class Environment {
    private final String name;
    private final MetricRegistry metricRegistry;
    private final HealthCheckRegistry healthCheckRegistry;
    private final ObjectMapper objectMapper;
    private Validator validator;
    private final JerseyContainerHolder jerseyServletContainer;
    private final JerseyEnvironment jerseyEnvironment;
    private final MutableServletContextHandler servletContext;
    private final ServletEnvironment servletEnvironment;
    private final LifecycleEnvironment lifecycleEnvironment;
    private final MutableServletContextHandler adminContext;
    private final AdminEnvironment adminEnvironment;
    private final ExecutorService healthCheckExecutorService;

    public Environment(String name, ObjectMapper objectMapper, Validator validator, MetricRegistry metricRegistry, ClassLoader classLoader, HealthCheckRegistry healthCheckRegistry) {
        this.name = name;
        this.objectMapper = objectMapper;
        this.metricRegistry = metricRegistry;
        this.healthCheckRegistry = healthCheckRegistry;
        this.validator = validator;
        this.servletContext = new MutableServletContextHandler();
        this.servletContext.setClassLoader(classLoader);
        this.servletEnvironment = new ServletEnvironment(this.servletContext);
        this.adminContext = new MutableServletContextHandler();
        this.adminContext.setClassLoader(classLoader);
        this.adminEnvironment = new AdminEnvironment(this.adminContext, healthCheckRegistry, metricRegistry);
        this.lifecycleEnvironment = new LifecycleEnvironment();
        DropwizardResourceConfig jerseyConfig = new DropwizardResourceConfig(metricRegistry);
        this.jerseyServletContainer = new JerseyContainerHolder((Servlet)new JerseyServletContainer(jerseyConfig));
        this.jerseyEnvironment = new JerseyEnvironment(this.jerseyServletContainer, jerseyConfig);
        this.healthCheckExecutorService = this.lifecycle().executorService("TimeBoundHealthCheck-pool-%d").workQueue(new ArrayBlockingQueue(1)).minThreads(1).maxThreads(4).threadFactory(new ThreadFactoryBuilder().setDaemon(true).build()).rejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy()).build();
        try {
            SharedMetricRegistries.getDefault();
        }
        catch (IllegalStateException e) {
            SharedMetricRegistries.setDefault((String)"default", (MetricRegistry)metricRegistry);
        }
        try {
            SharedHealthCheckRegistries.getDefault();
        }
        catch (IllegalStateException e) {
            SharedHealthCheckRegistries.setDefault((String)"default", (HealthCheckRegistry)healthCheckRegistry);
        }
    }

    public Environment(String name, ObjectMapper objectMapper, Validator validator, MetricRegistry metricRegistry, ClassLoader classLoader) {
        this(name, objectMapper, validator, metricRegistry, classLoader, new HealthCheckRegistry());
    }

    public JerseyEnvironment jersey() {
        return this.jerseyEnvironment;
    }

    public ExecutorService getHealthCheckExecutorService() {
        return this.healthCheckExecutorService;
    }

    public AdminEnvironment admin() {
        return this.adminEnvironment;
    }

    public LifecycleEnvironment lifecycle() {
        return this.lifecycleEnvironment;
    }

    public ServletEnvironment servlets() {
        return this.servletEnvironment;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public String getName() {
        return this.name;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = Objects.requireNonNull(validator);
    }

    public MetricRegistry metrics() {
        return this.metricRegistry;
    }

    public HealthCheckRegistry healthChecks() {
        return this.healthCheckRegistry;
    }

    public MutableServletContextHandler getApplicationContext() {
        return this.servletContext;
    }

    public Servlet getJerseyServletContainer() {
        return this.jerseyServletContainer.getContainer();
    }

    public MutableServletContextHandler getAdminContext() {
        return this.adminContext;
    }
}

