/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.cli;

import io.dropwizard.cli.Command;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.util.JarLocation;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.helper.HelpScreenException;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class Cli {
    private static final String COMMAND_NAME_ATTR = "command";
    private static final String[][] HELP = new String[][]{new String[0], {"-h"}, {"--help"}};
    private static final String[][] VERSION = new String[][]{{"-v"}, {"--version"}};
    private final PrintWriter stdOut;
    private final PrintWriter stdErr;
    private final SortedMap<String, Command> commands;
    private final Bootstrap<?> bootstrap;
    private final ArgumentParser parser;

    public Cli(JarLocation location, Bootstrap<?> bootstrap, OutputStream stdOut, OutputStream stdErr) {
        this.stdOut = new PrintWriter((Writer)new OutputStreamWriter(stdOut, StandardCharsets.UTF_8), true);
        this.stdErr = new PrintWriter((Writer)new OutputStreamWriter(stdErr, StandardCharsets.UTF_8), true);
        this.commands = new TreeMap<String, Command>();
        this.parser = this.buildParser(location);
        this.bootstrap = bootstrap;
        for (Command command : bootstrap.getCommands()) {
            this.addCommand(command);
        }
    }

    public Optional<Throwable> run(String ... arguments) throws Exception {
        try {
            if (Cli.isFlag(HELP, arguments)) {
                this.parser.printHelp(this.stdOut);
            } else if (Cli.isFlag(VERSION, arguments)) {
                this.parser.printVersion(this.stdOut);
            } else {
                Namespace namespace = this.parser.parseArgs(arguments);
                Command command = Objects.requireNonNull((Command)this.commands.get(namespace.getString(COMMAND_NAME_ATTR)), "Command is not found");
                try {
                    command.run(this.bootstrap, namespace);
                }
                catch (Throwable e) {
                    command.onError(this, namespace, e);
                    return Optional.of(e);
                }
            }
            return Optional.empty();
        }
        catch (HelpScreenException ignored) {
            return Optional.empty();
        }
        catch (ArgumentParserException e) {
            this.stdErr.println(e.getMessage());
            e.getParser().printHelp(this.stdErr);
            return Optional.of(e);
        }
    }

    private static boolean isFlag(String[][] flags, String[] arguments) {
        for (Object[] objectArray : flags) {
            if (!Arrays.equals(arguments, objectArray)) continue;
            return true;
        }
        return false;
    }

    private ArgumentParser buildParser(JarLocation location) {
        String usage = "java -jar " + location;
        ArgumentParser p = ArgumentParsers.newFor((String)usage).addHelp(false).build();
        p.version(location.getVersion().orElse("No application version detected. Add a Implementation-Version entry to your JAR's manifest to enable this."));
        this.addHelp(p);
        p.addArgument(new String[]{"-v", "--version"}).action((ArgumentAction)Arguments.help()).help("show the application version and exit");
        return p;
    }

    private void addHelp(ArgumentParser p) {
        p.addArgument(new String[]{"-h", "--help"}).action((ArgumentAction)new SafeHelpAction(this.stdOut)).help("show this help message and exit").setDefault(Arguments.SUPPRESS);
    }

    private void addCommand(Command command) {
        this.commands.put(command.getName(), command);
        this.parser.addSubparsers().help("available commands");
        Subparser subparser = this.parser.addSubparsers().addParser(command.getName(), false);
        command.configure(subparser);
        this.addHelp((ArgumentParser)subparser);
        subparser.description(command.getDescription()).setDefault(COMMAND_NAME_ATTR, (Object)command.getName()).defaultHelp(true);
    }

    public PrintWriter getStdOut() {
        return this.stdOut;
    }

    public PrintWriter getStdErr() {
        return this.stdErr;
    }

    private static class SafeHelpAction
    implements ArgumentAction {
        private final PrintWriter out;

        SafeHelpAction(PrintWriter out) {
            this.out = out;
        }

        public void run(ArgumentParser parser, Argument arg, Map<String, Object> attrs, String flag, Object value) throws ArgumentParserException {
            parser.printHelp(this.out);
            throw new HelpScreenException(parser);
        }

        public boolean consumeArgument() {
            return false;
        }

        public void onAttach(Argument arg) {
        }
    }
}

