/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.core;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.core.server.DefaultServerFactory;
import io.dropwizard.core.server.ServerFactory;
import io.dropwizard.core.setup.AdminFactory;
import io.dropwizard.health.HealthFactory;
import io.dropwizard.logging.common.DefaultLoggingFactory;
import io.dropwizard.logging.common.LoggingFactory;
import io.dropwizard.metrics.common.MetricsFactory;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class Configuration {
    @Valid
    @NotNull
    private ServerFactory server = new DefaultServerFactory();
    @Valid
    @Nullable
    private LoggingFactory logging;
    @Valid
    @NotNull
    private MetricsFactory metrics = new MetricsFactory();
    @Valid
    @NotNull
    private AdminFactory admin = new AdminFactory();
    @Valid
    @Nullable
    private HealthFactory health;

    @JsonProperty(value="server")
    public ServerFactory getServerFactory() {
        return this.server;
    }

    @JsonProperty(value="server")
    public void setServerFactory(ServerFactory factory) {
        this.server = factory;
    }

    @JsonProperty(value="logging")
    public synchronized LoggingFactory getLoggingFactory() {
        if (this.logging == null) {
            this.logging = new DefaultLoggingFactory();
        }
        return this.logging;
    }

    @JsonProperty(value="logging")
    public synchronized void setLoggingFactory(LoggingFactory factory) {
        this.logging = factory;
    }

    @JsonProperty(value="metrics")
    public MetricsFactory getMetricsFactory() {
        return this.metrics;
    }

    @JsonProperty(value="metrics")
    public void setMetricsFactory(MetricsFactory metrics) {
        this.metrics = metrics;
    }

    @JsonProperty(value="admin")
    public AdminFactory getAdminFactory() {
        return this.admin;
    }

    @JsonProperty(value="admin")
    public void setAdminFactory(AdminFactory admin) {
        this.admin = admin;
    }

    @JsonProperty(value="health")
    public Optional<HealthFactory> getHealthFactory() {
        return Optional.ofNullable(this.health);
    }

    @JsonProperty(value="health")
    public void setHealthFactory(HealthFactory health) {
        this.health = health;
    }

    public String toString() {
        return "Configuration{server=" + this.server + ", logging=" + this.logging + ", metrics=" + this.metrics + ", admin=" + this.admin + ", health=" + this.health + "}";
    }
}

