/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.core.setup;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.JvmAttributeGaugeSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.configuration.ConfigurationFactoryFactory;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.configuration.DefaultConfigurationFactoryFactory;
import io.dropwizard.configuration.FileConfigurationSourceProvider;
import io.dropwizard.core.Application;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.ConfiguredBundle;
import io.dropwizard.core.cli.Command;
import io.dropwizard.core.cli.ConfiguredCommand;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.jackson.Jackson;
import io.dropwizard.jersey.validation.Validators;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.ValidatorFactory;

public class Bootstrap<T extends Configuration> {
    private final Application<T> application;
    private final List<ConfiguredBundle<? super T>> configuredBundles;
    private final List<Command> commands;
    private ObjectMapper objectMapper;
    private MetricRegistry metricRegistry;
    @Nullable
    private JmxReporter jmxReporter;
    private ConfigurationSourceProvider configurationSourceProvider;
    private ClassLoader classLoader;
    private ConfigurationFactoryFactory<T> configurationFactoryFactory;
    private ValidatorFactory validatorFactory;
    private boolean metricsAreRegistered;
    private HealthCheckRegistry healthCheckRegistry;

    public Bootstrap(Application<T> application) {
        this.application = application;
        this.objectMapper = Jackson.newObjectMapper();
        this.configuredBundles = new ArrayList<ConfiguredBundle<? super T>>();
        this.commands = new ArrayList<Command>();
        this.validatorFactory = Validators.newValidatorFactory();
        this.metricRegistry = new MetricRegistry();
        this.configurationSourceProvider = new FileConfigurationSourceProvider();
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.configurationFactoryFactory = new DefaultConfigurationFactoryFactory();
        this.healthCheckRegistry = new HealthCheckRegistry();
    }

    public void registerMetrics() {
        if (this.metricsAreRegistered) {
            return;
        }
        this.getMetricRegistry().register("jvm.attribute", (Metric)new JvmAttributeGaugeSet());
        this.getMetricRegistry().register("jvm.buffers", (Metric)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
        this.getMetricRegistry().register("jvm.classloader", (Metric)new ClassLoadingGaugeSet());
        this.getMetricRegistry().register("jvm.filedescriptor", (Metric)new FileDescriptorRatioGauge());
        this.getMetricRegistry().register("jvm.gc", (Metric)new GarbageCollectorMetricSet());
        this.getMetricRegistry().register("jvm.memory", (Metric)new MemoryUsageGaugeSet());
        this.getMetricRegistry().register("jvm.threads", (Metric)new ThreadStatesGaugeSet());
        this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)this.metricRegistry).build();
        this.jmxReporter.start();
        this.metricsAreRegistered = true;
    }

    @Nullable
    public JmxReporter getJmxReporter() {
        return this.jmxReporter;
    }

    public Application<T> getApplication() {
        return this.application;
    }

    public ConfigurationSourceProvider getConfigurationSourceProvider() {
        return this.configurationSourceProvider;
    }

    public void setConfigurationSourceProvider(ConfigurationSourceProvider provider) {
        this.configurationSourceProvider = Objects.requireNonNull(provider);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void addBundle(ConfiguredBundle<? super T> bundle) {
        bundle.initialize(this);
        this.configuredBundles.add(bundle);
    }

    public void addCommand(Command command) {
        this.commands.add(command);
    }

    public void addCommand(ConfiguredCommand<T> command) {
        this.commands.add(command);
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void run(T configuration, Environment environment) throws Exception {
        for (ConfiguredBundle<T> bundle : this.configuredBundles) {
            bundle.run(configuration, environment);
        }
    }

    public List<Command> getCommands() {
        return new ArrayList<Command>(this.commands);
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public void setMetricRegistry(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public ValidatorFactory getValidatorFactory() {
        return this.validatorFactory;
    }

    public void setValidatorFactory(ValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
    }

    public ConfigurationFactoryFactory<T> getConfigurationFactoryFactory() {
        return this.configurationFactoryFactory;
    }

    public void setConfigurationFactoryFactory(ConfigurationFactoryFactory<T> configurationFactoryFactory) {
        this.configurationFactoryFactory = configurationFactoryFactory;
    }

    public HealthCheckRegistry getHealthCheckRegistry() {
        return this.healthCheckRegistry;
    }

    public void setHealthCheckRegistry(HealthCheckRegistry healthCheckRegistry) {
        this.healthCheckRegistry = healthCheckRegistry;
    }
}

