/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.benchmarks;

import io.dropwizard.metrics5.SlidingTimeWindowArrayReservoir;
import io.dropwizard.metrics5.SlidingTimeWindowReservoir;
import io.dropwizard.metrics5.Snapshot;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Group;
import org.openjdk.jmh.annotations.GroupThreads;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;

@State(value=Scope.Benchmark)
public class SlidingTimeWindowReservoirsBenchmark {
    private final SlidingTimeWindowReservoir slidingTime = new SlidingTimeWindowReservoir(200L, TimeUnit.MILLISECONDS);
    private final SlidingTimeWindowArrayReservoir arrTime = new SlidingTimeWindowArrayReservoir(200L, TimeUnit.MILLISECONDS);
    private long nextValue = -67392582L;

    @Benchmark
    @Group(value="slidingTime")
    @GroupThreads(value=3)
    public Object slidingTimeAddMeasurement() {
        this.slidingTime.update(this.nextValue);
        return this.slidingTime;
    }

    @Benchmark
    @Group(value="slidingTime")
    @GroupThreads(value=1)
    public Object slidingTimeRead() {
        Snapshot snapshot = this.slidingTime.getSnapshot();
        return snapshot;
    }

    @Benchmark
    @Group(value="arrTime")
    @GroupThreads(value=3)
    public Object arrTimeAddMeasurement() {
        this.arrTime.update(this.nextValue);
        return this.slidingTime;
    }

    @Benchmark
    @Group(value="arrTime")
    @GroupThreads(value=1)
    public Object arrTimeRead() {
        Snapshot snapshot = this.arrTime.getSnapshot();
        return snapshot;
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(".*" + SlidingTimeWindowReservoirsBenchmark.class.getSimpleName() + ".*").warmupIterations(10).measurementIterations(10).addProfiler(GCProfiler.class).measurementTime(TimeValue.seconds((long)3L)).timeUnit(TimeUnit.MICROSECONDS).mode(Mode.AverageTime).forks(1).build();
        new Runner(opt).run();
    }
}

