/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.caffeine3;

import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.Histogram;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.Timer;
import java.util.EnumMap;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.checkerframework.checker.index.qual.NonNegative;

public final class MetricsStatsCounter
implements StatsCounter {
    private final Counter hitCount;
    private final Counter missCount;
    private final Timer loadSuccess;
    private final Timer loadFailure;
    private final Counter evictionWeight;
    private final EnumMap<RemovalCause, Histogram> evictionsWithCause;
    private final LongAdder totalLoadTime = new LongAdder();

    public MetricsStatsCounter(MetricRegistry registry, String metricsPrefix) {
        Objects.requireNonNull(metricsPrefix);
        this.hitCount = registry.counter(MetricRegistry.name((String)metricsPrefix, (String[])new String[]{"hits"}));
        this.missCount = registry.counter(MetricRegistry.name((String)metricsPrefix, (String[])new String[]{"misses"}));
        this.loadSuccess = registry.timer(MetricRegistry.name((String)metricsPrefix, (String[])new String[]{"loads-success"}));
        this.loadFailure = registry.timer(MetricRegistry.name((String)metricsPrefix, (String[])new String[]{"loads-failure"}));
        this.evictionWeight = registry.counter(MetricRegistry.name((String)metricsPrefix, (String[])new String[]{"evictions-weight"}));
        this.evictionsWithCause = new EnumMap(RemovalCause.class);
        for (RemovalCause cause : RemovalCause.values()) {
            this.evictionsWithCause.put(cause, registry.histogram(MetricRegistry.name((String)metricsPrefix, (String[])new String[]{"evictions", cause.name()})));
        }
    }

    public void recordHits(int count) {
        this.hitCount.inc((long)count);
    }

    public void recordMisses(int count) {
        this.missCount.inc((long)count);
    }

    public void recordLoadSuccess(long loadTime) {
        this.loadSuccess.update(loadTime, TimeUnit.NANOSECONDS);
        this.totalLoadTime.add(loadTime);
    }

    public void recordLoadFailure(long loadTime) {
        this.loadFailure.update(loadTime, TimeUnit.NANOSECONDS);
        this.totalLoadTime.add(loadTime);
    }

    public void recordEviction(@NonNegative int weight, RemovalCause cause) {
        this.evictionsWithCause.get(cause).update(weight);
        this.evictionWeight.inc((long)weight);
    }

    public CacheStats snapshot() {
        return CacheStats.of((long)this.hitCount.getCount(), (long)this.missCount.getCount(), (long)this.loadSuccess.getCount(), (long)this.loadFailure.getCount(), (long)this.totalLoadTime.sum(), (long)this.evictionsWithCause.values().stream().mapToLong(Histogram::getCount).sum(), (long)this.evictionWeight.getCount());
    }

    public String toString() {
        return this.snapshot().toString();
    }
}

