/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.collectd;

import io.dropwizard.metrics5.collectd.Sanitize;

class MetaData {
    private final String host;
    private final String plugin;
    private final String pluginInstance;
    private final String type;
    private final String typeInstance;
    private final long timestamp;
    private final long period;

    MetaData(String host, String plugin, String pluginInstance, String type, String typeInstance, long timestamp, long period) {
        this.host = host;
        this.plugin = plugin;
        this.pluginInstance = pluginInstance;
        this.type = type;
        this.typeInstance = typeInstance;
        this.timestamp = timestamp;
        this.period = period;
    }

    String getHost() {
        return this.host;
    }

    String getPlugin() {
        return this.plugin;
    }

    String getPluginInstance() {
        return this.pluginInstance;
    }

    String getType() {
        return this.type;
    }

    String getTypeInstance() {
        return this.typeInstance;
    }

    long getTimestamp() {
        return this.timestamp;
    }

    long getPeriod() {
        return this.period;
    }

    static class Builder {
        private String host;
        private String plugin;
        private String pluginInstance;
        private String type;
        private String typeInstance;
        private long timestamp;
        private long period;
        private Sanitize sanitize;

        Builder(String host, long timestamp, long duration) {
            this(new Sanitize(63), host, timestamp, duration);
        }

        Builder(Sanitize sanitize, String host, long timestamp, long duration) {
            this.sanitize = sanitize;
            this.host = sanitize.instanceName(host);
            this.timestamp = timestamp;
            this.period = duration;
        }

        Builder plugin(String name) {
            this.plugin = this.sanitize.name(name);
            return this;
        }

        Builder pluginInstance(String name) {
            this.pluginInstance = this.sanitize.instanceName(name);
            return this;
        }

        Builder type(String name) {
            this.type = this.sanitize.name(name);
            return this;
        }

        Builder typeInstance(String name) {
            this.typeInstance = this.sanitize.instanceName(name);
            return this;
        }

        MetaData get() {
            return new MetaData(this.host, this.plugin, this.pluginInstance, this.type, this.typeInstance, this.timestamp, this.period);
        }
    }
}

