/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.collectd;

import java.util.Arrays;
import java.util.List;

class Sanitize {
    static final int DEFAULT_MAX_LENGTH = 63;
    private static final char DASH = '-';
    private static final char SLASH = '/';
    private static final char NULL = '\u0000';
    private static final char UNDERSCORE = '_';
    private static final List<Character> INSTANCE_RESERVED = Arrays.asList(Character.valueOf('/'), Character.valueOf('\u0000'));
    private static final List<Character> NAME_RESERVED = Arrays.asList(Character.valueOf('-'), Character.valueOf('/'), Character.valueOf('\u0000'));
    private final int maxLength;

    Sanitize(int maxLength) {
        this.maxLength = maxLength;
    }

    String name(String name) {
        return this.sanitize(name, NAME_RESERVED);
    }

    String instanceName(String instanceName) {
        return this.sanitize(instanceName, INSTANCE_RESERVED);
    }

    private String sanitize(String string, List<Character> reservedChars) {
        StringBuilder buffer = new StringBuilder(string.length());
        int len = Math.min(string.length(), this.maxLength);
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            boolean legal = c < '\u0080' && !reservedChars.contains(Character.valueOf(c));
            buffer.append(legal ? c : (char)'_');
        }
        return buffer.toString();
    }
}

