/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.collectd;

import io.dropwizard.metrics5.collectd.MetaData;
import io.dropwizard.metrics5.collectd.SecurityLevel;
import io.dropwizard.metrics5.collectd.Sender;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class PacketWriter {
    private static final int TYPE_HOST = 0;
    private static final int TYPE_TIME = 1;
    private static final int TYPE_PLUGIN = 2;
    private static final int TYPE_PLUGIN_INSTANCE = 3;
    private static final int TYPE_TYPE = 4;
    private static final int TYPE_TYPE_INSTANCE = 5;
    private static final int TYPE_VALUES = 6;
    private static final int TYPE_INTERVAL = 7;
    private static final int TYPE_SIGN_SHA256 = 512;
    private static final int TYPE_ENCR_AES256 = 528;
    private static final int UINT16_LEN = 2;
    private static final int UINT32_LEN = 4;
    private static final int UINT64_LEN = 8;
    private static final int HEADER_LEN = 4;
    private static final int BUFFER_SIZE = 1024;
    private static final int VALUE_COUNT_LEN = 2;
    private static final int NUMBER_LEN = 12;
    private static final int SIGNATURE_LEN = 36;
    private static final int ENCRYPT_DATA_LEN = 22;
    private static final int IV_LENGTH = 16;
    private static final int SHA1_LENGTH = 20;
    private static final int VALUE_LEN = 9;
    private static final byte DATA_TYPE_GAUGE = 1;
    private static final byte NULL = 0;
    private static final String HMAC_SHA256_ALGORITHM = "HmacSHA256";
    private static final String AES_CYPHER = "AES_256/OFB/NoPadding";
    private static final String AES = "AES";
    private static final String SHA_256_ALGORITHM = "SHA-256";
    private static final String SHA_1_ALGORITHM = "SHA1";
    private final Sender sender;
    private final SecurityLevel securityLevel;
    private final byte[] username;
    private final byte[] password;

    PacketWriter(Sender sender, String username, String password, SecurityLevel securityLevel) {
        this.sender = sender;
        this.securityLevel = securityLevel;
        this.username = username != null ? username.getBytes(StandardCharsets.UTF_8) : null;
        this.password = password != null ? password.getBytes(StandardCharsets.UTF_8) : null;
    }

    void write(MetaData metaData, Number ... values) throws BufferOverflowException, IOException {
        ByteBuffer packet = ByteBuffer.allocate(1024);
        this.write(packet, metaData);
        this.write(packet, values);
        packet.flip();
        switch (this.securityLevel) {
            case NONE: {
                this.sender.send(packet);
                break;
            }
            case SIGN: {
                this.sender.send(this.signPacket(packet));
                break;
            }
            case ENCRYPT: {
                this.sender.send(this.encryptPacket(packet));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported security level: " + (Object)((Object)this.securityLevel));
            }
        }
    }

    private void write(ByteBuffer buffer, MetaData metaData) {
        this.writeString(buffer, 0, metaData.getHost());
        this.writeNumber(buffer, 1, metaData.getTimestamp());
        this.writeString(buffer, 2, metaData.getPlugin());
        this.writeString(buffer, 3, metaData.getPluginInstance());
        this.writeString(buffer, 4, metaData.getType());
        this.writeString(buffer, 5, metaData.getTypeInstance());
        this.writeNumber(buffer, 7, metaData.getPeriod());
    }

    private void write(ByteBuffer buffer, Number ... values) {
        int numValues = values.length;
        int length = 6 + numValues * 9;
        this.writeHeader(buffer, 6, length);
        buffer.putShort((short)numValues);
        buffer.put(this.nCopies(numValues, (byte)1));
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (Number value : values) {
            buffer.putDouble(value.doubleValue());
        }
        buffer.order(ByteOrder.BIG_ENDIAN);
    }

    private byte[] nCopies(int n, byte value) {
        byte[] array = new byte[n];
        Arrays.fill(array, value);
        return array;
    }

    private void writeString(ByteBuffer buffer, int type, String val) {
        if (val == null || val.length() == 0) {
            return;
        }
        int len = 4 + val.length() + 1;
        this.writeHeader(buffer, type, len);
        buffer.put(val.getBytes(StandardCharsets.US_ASCII)).put((byte)0);
    }

    private void writeNumber(ByteBuffer buffer, int type, long val) {
        this.writeHeader(buffer, type, 12);
        buffer.putLong(val);
    }

    private void writeHeader(ByteBuffer buffer, int type, int len) {
        buffer.putShort((short)type);
        buffer.putShort((short)len);
    }

    private ByteBuffer signPacket(ByteBuffer packet) {
        byte[] signature = PacketWriter.sign(this.password, (ByteBuffer)ByteBuffer.allocate(packet.remaining() + this.username.length).put(this.username).put(packet).flip());
        return (ByteBuffer)ByteBuffer.allocate(1024).putShort((short)512).putShort((short)(this.username.length + 36)).put(signature).put(this.username).put((ByteBuffer)packet.flip()).flip();
    }

    private ByteBuffer encryptPacket(ByteBuffer packet) {
        ByteBuffer payload = (ByteBuffer)ByteBuffer.allocate(20 + packet.remaining()).put(PacketWriter.sha1(packet)).put((ByteBuffer)packet.flip()).flip();
        EncryptionResult er = PacketWriter.encrypt(this.password, payload);
        return (ByteBuffer)ByteBuffer.allocate(1024).putShort((short)528).putShort((short)(22 + this.username.length + er.output.remaining())).putShort((short)this.username.length).put(this.username).put(er.iv).put(er.output).flip();
    }

    private static byte[] sign(byte[] secret, ByteBuffer input) {
        Mac mac;
        try {
            mac = Mac.getInstance(HMAC_SHA256_ALGORITHM);
            mac.init(new SecretKeySpec(secret, HMAC_SHA256_ALGORITHM));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        mac.update(input);
        return mac.doFinal();
    }

    private static EncryptionResult encrypt(byte[] password, ByteBuffer input) {
        byte[] iv;
        Cipher cipher;
        try {
            cipher = Cipher.getInstance(AES_CYPHER);
            cipher.init(1, new SecretKeySpec(PacketWriter.sha256(password), AES));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
        try {
            iv = cipher.getParameters().getParameterSpec(IvParameterSpec.class).getIV();
        }
        catch (InvalidParameterSpecException e) {
            throw new RuntimeException(e);
        }
        if (iv.length != 16) {
            throw new IllegalStateException("Bad initialization vector");
        }
        ByteBuffer output = ByteBuffer.allocate(input.remaining() * 2);
        try {
            cipher.doFinal(input, output);
        }
        catch (BadPaddingException | IllegalBlockSizeException | ShortBufferException e) {
            throw new RuntimeException(e);
        }
        return new EncryptionResult(iv, (ByteBuffer)output.flip());
    }

    private static byte[] sha256(byte[] input) {
        try {
            return MessageDigest.getInstance(SHA_256_ALGORITHM).digest(input);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] sha1(ByteBuffer input) {
        try {
            MessageDigest digest = MessageDigest.getInstance(SHA_1_ALGORITHM);
            digest.update(input);
            byte[] output = digest.digest();
            if (output.length != 20) {
                throw new IllegalStateException("Bad SHA1 hash");
            }
            return output;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static class EncryptionResult {
        private final byte[] iv;
        private final ByteBuffer output;

        private EncryptionResult(byte[] iv, ByteBuffer output) {
            this.iv = iv;
            this.output = output;
        }
    }
}

