/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.collectd;

import io.dropwizard.metrics5.Clock;
import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.Gauge;
import io.dropwizard.metrics5.Histogram;
import io.dropwizard.metrics5.Meter;
import io.dropwizard.metrics5.MetricFilter;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.ScheduledReporter;
import io.dropwizard.metrics5.Snapshot;
import io.dropwizard.metrics5.Timer;
import io.dropwizard.metrics5.collectd.MetaData;
import io.dropwizard.metrics5.collectd.PacketWriter;
import io.dropwizard.metrics5.collectd.Sender;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectdReporter
extends ScheduledReporter {
    private static final Logger LOG = LoggerFactory.getLogger(CollectdReporter.class);
    private static final String REPORTER_NAME = "collectd-reporter";
    private static final String FALLBACK_HOST_NAME = "localhost";
    private static final String COLLECTD_TYPE_GAUGE = "gauge";
    private String hostName;
    private final Sender sender;
    private final Clock clock;
    private long period;
    private final PacketWriter writer;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    private CollectdReporter(MetricRegistry registry, String hostname, Sender sender, Clock clock, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter) {
        super(registry, REPORTER_NAME, filter, rateUnit, durationUnit);
        this.hostName = hostname != null ? hostname : this.resolveHostName();
        this.sender = sender;
        this.clock = clock;
        this.writer = new PacketWriter(sender);
    }

    private String resolveHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            LOG.error("Failed to lookup local host name: {}", (Object)e.getMessage(), (Object)e);
            return FALLBACK_HOST_NAME;
        }
    }

    public void start(long period, TimeUnit unit) {
        this.period = period;
        super.start(period, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(SortedMap<MetricName, Gauge> gauges, SortedMap<MetricName, Counter> counters, SortedMap<MetricName, Histogram> histograms, SortedMap<MetricName, Meter> meters, SortedMap<MetricName, Timer> timers) {
        MetaData.Builder metaData = new MetaData.Builder(this.hostName, this.clock.getTime() / 1000L, this.period).type(COLLECTD_TYPE_GAUGE);
        try {
            this.connect(this.sender);
            for (Map.Entry<MetricName, Gauge> entry : gauges.entrySet()) {
                this.serializeGauge(metaData.plugin(entry.getKey().getKey()), entry.getValue());
            }
            for (Map.Entry<MetricName, Gauge> entry : counters.entrySet()) {
                this.serializeCounter(metaData.plugin(entry.getKey().getKey()), (Counter)entry.getValue());
            }
            for (Map.Entry<MetricName, Gauge> entry : histograms.entrySet()) {
                this.serializeHistogram(metaData.plugin(entry.getKey().getKey()), (Histogram)entry.getValue());
            }
            for (Map.Entry<MetricName, Gauge> entry : meters.entrySet()) {
                this.serializeMeter(metaData.plugin(entry.getKey().getKey()), (Meter)entry.getValue());
            }
            for (Map.Entry<MetricName, Gauge> entry : timers.entrySet()) {
                this.serializeTimer(metaData.plugin(entry.getKey().getKey()), (Timer)entry.getValue());
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to report to Collectd", (Throwable)e);
        }
        finally {
            this.disconnect(this.sender);
        }
    }

    private void connect(Sender sender) throws IOException {
        if (!sender.isConnected()) {
            sender.connect();
        }
    }

    private void disconnect(Sender sender) {
        try {
            sender.disconnect();
        }
        catch (Exception e) {
            LOG.warn("Error disconnecting from Collectd", (Throwable)e);
        }
    }

    private void write(MetaData metaData, Number ... values) {
        try {
            this.writer.write(metaData, values);
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to process metric '" + metaData.getPlugin() + "': " + e.getMessage());
        }
        catch (IOException e) {
            LOG.error("Failed to send metric to collectd", (Throwable)e);
        }
    }

    private void serializeGauge(MetaData.Builder metaData, Gauge metric) {
        if (metric.getValue() instanceof Number) {
            this.write(metaData.typeInstance("value").get(), (Number)metric.getValue());
        } else if (metric.getValue() instanceof Boolean) {
            this.write(metaData.typeInstance("value").get(), (Boolean)metric.getValue() != false ? 1 : 0);
        } else {
            LOG.warn("Failed to process metric '{}'. Unsupported gauge of type: {} ", (Object)metaData.get().getPlugin(), (Object)metric.getValue().getClass().getName());
        }
    }

    private void serializeMeter(MetaData.Builder metaData, Meter metric) {
        this.write(metaData.typeInstance("count").get(), metric.getCount());
        this.write(metaData.typeInstance("m1_rate").get(), this.convertRate(metric.getOneMinuteRate()));
        this.write(metaData.typeInstance("m5_rate").get(), this.convertRate(metric.getFiveMinuteRate()));
        this.write(metaData.typeInstance("m15_rate").get(), this.convertRate(metric.getFifteenMinuteRate()));
        this.write(metaData.typeInstance("mean_rate").get(), this.convertRate(metric.getMeanRate()));
    }

    private void serializeCounter(MetaData.Builder metaData, Counter metric) {
        this.write(metaData.typeInstance("count").get(), metric.getCount());
    }

    private void serializeHistogram(MetaData.Builder metaData, Histogram metric) {
        Snapshot snapshot = metric.getSnapshot();
        this.write(metaData.typeInstance("count").get(), metric.getCount());
        this.write(metaData.typeInstance("max").get(), snapshot.getMax());
        this.write(metaData.typeInstance("mean").get(), snapshot.getMean());
        this.write(metaData.typeInstance("min").get(), snapshot.getMin());
        this.write(metaData.typeInstance("stddev").get(), snapshot.getStdDev());
        this.write(metaData.typeInstance("p50").get(), snapshot.getMedian());
        this.write(metaData.typeInstance("p75").get(), snapshot.get75thPercentile());
        this.write(metaData.typeInstance("p95").get(), snapshot.get95thPercentile());
        this.write(metaData.typeInstance("p98").get(), snapshot.get98thPercentile());
        this.write(metaData.typeInstance("p99").get(), snapshot.get99thPercentile());
        this.write(metaData.typeInstance("p999").get(), snapshot.get999thPercentile());
    }

    private void serializeTimer(MetaData.Builder metaData, Timer metric) {
        Snapshot snapshot = metric.getSnapshot();
        this.write(metaData.typeInstance("count").get(), metric.getCount());
        this.write(metaData.typeInstance("max").get(), this.convertDuration(snapshot.getMax()));
        this.write(metaData.typeInstance("mean").get(), this.convertDuration(snapshot.getMean()));
        this.write(metaData.typeInstance("min").get(), this.convertDuration(snapshot.getMin()));
        this.write(metaData.typeInstance("stddev").get(), this.convertDuration(snapshot.getStdDev()));
        this.write(metaData.typeInstance("p50").get(), this.convertDuration(snapshot.getMedian()));
        this.write(metaData.typeInstance("p75").get(), this.convertDuration(snapshot.get75thPercentile()));
        this.write(metaData.typeInstance("p95").get(), this.convertDuration(snapshot.get95thPercentile()));
        this.write(metaData.typeInstance("p98").get(), this.convertDuration(snapshot.get98thPercentile()));
        this.write(metaData.typeInstance("p99").get(), this.convertDuration(snapshot.get99thPercentile()));
        this.write(metaData.typeInstance("p999").get(), this.convertDuration(snapshot.get999thPercentile()));
        this.write(metaData.typeInstance("m1_rate").get(), this.convertRate(metric.getOneMinuteRate()));
        this.write(metaData.typeInstance("m5_rate").get(), this.convertRate(metric.getFiveMinuteRate()));
        this.write(metaData.typeInstance("m15_rate").get(), this.convertRate(metric.getFifteenMinuteRate()));
        this.write(metaData.typeInstance("mean_rate").get(), this.convertRate(metric.getMeanRate()));
    }

    public static class Builder {
        private final MetricRegistry registry;
        private String hostName;
        private Clock clock = Clock.defaultClock();
        private TimeUnit rateUnit = TimeUnit.SECONDS;
        private TimeUnit durationUnit = TimeUnit.MILLISECONDS;
        private MetricFilter filter = MetricFilter.ALL;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
        }

        public Builder withHostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public CollectdReporter build(Sender sender) {
            return new CollectdReporter(this.registry, this.hostName, sender, this.clock, this.rateUnit, this.durationUnit, this.filter);
        }
    }
}

