/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.collectd;

import io.dropwizard.metrics5.collectd.MetaData;
import io.dropwizard.metrics5.collectd.Sender;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

class PacketWriter {
    private static final int TYPE_HOST = 0;
    private static final int TYPE_TIME = 1;
    private static final int TYPE_PLUGIN = 2;
    private static final int TYPE_PLUGIN_INSTANCE = 3;
    private static final int TYPE_TYPE = 4;
    private static final int TYPE_TYPE_INSTANCE = 5;
    private static final int TYPE_VALUES = 6;
    private static final int TYPE_INTERVAL = 7;
    private static final int UINT16_LEN = 2;
    private static final int UINT32_LEN = 4;
    private static final int UINT64_LEN = 8;
    private static final int HEADER_LEN = 4;
    private static final int BUFFER_SIZE = 1024;
    private static final int VALUE_COUNT_LEN = 2;
    private static final int NUMBER_LEN = 12;
    private static final int VALUE_LEN = 9;
    private static final byte DATA_TYPE_GAUGE = 1;
    private static final byte NULL = 0;
    private final Sender sender;

    PacketWriter(Sender sender) {
        this.sender = sender;
    }

    void write(MetaData metaData, Number ... values) throws BufferOverflowException, IOException {
        ByteBuffer packet = ByteBuffer.allocate(1024);
        this.write(packet, metaData);
        this.write(packet, values);
        packet.flip();
        this.sender.send(packet);
    }

    private void write(ByteBuffer buffer, MetaData metaData) {
        this.writeString(buffer, 0, metaData.getHost());
        this.writeNumber(buffer, 1, metaData.getTimestamp());
        this.writeString(buffer, 2, metaData.getPlugin());
        this.writeString(buffer, 3, metaData.getPluginInstance());
        this.writeString(buffer, 4, metaData.getType());
        this.writeString(buffer, 5, metaData.getTypeInstance());
        this.writeNumber(buffer, 7, metaData.getPeriod());
    }

    private void write(ByteBuffer buffer, Number ... values) {
        int numValues = values.length;
        int length = 6 + numValues * 9;
        this.writeHeader(buffer, 6, length);
        buffer.putShort((short)numValues);
        buffer.put(this.nCopies(numValues, (byte)1));
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (Number value : values) {
            buffer.putDouble(value.doubleValue());
        }
        buffer.order(ByteOrder.BIG_ENDIAN);
    }

    private byte[] nCopies(int n, byte value) {
        byte[] array = new byte[n];
        Arrays.fill(array, value);
        return array;
    }

    private void writeString(ByteBuffer buffer, int type, String val) {
        if (val == null || val.length() == 0) {
            return;
        }
        int len = 4 + val.length() + 1;
        this.writeHeader(buffer, type, len);
        buffer.put(val.getBytes(StandardCharsets.US_ASCII)).put((byte)0);
    }

    private void writeNumber(ByteBuffer buffer, int type, long val) {
        this.writeHeader(buffer, type, 12);
        buffer.putLong(val);
    }

    private void writeHeader(ByteBuffer buffer, int type, int len) {
        buffer.putShort((short)type);
        buffer.putShort((short)len);
    }
}

