/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;

public class MetricName
implements Comparable<MetricName> {
    private static final String SEPARATOR = ".";
    private static final Map<String, String> EMPTY_TAGS = Collections.unmodifiableMap(new HashMap());
    static final MetricName EMPTY = new MetricName("");
    private final String key;
    private final Map<String, String> tags;

    private MetricName(String key) {
        this(key, EMPTY_TAGS);
    }

    public MetricName(String key, Map<String, String> tags) {
        this.key = Objects.requireNonNull(key);
        this.tags = tags.isEmpty() ? EMPTY_TAGS : Collections.unmodifiableMap(tags);
    }

    public String getKey() {
        return this.key;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public MetricName resolve(String p) {
        String next = p != null && !p.isEmpty() ? (!this.key.isEmpty() ? this.key + SEPARATOR + p : p) : this.key;
        return new MetricName(next, this.tags);
    }

    public MetricName tagged(Map<String, String> add) {
        HashMap<String, String> newTags = new HashMap<String, String>(add);
        newTags.putAll(this.tags);
        return new MetricName(this.key, newTags);
    }

    public MetricName tagged(String ... pairs) {
        if (pairs == null || pairs.length == 0) {
            return this;
        }
        if (pairs.length % 2 != 0) {
            throw new IllegalArgumentException("Argument count must be even");
        }
        HashMap<String, String> add = new HashMap<String, String>();
        for (int i = 0; i < pairs.length; i += 2) {
            add.put(pairs[i], pairs[i + 1]);
        }
        return this.tagged(add);
    }

    public static MetricName join(MetricName ... parts) {
        StringBuilder nameBuilder = new StringBuilder();
        HashMap<String, String> tags = new HashMap<String, String>();
        boolean first = true;
        for (MetricName part : parts) {
            String name = part.getKey();
            if (name != null && !name.isEmpty()) {
                if (first) {
                    first = false;
                } else {
                    nameBuilder.append(SEPARATOR);
                }
                nameBuilder.append(name);
            }
            if (part.getTags().isEmpty()) continue;
            tags.putAll(part.getTags());
        }
        return new MetricName(nameBuilder.toString(), tags);
    }

    public static MetricName build(String ... parts) {
        if (parts == null || parts.length == 0) {
            return EMPTY;
        }
        if (parts.length == 1) {
            return new MetricName(parts[0], EMPTY_TAGS);
        }
        return new MetricName(MetricName.buildName(parts), EMPTY_TAGS);
    }

    private static String buildName(String ... names) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String name : names) {
            if (name == null || name.isEmpty()) continue;
            if (first) {
                first = false;
            } else {
                builder.append(SEPARATOR);
            }
            builder.append(name);
        }
        return builder.toString();
    }

    public String toString() {
        return this.tags.isEmpty() ? this.key : this.key + this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricName that = (MetricName)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.tags, that.tags);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.tags);
    }

    @Override
    public int compareTo(MetricName o) {
        if (o == null) {
            return -1;
        }
        int c = this.compareName(this.key, o.getKey());
        if (c != 0) {
            return c;
        }
        return this.compareTags(this.tags, o.getTags());
    }

    private int compareName(String left, String right) {
        if (left.isEmpty() && right.isEmpty()) {
            return 0;
        }
        if (left.isEmpty()) {
            return 1;
        }
        if (right.isEmpty()) {
            return -1;
        }
        return left.compareTo(right);
    }

    private int compareTags(Map<String, String> left, Map<String, String> right) {
        if (left.isEmpty() && right.isEmpty()) {
            return 0;
        }
        if (left.isEmpty()) {
            return 1;
        }
        if (right.isEmpty()) {
            return -1;
        }
        Iterable<String> keys = this.uniqueSortedKeys(left, right);
        for (String key : keys) {
            String a = left.get(key);
            String b = right.get(key);
            if (a == null && b == null) continue;
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            int c = a.compareTo(b);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    private Iterable<String> uniqueSortedKeys(Map<String, String> left, Map<String, String> right) {
        TreeSet<String> set = new TreeSet<String>(left.keySet());
        set.addAll(right.keySet());
        return set;
    }
}

