/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.httpclient5;

import io.dropwizard.metrics5.Gauge;
import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricRegistry;
import java.util.Objects;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.util.TimeValue;

public class InstrumentedAsyncClientConnectionManager
extends PoolingAsyncClientConnectionManager {
    private static final String METRICS_PREFIX = AsyncClientConnectionManager.class.getName();
    private final MetricRegistry metricsRegistry;
    private final String name;

    protected static Registry<TlsStrategy> getDefaultTlsStrategy() {
        return RegistryBuilder.create().register(URIScheme.HTTPS.id, (Object)DefaultClientTlsStrategy.getDefault()).build();
    }

    InstrumentedAsyncClientConnectionManager(MetricRegistry metricRegistry, String name, Lookup<TlsStrategy> tlsStrategyLookup, PoolConcurrencyPolicy poolConcurrencyPolicy, PoolReusePolicy poolReusePolicy, TimeValue timeToLive, SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
        super(tlsStrategyLookup, poolConcurrencyPolicy, poolReusePolicy, timeToLive, schemePortResolver, dnsResolver);
        this.metricsRegistry = Objects.requireNonNull(metricRegistry, "metricRegistry");
        this.name = name;
        metricRegistry.register(MetricRegistry.name((String)METRICS_PREFIX, (String[])new String[]{name, "available-connections"}), (Metric)((Gauge)() -> this.getTotalStats().getAvailable()));
        metricRegistry.register(MetricRegistry.name((String)METRICS_PREFIX, (String[])new String[]{name, "leased-connections"}), (Metric)((Gauge)() -> this.getTotalStats().getLeased()));
        metricRegistry.register(MetricRegistry.name((String)METRICS_PREFIX, (String[])new String[]{name, "max-connections"}), (Metric)((Gauge)() -> this.getTotalStats().getMax()));
        metricRegistry.register(MetricRegistry.name((String)METRICS_PREFIX, (String[])new String[]{name, "pending-connections"}), (Metric)((Gauge)() -> this.getTotalStats().getPending()));
    }

    public void close() {
        this.close(CloseMode.GRACEFUL);
    }

    public void close(CloseMode closeMode) {
        super.close(closeMode);
        this.metricsRegistry.remove(MetricRegistry.name((String)METRICS_PREFIX, (String[])new String[]{this.name, "available-connections"}));
        this.metricsRegistry.remove(MetricRegistry.name((String)METRICS_PREFIX, (String[])new String[]{this.name, "leased-connections"}));
        this.metricsRegistry.remove(MetricRegistry.name((String)METRICS_PREFIX, (String[])new String[]{this.name, "max-connections"}));
        this.metricsRegistry.remove(MetricRegistry.name((String)METRICS_PREFIX, (String[])new String[]{this.name, "pending-connections"}));
    }

    public static Builder builder(MetricRegistry metricsRegistry) {
        return new Builder().metricsRegistry(metricsRegistry);
    }

    public static class Builder {
        private MetricRegistry metricsRegistry;
        private String name;
        private Lookup<TlsStrategy> tlsStrategyLookup = InstrumentedAsyncClientConnectionManager.getDefaultTlsStrategy();
        private SchemePortResolver schemePortResolver;
        private DnsResolver dnsResolver;
        private PoolConcurrencyPolicy poolConcurrencyPolicy;
        private PoolReusePolicy poolReusePolicy;
        private TimeValue timeToLive = TimeValue.NEG_ONE_MILLISECOND;

        Builder() {
        }

        public Builder metricsRegistry(MetricRegistry metricRegistry) {
            this.metricsRegistry = Objects.requireNonNull(metricRegistry, "metricRegistry");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder schemePortResolver(SchemePortResolver schemePortResolver) {
            this.schemePortResolver = schemePortResolver;
            return this;
        }

        public Builder dnsResolver(DnsResolver dnsResolver) {
            this.dnsResolver = dnsResolver;
            return this;
        }

        public Builder timeToLive(TimeValue timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        public Builder tlsStrategyLookup(Lookup<TlsStrategy> tlsStrategyLookup) {
            this.tlsStrategyLookup = tlsStrategyLookup;
            return this;
        }

        public Builder poolConcurrencyPolicy(PoolConcurrencyPolicy poolConcurrencyPolicy) {
            this.poolConcurrencyPolicy = poolConcurrencyPolicy;
            return this;
        }

        public Builder poolReusePolicy(PoolReusePolicy poolReusePolicy) {
            this.poolReusePolicy = poolReusePolicy;
            return this;
        }

        public InstrumentedAsyncClientConnectionManager build() {
            return new InstrumentedAsyncClientConnectionManager(this.metricsRegistry, this.name, this.tlsStrategyLookup, this.poolConcurrencyPolicy, this.poolReusePolicy, this.timeToLive, this.schemePortResolver, this.dnsResolver);
        }
    }
}

