/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.httpclient5;

import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.httpclient5.HttpClientMetricNameStrategy;
import java.net.URISyntaxException;
import java.util.Locale;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.net.URIBuilder;

public class HttpClientMetricNameStrategies {
    public static final HttpClientMetricNameStrategy METHOD_ONLY = (name, request) -> MetricRegistry.name(HttpClient.class, (String[])new String[]{name, HttpClientMetricNameStrategies.methodNameString(request)});
    public static final HttpClientMetricNameStrategy HOST_AND_METHOD = (name, request) -> {
        try {
            return MetricRegistry.name(HttpClient.class, (String[])new String[]{name, request.getUri().getHost(), HttpClientMetricNameStrategies.methodNameString(request)});
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    };
    public static final HttpClientMetricNameStrategy QUERYLESS_URL_AND_METHOD = (name, request) -> {
        try {
            URIBuilder url = new URIBuilder(request.getUri());
            return MetricRegistry.name(HttpClient.class, (String[])new String[]{name, url.removeQuery().build().toString(), HttpClientMetricNameStrategies.methodNameString(request)});
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    };

    private static String methodNameString(HttpRequest request) {
        return request.getMethod().toLowerCase(Locale.ROOT) + "-requests";
    }
}

