/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.influxdb;

import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.Gauge;
import io.dropwizard.metrics5.Histogram;
import io.dropwizard.metrics5.Meter;
import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricAttribute;
import io.dropwizard.metrics5.MetricFilter;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.MetricRegistryListener;
import io.dropwizard.metrics5.ScheduledReporter;
import io.dropwizard.metrics5.Timer;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

abstract class GarbageFreeScheduledReporter
extends ScheduledReporter {
    private final MetricRegistry registry;
    private final RegistryMirror mirror;

    protected GarbageFreeScheduledReporter(MetricRegistry registry, String name, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit, ScheduledExecutorService executor, boolean shutdownExecutorOnStop, Set<MetricAttribute> disabledMetricAttributes) {
        super(registry, name, filter, rateUnit, durationUnit, executor, shutdownExecutorOnStop, disabledMetricAttributes);
        this.registry = registry;
        this.mirror = new RegistryMirror(filter);
        registry.addListener((MetricRegistryListener)this.mirror);
    }

    public void stop() {
        try {
            super.stop();
        }
        finally {
            this.registry.removeListener((MetricRegistryListener)this.mirror);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report() {
        GarbageFreeScheduledReporter garbageFreeScheduledReporter = this;
        synchronized (garbageFreeScheduledReporter) {
            this.report(this.mirror.gauges(), this.mirror.counters(), this.mirror.histograms(), this.mirror.meters(), this.mirror.timers());
        }
    }

    private static class RegistryMirror
    implements MetricRegistryListener {
        private final MetricFilter filter;
        private final ConcurrentSkipListMap<MetricName, Gauge> gauges = new ConcurrentSkipListMap();
        private final ConcurrentSkipListMap<MetricName, Counter> counters = new ConcurrentSkipListMap();
        private final ConcurrentSkipListMap<MetricName, Histogram> histograms = new ConcurrentSkipListMap();
        private final ConcurrentSkipListMap<MetricName, Meter> meters = new ConcurrentSkipListMap();
        private final ConcurrentSkipListMap<MetricName, Timer> timers = new ConcurrentSkipListMap();

        RegistryMirror(MetricFilter filter) {
            this.filter = filter;
        }

        SortedMap<MetricName, Gauge> gauges() {
            return this.gauges;
        }

        SortedMap<MetricName, Counter> counters() {
            return this.counters;
        }

        SortedMap<MetricName, Histogram> histograms() {
            return this.histograms;
        }

        SortedMap<MetricName, Meter> meters() {
            return this.meters;
        }

        SortedMap<MetricName, Timer> timers() {
            return this.timers;
        }

        public void onGaugeAdded(MetricName name, Gauge<?> gauge) {
            if (this.filter.matches(name, gauge)) {
                this.gauges.put(name, gauge);
            }
        }

        public void onGaugeRemoved(MetricName name) {
            this.gauges.remove(name);
        }

        public void onCounterAdded(MetricName name, Counter counter) {
            if (this.filter.matches(name, (Metric)counter)) {
                this.counters.put(name, counter);
            }
        }

        public void onCounterRemoved(MetricName name) {
            this.counters.remove(name);
        }

        public void onHistogramAdded(MetricName name, Histogram histogram) {
            if (this.filter.matches(name, (Metric)histogram)) {
                this.histograms.put(name, histogram);
            }
        }

        public void onHistogramRemoved(MetricName name) {
            this.histograms.remove(name);
        }

        public void onMeterAdded(MetricName name, Meter meter) {
            if (this.filter.matches(name, (Metric)meter)) {
                this.meters.put(name, meter);
            }
        }

        public void onMeterRemoved(MetricName name) {
            this.meters.remove(name);
        }

        public void onTimerAdded(MetricName name, Timer timer) {
            if (this.filter.matches(name, (Metric)timer)) {
                this.timers.put(name, timer);
            }
        }

        public void onTimerRemoved(MetricName name) {
            this.timers.remove(name);
        }
    }
}

