/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.influxdb;

import io.dropwizard.metrics5.Clock;
import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.Gauge;
import io.dropwizard.metrics5.Histogram;
import io.dropwizard.metrics5.Meter;
import io.dropwizard.metrics5.Metered;
import io.dropwizard.metrics5.MetricAttribute;
import io.dropwizard.metrics5.MetricFilter;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.Snapshot;
import io.dropwizard.metrics5.Timer;
import io.dropwizard.metrics5.influxdb.GarbageFreeScheduledReporter;
import io.dropwizard.metrics5.influxdb.InfluxDbLineBuilder;
import io.dropwizard.metrics5.influxdb.InfluxDbSender;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxDbReporter
extends GarbageFreeScheduledReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfluxDbReporter.class);
    private static final String VALUE = "value";
    private final Clock clock;
    private final InfluxDbSender sender;
    private final InfluxDbLineBuilder builder;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    public InfluxDbReporter(MetricRegistry registry, InfluxDbSender sender, Clock clock, MetricName prefix, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter, ScheduledExecutorService executor, boolean shutdownExecutorOnStop, Set<MetricAttribute> disabledMetricAttributes) {
        super(registry, "influxdb-reporter", filter, rateUnit, durationUnit, executor, shutdownExecutorOnStop, disabledMetricAttributes);
        this.sender = sender;
        this.clock = clock;
        this.builder = new InfluxDbLineBuilder(disabledMetricAttributes, prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(SortedMap<MetricName, Gauge> gauges, SortedMap<MetricName, Counter> counters, SortedMap<MetricName, Histogram> histograms, SortedMap<MetricName, Meter> meters, SortedMap<MetricName, Timer> timers) {
        long timestamp = this.clock.getTime();
        try {
            this.sender.connect();
            for (Map.Entry<MetricName, Gauge> entry : gauges.entrySet()) {
                this.reportGauge(entry.getKey(), entry.getValue(), timestamp);
            }
            for (Map.Entry<MetricName, Gauge> entry : counters.entrySet()) {
                this.reportCounter(entry.getKey(), (Counter)entry.getValue(), timestamp);
            }
            for (Map.Entry<MetricName, Gauge> entry : histograms.entrySet()) {
                this.reportHistogram(entry.getKey(), (Histogram)entry.getValue(), timestamp);
            }
            for (Map.Entry<MetricName, Gauge> entry : meters.entrySet()) {
                this.reportMetered(entry.getKey(), (Metered)entry.getValue(), timestamp);
            }
            for (Map.Entry<MetricName, Gauge> entry : timers.entrySet()) {
                this.reportTimer(entry.getKey(), (Timer)entry.getValue(), timestamp);
            }
            this.sender.flush();
        }
        catch (IOException e) {
            LOGGER.warn("Unable to report to InfluxDb", (Object)this.sender, (Object)e);
        }
        finally {
            try {
                this.sender.disconnect();
            }
            catch (IOException e) {
                LOGGER.warn("Error disconnecting InfluxDb", (Object)this.sender, (Object)e);
            }
        }
    }

    @Override
    public void stop() {
        try {
            super.stop();
        }
        finally {
            try {
                this.sender.close();
            }
            catch (IOException e) {
                LOGGER.debug("Error disconnecting from InfluxDb", (Throwable)e);
            }
        }
    }

    private void reportTimer(MetricName name, Timer timer, long timestamp) throws IOException {
        Snapshot snapshot = timer.getSnapshot();
        this.builder.writeMeasurement(name).writeFieldIfEnabled(MetricAttribute.MAX, this.convertDuration(snapshot.getMax())).writeFieldIfEnabled(MetricAttribute.MEAN, this.convertDuration(snapshot.getMean())).writeFieldIfEnabled(MetricAttribute.MIN, this.convertDuration(snapshot.getMin())).writeFieldIfEnabled(MetricAttribute.STDDEV, this.convertDuration(snapshot.getStdDev())).writeFieldIfEnabled(MetricAttribute.P50, this.convertDuration(snapshot.getMedian())).writeFieldIfEnabled(MetricAttribute.P75, this.convertDuration(snapshot.get75thPercentile())).writeFieldIfEnabled(MetricAttribute.P95, this.convertDuration(snapshot.get95thPercentile())).writeFieldIfEnabled(MetricAttribute.P98, this.convertDuration(snapshot.get98thPercentile())).writeFieldIfEnabled(MetricAttribute.P99, this.convertDuration(snapshot.get99thPercentile())).writeFieldIfEnabled(MetricAttribute.P999, this.convertDuration(snapshot.get999thPercentile()));
        this.writeMeteredFieldsIfEnabled((Metered)timer).writeTimestampMillis(timestamp);
        this.reportLine();
    }

    private void reportHistogram(MetricName name, Histogram histogram, long timestamp) throws IOException {
        Snapshot snapshot = histogram.getSnapshot();
        this.builder.writeMeasurement(name).writeFieldIfEnabled(MetricAttribute.COUNT, histogram.getCount()).writeFieldIfEnabled(MetricAttribute.SUM, histogram.getSum()).writeFieldIfEnabled(MetricAttribute.MAX, snapshot.getMax()).writeFieldIfEnabled(MetricAttribute.MEAN, snapshot.getMean()).writeFieldIfEnabled(MetricAttribute.MIN, snapshot.getMin()).writeFieldIfEnabled(MetricAttribute.STDDEV, snapshot.getStdDev()).writeFieldIfEnabled(MetricAttribute.P50, snapshot.getMedian()).writeFieldIfEnabled(MetricAttribute.P75, snapshot.get75thPercentile()).writeFieldIfEnabled(MetricAttribute.P95, snapshot.get95thPercentile()).writeFieldIfEnabled(MetricAttribute.P98, snapshot.get98thPercentile()).writeFieldIfEnabled(MetricAttribute.P99, snapshot.get99thPercentile()).writeFieldIfEnabled(MetricAttribute.P999, snapshot.get999thPercentile()).writeTimestampMillis(timestamp);
        this.reportLine();
    }

    private void reportMetered(MetricName name, Metered meter, long timestamp) throws IOException {
        this.builder.writeMeasurement(name);
        this.writeMeteredFieldsIfEnabled(meter).writeTimestampMillis(timestamp);
        this.reportLine();
    }

    private InfluxDbLineBuilder writeMeteredFieldsIfEnabled(Metered meter) {
        return this.builder.writeFieldIfEnabled(MetricAttribute.COUNT, meter.getCount()).writeFieldIfEnabled(MetricAttribute.SUM, meter.getSum()).writeFieldIfEnabled(MetricAttribute.M1_RATE, this.convertRate(meter.getOneMinuteRate())).writeFieldIfEnabled(MetricAttribute.M5_RATE, this.convertRate(meter.getFiveMinuteRate())).writeFieldIfEnabled(MetricAttribute.M15_RATE, this.convertRate(meter.getFifteenMinuteRate())).writeFieldIfEnabled(MetricAttribute.MEAN_RATE, this.convertRate(meter.getMeanRate()));
    }

    private void reportCounter(MetricName name, Counter counter, long timestamp) throws IOException {
        this.builder.writeMeasurement(name).writeFieldIfEnabled(MetricAttribute.COUNT, counter.getCount()).writeTimestampMillis(timestamp);
        this.reportLine();
    }

    private void reportGauge(MetricName name, Gauge<?> gauge, long timestamp) throws IOException {
        this.builder.writeMeasurement(name);
        Object value = gauge.getValue();
        if (value != null) {
            this.builder.writeField(VALUE);
            if (value instanceof Number) {
                Number number = (Number)value;
                if (number instanceof Long || number instanceof Integer || number instanceof Short || number instanceof Byte) {
                    this.builder.writeFieldValue(number.longValue());
                } else {
                    this.builder.writeFieldValue(number.doubleValue());
                }
            } else if (value instanceof Boolean) {
                this.builder.writeFieldValue((Boolean)value);
            } else {
                this.builder.writeFieldValue(value.toString());
            }
        }
        this.builder.writeTimestampMillis(timestamp);
        this.reportLine();
    }

    private void reportLine() throws IOException {
        if (this.builder.hasValues()) {
            this.sender.send(this.builder.get());
        }
    }

    public static class Builder {
        private final MetricRegistry registry;
        private Clock clock;
        private MetricName prefix;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;
        private ScheduledExecutorService executor;
        private boolean shutdownExecutorOnStop;
        private Set<MetricAttribute> disabledMetricAttributes;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.clock = Clock.defaultClock();
            this.prefix = null;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
            this.executor = null;
            this.shutdownExecutorOnStop = true;
            this.disabledMetricAttributes = Collections.emptySet();
        }

        public Builder shutdownExecutorOnStop(boolean shutdownExecutorOnStop) {
            this.shutdownExecutorOnStop = shutdownExecutorOnStop;
            return this;
        }

        public Builder scheduleOn(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder prefixedWith(MetricName prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder disabledMetricAttributes(Set<MetricAttribute> disabledMetricAttributes) {
            this.disabledMetricAttributes = disabledMetricAttributes;
            return this;
        }

        public InfluxDbReporter build(InfluxDbSender sender) {
            return new InfluxDbReporter(this.registry, sender, this.clock, this.prefix, this.rateUnit, this.durationUnit, this.filter, this.executor, this.shutdownExecutorOnStop, this.disabledMetricAttributes);
        }
    }
}

