/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.influxdb;

import io.dropwizard.metrics5.MetricAttribute;
import io.dropwizard.metrics5.MetricName;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

class InfluxDbLineBuilder {
    private final StringBuilder str = new StringBuilder();
    private boolean firstField;
    private final Set<MetricAttribute> disabledMetricAttributes;
    private final MetricName prefix;
    private final Map<MetricName, String> encodedNameCache = new WeakHashMap<MetricName, String>();

    InfluxDbLineBuilder(Set<MetricAttribute> disabledMetricAttributes, MetricName prefix) {
        this.disabledMetricAttributes = disabledMetricAttributes;
        this.prefix = prefix != null ? prefix : MetricName.empty();
    }

    InfluxDbLineBuilder writeMeasurement(MetricName name) {
        this.str.setLength(0);
        this.str.append(this.encodedNameCache.computeIfAbsent(name, this::writeMeasurementNoCache));
        this.str.append(' ');
        this.firstField = true;
        return this;
    }

    private String writeMeasurementNoCache(MetricName name) {
        StringBuilder sb = new StringBuilder();
        MetricName prefixedName = this.prefix.append(name);
        InfluxDbLineBuilder.appendName(prefixedName.getKey(), sb);
        for (Map.Entry tag : prefixedName.getTags().entrySet()) {
            sb.append(',');
            InfluxDbLineBuilder.appendName((CharSequence)tag.getKey(), sb);
            sb.append('=');
            InfluxDbLineBuilder.appendName((CharSequence)tag.getValue(), sb);
        }
        return sb.toString();
    }

    InfluxDbLineBuilder writeField(MetricAttribute key) {
        if (!this.firstField) {
            this.str.append(',');
        }
        this.str.append(key.getCode()).append('=');
        this.firstField = false;
        return this;
    }

    InfluxDbLineBuilder writeField(String key) {
        if (!this.firstField) {
            this.str.append(',');
        }
        InfluxDbLineBuilder.appendName(key, this.str);
        this.str.append('=');
        this.firstField = false;
        return this;
    }

    InfluxDbLineBuilder writeFieldValue(double value) {
        this.str.append(value);
        return this;
    }

    InfluxDbLineBuilder writeFieldValue(long value) {
        this.str.append(value).append('i');
        return this;
    }

    InfluxDbLineBuilder writeFieldValue(String value) {
        this.str.append('\"');
        InfluxDbLineBuilder.appendString(value, this.str);
        this.str.append('\"');
        return this;
    }

    InfluxDbLineBuilder writeFieldValue(boolean value) {
        this.str.append(value ? (char)'t' : 'f');
        return this;
    }

    InfluxDbLineBuilder writeTimestampMillis(long utcMillis) {
        this.str.append(' ').append(utcMillis).append("000000\n");
        return this;
    }

    InfluxDbLineBuilder writeFieldIfEnabled(MetricAttribute key, double value) {
        if (!this.disabledMetricAttributes.contains(key)) {
            this.writeField(key);
            this.writeFieldValue(value);
        }
        return this;
    }

    InfluxDbLineBuilder writeFieldIfEnabled(MetricAttribute key, long value) {
        if (!this.disabledMetricAttributes.contains(key)) {
            this.writeField(key);
            this.writeFieldValue(value);
        }
        return this;
    }

    boolean hasValues() {
        return !this.firstField;
    }

    StringBuilder get() {
        return this.str;
    }

    private static void appendName(CharSequence field, StringBuilder dst) {
        int len = field.length();
        for (int i = 0; i < len; ++i) {
            char ch = field.charAt(i);
            if (ch == ',' || ch == '=' || ch == ' ') {
                dst.append('\\');
            }
            dst.append(ch);
        }
    }

    private static void appendString(CharSequence field, StringBuilder dst) {
        int len = field.length();
        for (int i = 0; i < len; ++i) {
            char ch = field.charAt(i);
            if (ch == '\"') {
                dst.append('\\');
            }
            dst.append(ch);
        }
    }
}

