/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.influxdb;

import io.dropwizard.metrics5.influxdb.InfluxDbSender;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Objects;

public class InfluxDbUdpSender
implements InfluxDbSender {
    private final InetSocketAddress address;
    private int mtu = 1500;
    private DatagramChannel datagramChannel;
    private ByteBuffer byteBuf;
    private CharBuffer charBuf;
    private final CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);

    public InfluxDbUdpSender(String hostname, int port) {
        this(new InetSocketAddress(hostname, port));
    }

    public InfluxDbUdpSender(InetSocketAddress address) {
        this.address = Objects.requireNonNull(address);
        this.charBuf = CharBuffer.allocate(this.mtu * 2);
        this.byteBuf = ByteBuffer.allocate(this.mtu * 2);
    }

    void setMTU(int mtu) {
        this.mtu = mtu;
    }

    void setDatagramChannel(DatagramChannel datagramChannel) {
        this.datagramChannel = datagramChannel;
    }

    @Override
    public void connect() throws IllegalStateException, IOException {
        if (this.datagramChannel == null) {
            this.datagramChannel = DatagramChannel.open();
        }
        this.byteBuf.clear();
    }

    @Override
    public boolean isConnected() {
        return this.datagramChannel != null;
    }

    @Override
    public void disconnect() throws IOException {
    }

    @Override
    public void close() throws IOException {
        try {
            this.datagramChannel.close();
        }
        finally {
            this.datagramChannel = null;
        }
    }

    @Override
    public void send(StringBuilder str) throws IOException {
        int len = this.byteBuf.position();
        this.encode(str);
        int len2 = this.byteBuf.position();
        if (len2 >= this.mtu) {
            if (len == 0) {
                this.sendBuffer();
                this.byteBuf.clear();
            } else {
                this.byteBuf.position(len);
                this.sendBuffer();
                this.byteBuf.limit(len2);
                this.byteBuf.compact();
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.byteBuf.position() > 0) {
            this.sendBuffer();
            this.byteBuf.clear();
        }
    }

    private void sendBuffer() throws IOException {
        this.byteBuf.flip();
        this.datagramChannel.send(this.byteBuf, this.address);
    }

    private void encode(StringBuilder str) {
        CoderResult result;
        if (this.charBuf.capacity() < str.length()) {
            this.charBuf = CharBuffer.allocate(str.length());
        } else {
            this.charBuf.clear();
        }
        str.getChars(0, str.length(), this.charBuf.array(), this.charBuf.arrayOffset());
        this.charBuf.limit(str.length());
        this.encoder.reset();
        while ((result = this.encoder.encode(this.charBuf, this.byteBuf, true)).isOverflow()) {
            ByteBuffer byteBuf2 = ByteBuffer.allocate(this.byteBuf.capacity() * 2);
            this.byteBuf.flip();
            byteBuf2.put(this.byteBuf);
            this.byteBuf = byteBuf2;
        }
    }
}

