/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.jdbi.strategies;

import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.jdbi.strategies.NameStrategies;
import io.dropwizard.metrics5.jdbi.strategies.StatementNameStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.skife.jdbi.v2.StatementContext;

public abstract class DelegatingStatementNameStrategy
implements StatementNameStrategy {
    private final List<StatementNameStrategy> strategies = new ArrayList<StatementNameStrategy>();

    protected DelegatingStatementNameStrategy(StatementNameStrategy ... strategies) {
        this.registerStrategies(strategies);
    }

    protected void registerStrategies(StatementNameStrategy ... strategies) {
        this.strategies.addAll(Arrays.asList(strategies));
    }

    @Override
    public MetricName getStatementName(StatementContext statementContext) {
        for (StatementNameStrategy strategy : this.strategies) {
            MetricName statementName = strategy.getStatementName(statementContext);
            if (statementName == null) continue;
            return statementName;
        }
        return NameStrategies.UNKNOWN_SQL;
    }
}

