/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.jdbi;

import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.Timer;
import io.dropwizard.metrics5.jdbi.strategies.SmartNameStrategy;
import io.dropwizard.metrics5.jdbi.strategies.StatementNameStrategy;
import java.util.concurrent.TimeUnit;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.TimingCollector;

public class InstrumentedTimingCollector
implements TimingCollector {
    private final MetricRegistry registry;
    private final StatementNameStrategy statementNameStrategy;

    public InstrumentedTimingCollector(MetricRegistry registry) {
        this(registry, new SmartNameStrategy());
    }

    public InstrumentedTimingCollector(MetricRegistry registry, StatementNameStrategy statementNameStrategy) {
        this.registry = registry;
        this.statementNameStrategy = statementNameStrategy;
    }

    public void collect(long elapsedTime, StatementContext ctx) {
        Timer timer = this.getTimer(ctx);
        timer.update(elapsedTime, TimeUnit.NANOSECONDS);
    }

    private Timer getTimer(StatementContext ctx) {
        return this.registry.timer(this.statementNameStrategy.getStatementName(ctx));
    }
}

