/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.jetty9;

import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.Meter;
import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.RatioGauge;
import io.dropwizard.metrics5.Timer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.server.AsyncContextState;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.Request;

public class InstrumentedHttpChannelListener
implements HttpChannel.Listener {
    private static final String START_ATTR = InstrumentedHttpChannelListener.class.getName() + ".start";
    private final MetricRegistry metricRegistry;
    private final Timer requests;
    private final Timer dispatches;
    private final Counter activeRequests;
    private final Counter activeDispatches;
    private final Counter activeSuspended;
    private final Meter asyncDispatches;
    private final Meter asyncTimeouts;
    private final Meter[] responses;
    private final Timer getRequests;
    private final Timer postRequests;
    private final Timer headRequests;
    private final Timer putRequests;
    private final Timer deleteRequests;
    private final Timer optionsRequests;
    private final Timer traceRequests;
    private final Timer connectRequests;
    private final Timer moveRequests;
    private final Timer otherRequests;
    private final AsyncListener listener;

    public InstrumentedHttpChannelListener(MetricRegistry registry) {
        this(registry, null);
    }

    public InstrumentedHttpChannelListener(MetricRegistry registry, MetricName pref) {
        this.metricRegistry = registry;
        MetricName prefix = pref == null ? MetricName.build((String[])new String[]{this.getClass().getName()}) : pref;
        this.requests = this.metricRegistry.timer(prefix.resolve(new String[]{"requests"}));
        this.dispatches = this.metricRegistry.timer(prefix.resolve(new String[]{"dispatches"}));
        this.activeRequests = this.metricRegistry.counter(prefix.resolve(new String[]{"active-requests"}));
        this.activeDispatches = this.metricRegistry.counter(prefix.resolve(new String[]{"active-dispatches"}));
        this.activeSuspended = this.metricRegistry.counter(prefix.resolve(new String[]{"active-suspended"}));
        this.asyncDispatches = this.metricRegistry.meter(prefix.resolve(new String[]{"async-dispatches"}));
        this.asyncTimeouts = this.metricRegistry.meter(prefix.resolve(new String[]{"async-timeouts"}));
        this.responses = new Meter[]{this.metricRegistry.meter(prefix.resolve(new String[]{"1xx-responses"})), this.metricRegistry.meter(prefix.resolve(new String[]{"2xx-responses"})), this.metricRegistry.meter(prefix.resolve(new String[]{"3xx-responses"})), this.metricRegistry.meter(prefix.resolve(new String[]{"4xx-responses"})), this.metricRegistry.meter(prefix.resolve(new String[]{"5xx-responses"}))};
        this.getRequests = this.metricRegistry.timer(prefix.resolve(new String[]{"get-requests"}));
        this.postRequests = this.metricRegistry.timer(prefix.resolve(new String[]{"post-requests"}));
        this.headRequests = this.metricRegistry.timer(prefix.resolve(new String[]{"head-requests"}));
        this.putRequests = this.metricRegistry.timer(prefix.resolve(new String[]{"put-requests"}));
        this.deleteRequests = this.metricRegistry.timer(prefix.resolve(new String[]{"delete-requests"}));
        this.optionsRequests = this.metricRegistry.timer(prefix.resolve(new String[]{"options-requests"}));
        this.traceRequests = this.metricRegistry.timer(prefix.resolve(new String[]{"trace-requests"}));
        this.connectRequests = this.metricRegistry.timer(prefix.resolve(new String[]{"connect-requests"}));
        this.moveRequests = this.metricRegistry.timer(prefix.resolve(new String[]{"move-requests"}));
        this.otherRequests = this.metricRegistry.timer(prefix.resolve(new String[]{"other-requests"}));
        this.metricRegistry.register(prefix.resolve(new String[]{"percent-4xx-1m"}), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)InstrumentedHttpChannelListener.this.responses[3].getOneMinuteRate(), (double)InstrumentedHttpChannelListener.this.requests.getOneMinuteRate());
            }
        });
        this.metricRegistry.register(prefix.resolve(new String[]{"percent-4xx-5m"}), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)InstrumentedHttpChannelListener.this.responses[3].getFiveMinuteRate(), (double)InstrumentedHttpChannelListener.this.requests.getFiveMinuteRate());
            }
        });
        this.metricRegistry.register(prefix.resolve(new String[]{"percent-4xx-15m"}), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)InstrumentedHttpChannelListener.this.responses[3].getFifteenMinuteRate(), (double)InstrumentedHttpChannelListener.this.requests.getFifteenMinuteRate());
            }
        });
        this.metricRegistry.register(prefix.resolve(new String[]{"percent-5xx-1m"}), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)InstrumentedHttpChannelListener.this.responses[4].getOneMinuteRate(), (double)InstrumentedHttpChannelListener.this.requests.getOneMinuteRate());
            }
        });
        this.metricRegistry.register(prefix.resolve(new String[]{"percent-5xx-5m"}), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)InstrumentedHttpChannelListener.this.responses[4].getFiveMinuteRate(), (double)InstrumentedHttpChannelListener.this.requests.getFiveMinuteRate());
            }
        });
        this.metricRegistry.register(prefix.resolve(new String[]{"percent-5xx-15m"}), (Metric)new RatioGauge(){

            public RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)InstrumentedHttpChannelListener.this.responses[4].getFifteenMinuteRate(), (double)InstrumentedHttpChannelListener.this.requests.getFifteenMinuteRate());
            }
        });
        this.listener = new AsyncAttachingListener();
    }

    public void onRequestBegin(Request request) {
    }

    public void onBeforeDispatch(Request request) {
        this.before(request);
    }

    public void onDispatchFailure(Request request, Throwable failure) {
    }

    public void onAfterDispatch(Request request) {
        this.after(request);
    }

    public void onRequestContent(Request request, ByteBuffer content) {
    }

    public void onRequestContentEnd(Request request) {
    }

    public void onRequestTrailers(Request request) {
    }

    public void onRequestEnd(Request request) {
    }

    public void onRequestFailure(Request request, Throwable failure) {
    }

    public void onResponseBegin(Request request) {
    }

    public void onResponseCommit(Request request) {
    }

    public void onResponseContent(Request request, ByteBuffer content) {
    }

    public void onResponseEnd(Request request) {
    }

    public void onResponseFailure(Request request, Throwable failure) {
    }

    public void onComplete(Request request) {
    }

    private void before(Request request) {
        long start;
        this.activeDispatches.inc();
        HttpChannelState state = request.getHttpChannelState();
        if (state.isInitial()) {
            this.activeRequests.inc();
            start = request.getTimeStamp();
            state.addListener(this.listener);
        } else {
            start = System.currentTimeMillis();
            this.activeSuspended.dec();
            if (state.isAsyncStarted()) {
                this.asyncDispatches.mark();
            }
        }
        request.setAttribute(START_ATTR, (Object)start);
    }

    private void after(Request request) {
        long start = (Long)request.getAttribute(START_ATTR);
        long now = System.currentTimeMillis();
        long dispatched = now - start;
        this.activeDispatches.dec();
        this.dispatches.update(dispatched, TimeUnit.MILLISECONDS);
        HttpChannelState state = request.getHttpChannelState();
        if (state.isSuspended()) {
            this.activeSuspended.inc();
        } else if (state.isInitial()) {
            this.updateResponses((HttpServletRequest)request, (HttpServletResponse)request.getResponse(), start, request.isHandled());
        }
    }

    private void updateResponses(HttpServletRequest request, HttpServletResponse response, long start, boolean isHandled) {
        int responseStatus = isHandled ? response.getStatus() / 100 : 4;
        if (responseStatus >= 1 && responseStatus <= 5) {
            this.responses[responseStatus - 1].mark();
        }
        this.activeRequests.dec();
        long elapsedTime = System.currentTimeMillis() - start;
        this.requests.update(elapsedTime, TimeUnit.MILLISECONDS);
        this.requestTimer(request.getMethod()).update(elapsedTime, TimeUnit.MILLISECONDS);
    }

    private Timer requestTimer(String method) {
        HttpMethod m = HttpMethod.fromString((String)method);
        if (m == null) {
            return this.otherRequests;
        }
        switch (m) {
            case GET: {
                return this.getRequests;
            }
            case POST: {
                return this.postRequests;
            }
            case PUT: {
                return this.putRequests;
            }
            case HEAD: {
                return this.headRequests;
            }
            case DELETE: {
                return this.deleteRequests;
            }
            case OPTIONS: {
                return this.optionsRequests;
            }
            case TRACE: {
                return this.traceRequests;
            }
            case CONNECT: {
                return this.connectRequests;
            }
            case MOVE: {
                return this.moveRequests;
            }
        }
        return this.otherRequests;
    }

    private class InstrumentedAsyncListener
    implements AsyncListener {
        private final long startTime = System.currentTimeMillis();

        InstrumentedAsyncListener() {
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            InstrumentedHttpChannelListener.this.asyncTimeouts.mark();
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onComplete(AsyncEvent event) throws IOException {
            AsyncContextState state = (AsyncContextState)event.getAsyncContext();
            HttpServletRequest request = (HttpServletRequest)state.getRequest();
            HttpServletResponse response = (HttpServletResponse)state.getResponse();
            InstrumentedHttpChannelListener.this.updateResponses(request, response, this.startTime, true);
            if (!state.getHttpChannelState().isSuspended()) {
                InstrumentedHttpChannelListener.this.activeSuspended.dec();
            }
        }
    }

    private class AsyncAttachingListener
    implements AsyncListener {
        private AsyncAttachingListener() {
        }

        public void onTimeout(AsyncEvent event) throws IOException {
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
            event.getAsyncContext().addListener((AsyncListener)new InstrumentedAsyncListener());
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onComplete(AsyncEvent event) throws IOException {
        }
    }
}

